# -----------------------------------------------------------------------------
# Programm         : G E D f h i s t . p m
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Erstellt         : 14. Februar 2003
# Zuletzt gendert : 09. Februar 2004
# Aufgabe          : Verwaltung der letzten X bearbeiteten Dateien.
# -----------------------------------------------------------------------------

package Graph::GED::FHist;

use strict;
use warnings;

#
# Von Exporter erben:
#
use Exporter;
our @ISA = ('Exporter'); # Inherit from Exporter
our @EXPORT_OK = qw(load save add array);


my $Anzahl = 10;                     # Anzahl zu merkender Dateien
my $Fname  = 'ged_last_edited.txt';  # Name der Datei, unter der
                                     # die Dateien geladen / gespeichert
                                     # werden
my @Fhist;                           # Array mit den Dateinamen

my $Debug = 0;                       # Debugausgaben in diesem Modul


# -----------------------------------------------------------------------------
# sub          : l o a d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ldt die Liste mit den historischen Dateien.
# Parameter    : text
# Rckgabewert : text
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub load {
    print "GEDfhist::load\n" if $Debug;

    @Fhist = ();

    open IN, $Fname or return;
    my $c = 0;
    while (<IN>) {
        chomp;
        push @Fhist, $_;
        ++$c;
        last if $c == $Anzahl;
    }
} # sub load


# -----------------------------------------------------------------------------
# sub          : s a v e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Speichert die historischen Dateien.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub save {
    print "GEDfhist::save\n" if $Debug;
    open OUT, ">$Fname" or die "Kann Datei '$Fname' nicht zum Speichern " .
                               "ffnen: $!";
    for (1..min($Anzahl, scalar @Fhist)) {
        print OUT $Fhist[$_-1], "\n";
    }
} # sub save


# -----------------------------------------------------------------------------
# sub          : a d d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Fgt einen weiteren Namen in die Historie ein
# Parameter    : Dateiname
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub add {
    my $f = shift;
    print "GEDfhist::add - neue Datei = '$f'\n" if $Debug;

    # Nach vorhandenen gleichen Eintrgen suchen und lschen:
    for my $i (reverse (0..$#Fhist)) {
        splice(@Fhist, $i, 1) if $f eq $Fhist[$i];
    }

    # Neuen Eintrag anhngen:
    push @Fhist, $f;

    # Falls es mehr als $Anzahl sind, ersten lschen:
    splice(@Fhist, 0, 1) if scalar @Fhist > $Anzahl;
} # sub add


# -----------------------------------------------------------------------------
# sub          : a r r a y
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Gibt ein Array mit den historischen Dateinamen aus.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub array {
    print "GEDfhist::array\n" if $Debug;
    return @Fhist;
} # sub array


# -----------------------------------------------------------------------------
# sub          : m i n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Bestimmt das Minimum zweier Zahlen
# Parameter    : zwei Zahlen
# Rckgabewert : die kleinere Zahl
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub min {
    print "GEDfhist::min\n" if $Debug;
    my $l = shift;
    my $r = shift;

    return $r if $r<$l;
    return $l;
} # sub max


# -----------------------------------------------------------------------------
# sub          : m a x
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Bestimmt das Maximum zweier Zahlen
# Parameter    : zwei Zahlen
# Rckgabewert : die grere Zahl
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------
sub max {
    print "GEDfhist::max\n" if $Debug;
    my $l = shift;
    my $r = shift;

    return $r if $r>$l;
    return $l;
} # sub max


return 1;

__END__

=head1 NAME

GEDfhist.pm - a module for a file history, used in a "file"-Menu

=head1 COPYRIGHT


Copyright 2004 Christian Duehl. All rights reserved.

This library is free software. You can redistribute it and/or
modify it under the same terms as perl itself.

=cut
