# -----------------------------------------------------------------------------
# Programm         : G E D g e o m . p m
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Erstellt         : 08. Februar 2004
# Zuletzt gendert : 09. Februar 2004
# Aufgabe          : Geometrische Hilfsfunktionen.
# -----------------------------------------------------------------------------

package Graph::GED::Geom;

use strict;
use warnings;

use Exporter;

#------------------------------------------------------------------------------
# Von Exporter erben:
#------------------------------------------------------------------------------
our @ISA = ('Exporter');
our @EXPORT_OK = qw(
                    abstand_punkt_linie
                    punkt_abstand
                   );

# -----------------------------------------------------------------------------
# Globale private Datei-Variablen:
# -----------------------------------------------------------------------------
my $Debug  = 1;


sub abstand_punkt_linie ($$$$$$) {
# -----------------------------------------------------------------------------
# sub          : a b s t a n d _ p u n k t _ l i n i e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Berechnet den Abstand des Punktes zur Strecke.
# Parameter    : x,y   : Koordinaten des Punktes
#                ax,ay : Koordinaten des ersten Punktes der Strecke
#                bx,by : Koordinaten des zweiten Punktes der Strecke
# Rckgabewert : Anstand
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    my $x  = shift; # X-Koordinate des Punktes
    my $y  = shift; # Y-Koordinate des Punktes
    my $ax = shift; # X-Koordinate des ersten Punktes der Strecke
    my $ay = shift; # Y-Koordinate des ersten Punktes der Strecke
    my $bx = shift; # X-Koordinate des zweiten Punktes der Strecke
    my $by = shift; # Y-Koordinate des zweiten Punktes der Strecke


    # -------------------------------------------------------------------------
    # Falsche Aufrufe abfangen:
    # -------------------------------------------------------------------------
    return -1 unless defined $x  and
                     defined $y  and
                     defined $ax and
                     defined $ay and
                     defined $bx and
                     defined $by;

    print "abstand_punkt_linie: P=($x,$y), S1=($ax,$ay), S2=($bx,$by)\n"
        if $Debug > 1;

    # -------------------------------------------------------------------------
    # Koordinaten drehen, so dass die Strecke von links unten nach rechts oben
    # verluft:
    # -------------------------------------------------------------------------
    my $drehx = 1;
    my $drehy = 1;

    $drehx = -1 if $bx < $ax;
    $drehy = -1 if $by < $ay;

    $x  *= $drehx;
    $ax *= $drehx;
    $bx *= $drehx;

    $y  *= $drehy;
    $ay *= $drehy;
    $by *= $drehy;

    # -------------------------------------------------------------------------
    # Sonderflle behandeln:
    # -------------------------------------------------------------------------

    # 1) Senkrechte Linie:
    if ($ax == $bx) {
        #
        # *
        #    *
        #    |
        #    *
        #
        if ($y < $ay) {
            print "RETURN-FALL 1\n" if $Debug > 2;
            return punkt_abstand($x, $y, $ax, $ay);
        }
        #
        #    *
        #    |
        #    *
        # *
        #
        elsif ($y > $by) {
            print "RETURN-FALL 2\n" if $Debug > 2;
            return punkt_abstand($x, $y, $bx, $by);
        }
        #
        #    *
        # *  |
        #    *
        #
        else {
            print "RETURN-FALL 3\n" if $Debug > 2;
            return abs($x-$ax);
        }
    }

    # 2) Waagerechte Linie:
    if ($ay == $by) {
        #
        # *
        #    *---*
        #
        if ($x < $ax) {
            print "RETURN-FALL 4\n" if $Debug > 2;
            return punkt_abstand($x, $y, $ax, $ay);
        }
        #
        #            *
        #    *---*
        #
        elsif ($x > $bx) {
            print "RETURN-FALL 5\n" if $Debug > 2;
            return punkt_abstand($x, $y, $bx, $by);
        }
        #
        #      *
        #    *---*
        #
        else {
            print "RETURN-FALL 6\n" if $Debug > 2;
            return abs($y-$ay);
        }
    }

    # -------------------------------------------------------------------------
    # Abstand im Standardfall berechnen:
    # (jetzt gilt ax < bx und ay < by)
    # -------------------------------------------------------------------------

    # Vorgehensweise: L = linker Endpunkt der Strecke,
    #                 R = rechter Endpunkt der Strecke,
    #                 M = Mittelpunkt,
    #                 schlechtesten Punkt rauswerfen, Endpunkt verschieben,
    #                 dann neuen Mittelpunkt berechnen.

    my $lx = $ax;
    my $ly = $ay;
    my $rx = $bx;
    my $ry = $by;

    my $count = 0;

    while ($lx<$rx or $ly<$ry) {
        # Mittelpunkte neu berechnen:
        my $mx = floor(($rx+$lx)/2);
        my $my = floor(($ry+$ly)/2);

        # !!! Mit dem floor funktioniert es nur mit ganzen Zahlen !!!
        #     (fr Bildschirmkoordinaten (Pixel) ist das ok!)

        ++$count;
        print "Schritt $count, L=($lx,$ly), M=($mx,$my), R=($rx,$ry)\n"
            if $Debug > 2;


        if ($x == $lx and $y == $ly or
            $x == $mx and $y == $my or
            $x == $rx and $y == $ry  ) {
            print "RETURN-FALL 7\n" if $Debug > 2;
            return 0;
        }

        # Abstnde des Punktes zu L, M und R berechnen:
        my $ab_pl = punkt_abstand($x, $y, $lx, $ly);
        my $ab_pm = punkt_abstand($x, $y, $mx, $my);
        my $ab_pr = punkt_abstand($x, $y, $rx, $ry);

        if ($mx == $lx and $my == $ly or
            $mx == $rx and $my == $ry  ) {
            print "RETURN-FALL 8\n" if $Debug > 2;
            return $ab_pm;
        }
        # Dies kann passieren wegen floor...

        print "Abstnde: abs(P,L)=$ab_pl, abs(P,M)=$ab_pm, abs(P,R)=$ab_pr\n"
            if $Debug > 2;

        # PL == PR:
        if ($ab_pl == $ab_pr) {
            print "RETURN-FALL 9\n" if $Debug > 2;
            return $ab_pm;
        }
        # PL < PR:
        elsif ($ab_pl < $ab_pr) {
            # R durch M ersetzen:
            $rx = $mx;
            $ry = $my;
        }
        # PL > PR:
        else { # $ab_pl > $ab_pr
            # L durch M ersetzen:
            $lx = $mx;
            $ly = $my;
        }
    }

    print "RETURN-FALL 10 - ERROR!!!\n" if $Debug > 2;
    return -1;
} # sub abstand_punkt_linie


sub punkt_abstand ($$$$) {
# -----------------------------------------------------------------------------
# sub          : p u n k t _ a b s t a n d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Berechnet den Abstand zweier Punkte.
# Parameter    : ax,ay : Koordinaten des ersten Punktes
#                bx,by : Koordinaten des zweiten Punktes
# Rckgabewert : Anstand
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------

    my $ax = shift; # X-Koordinate des ersten Punktes
    my $ay = shift; # Y-Koordinate des ersten Punktes
    my $bx = shift; # X-Koordinate des zweiten Punktes
    my $by = shift; # Y-Koordinate des zweiten Punktes

    return -1 unless defined $ax and
                     defined $ay and
                     defined $bx and
                     defined $by;

    return abs($ax-$bx) if $ay == $by;
    return abs($ay-$by) if $ax == $bx;
    return sqrt(($ax-$bx)*($ax-$bx) + ($ay-$by)*($ay-$by));
} # sub punkt_abstand


sub floor ($) {
# -----------------------------------------------------------------------------
# sub          : f l o o r
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Die mathematische Funktion Floor.
# Parameter    : Zahl Z
# Rckgabewert : Die grte ganze Zahl G, fr die gilt G <= Z.
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2003 - CD - Erstellt
# -----------------------------------------------------------------------------

    my $z = shift;

    return int($z) if $z >= 0;
    return int($z)==$z ? $z : -int(-$z)-1;
} # sub floor

return 1;

__END__

=head1 NAME

GEDgeom.pm - a module with a few geometrical methods

=head1 COPYRIGHT


Copyright 2004 Christian Duehl. All rights reserved.

This library is free software. You can redistribute it and/or
modify it under the same terms as perl itself.

=cut
