# -----------------------------------------------------------------------------
# Programm         : G r a p h 2 d . p m
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Erstellt         : 08. Februar 2004
# Zuletzt gendert : 10. Februar 2004
# Aufgabe          : Graphenklasse mit Koordinaten fr zweidimensionale
#                    Darstelung.
# -----------------------------------------------------------------------------

#
# Falls man irgendwann dreidimensionale Koordinaten will, sollte man die
# Koordinaten als eigene Klasse auslagern und diese Klasse parametrisieren.
# (und an die Abstnde denken ....)
#

#
# TODO:
#
# Methoden zum setzen und auslesen von Arraywerten von Auerhalb, der direkte
# Zugriff ist sehr unschn. Dito auf Radius am Setter/Getter vorbei, aber wie
# soll man die Bindung an Tk anders machen?

# -----------------------------------------------------------------------------
# Globale private Datei-Variablen:
# -----------------------------------------------------------------------------
my $Debug  = 2;


# -----------------------------------------------------------------------------
# Klasse           : G r a p h 2 d
# abgeleitet von   : Graph
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Aufgabe          : Eine Graphen-Klasse zur zweidimensionalen Darstellung.
# Attribute        : radius      - Gre der gezeichneten cken
#                                  (Radius == 3 -> Kreis in 7x7 Pixeln)
#                    delta       - Abstand, den Ecken voneinander haben mssen,
#                                  innerhalb dieses Abstandes werden auch
#                                  Klicks der entsprechenden Ecke zugeordnet.
#                                  Wird mit der Funktion r2d() berechnet.
#                    eckenfarbe  - Farbe der Ecken (default: rot)
#                    kantenfarbe - Farbe der Kanten (default: schwarz)
#                    _ecken      - anonymes Array von Ecke-Objekten
# Klassen-Methoden : new         - Erstellt ein Objekt dieser Klasse.
# Objekt-Methoden  : radius                - Getter / Setter
#                    delta                 - Getter / Setter
#                    eckenfarbe            - Getter / Setter
#                    kantenfarbe           - Getter / Setter
#                    _ecken                - Interner Getter / Setter
#                    setze_ecken           - Ersetzt die Eckenmenge
#                    loesche_ecken         - Lscht die Eckenmenge
#                    ecke                  - Getter/Setter ber Index fr
#                                            eine Ecke aus der Menge
#                    entnehme_ecke         - spliced eine Ecke heraus
#                    fuege_ecke_hinzu      - pushed eine Ecke hinzu
#                    ecke_einfuegen        - Ecke einfgen
#                    ecke_loeschen         - Ecke lschen
#                    ecke_mergen           - Ecke mergen (Ecke wird gelscht
#                                            und die Nachbarn der Ecke alle
#                                            miteinander durch Kanten ver-
#                                            bunden)
#                    clear                 - Lscht alles.
#                    ecke_zu_nah           - Testet, ob ein Koordinatenpaar zu
#                                            nah an einer der vorhandenen
#                                            Ecke ist (anhand der Koordinaten
#                                            und delta).
#                    ecke_zu_nah_ohne      - Wie ecke_zu_nah unter Ausschlu
#                                            einer angegebenen Ecke (zum
#                                            Test beim Verschieben von Ecken).
#                    meint_ecke            - Testet, ob ein Koordinatenpaar
#                                            eindeutig eine Ecke meint.
#                    meint_kante           - Testet, ob ein Koordinatenpaar
#                                            eindeutig eine Kante meint.
#                    r2d                   - Berechnet delta aus dem Radius.
#                    struktur_einfuegen    - Fgt eine angegebene Struktur wie
#                                            etwa den K_5 in den Graphen ein.
#                    erzeuge_liniengraphen - Erzeugt aus dem Graphen seinen
#                                            Liniengraphen.
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------
package Graph::GED::Graph2d;

use strict;
use warnings;

use Graph::GED::Graph;
use Graph::GED::Geom;
use Graph::GED::Ecke;

# -----------------------------------------------------------------------------
# Globale ffentliche Klassen-Variablen:
# -----------------------------------------------------------------------------
our @ISA   = ('Graph::GED::Graph');

our $MinX  = -1;    # Diese Variablen geben die minimalen und
our $MaxX  = -1;    # maximalen Koordinaten der Zeichenflche an.
our $MinY  = -1;    # Diese Werte mssen vom Programm gesetzt
our $MaxY  = -1;    # werden, das Graph2d verwendet.


sub new {
# -----------------------------------------------------------------------------
# Methode      : n e w
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Beschreibung : Erzeugt ein neues Graph-Objekt (oder ein Objekt einer Klasse,
#                die von dieser Klasse abgeleitet wurde und uns bittet, das
#                Objekt fr sie zu erzeugen).
# Parameter    : 1) Klasse
#                Und ggf. Attribute: siehe Klassenbeschreibung oben
# Rckgabewert : Das geblesste neue Objekt.
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    my $self  = shift;
    my $class = (ref $self) || $self;

    #--------------------------------------------------------------------------
    # Ausgabe der Aufrufparameter:
    #--------------------------------------------------------------------------
    print "Graph2d::new\n",
          "\tself       = '$self'\n",
          "\tclass      = '$class'\n",
          "\tParameter  = @_\n",
          if $Debug > 1;


    $self = $class->SUPER::new(@_);


    #--------------------------------------------------------------------------
    # Nun setzen wir noch ein paar Attribute:
    #--------------------------------------------------------------------------
    $self->radius     (3);
    $self->delta      (-1);
    $self->eckenfarbe ('#FF0000');
    $self->kantenfarbe('#000000');
    $self->_ecken     ([]);


    #--------------------------------------------------------------------------
    # ... und geben das erzeugte Objekt zurck:
    #--------------------------------------------------------------------------
    return $self;

} # sub Graph2d::new

# -----------------------------------------------------------------------------
# The getter/setter methods:
# -----------------------------------------------------------------------------
sub radius      { return shift->_property('radius',      @_) }
sub delta       { return shift->_property('delta',       @_) }
sub eckenfarbe  { return shift->_property('eckenfarbe',  @_) }
sub kantenfarbe { return shift->_property('kantenfarbe', @_) }
sub _ecken      { return shift->_property('_ecken',      @_) }



# =============================================================================
#
#
#   H I L F S M E T H O D E N
#
#   (nur diese verwenden _ecken)
#
# =============================================================================

sub setze_ecken {
# -----------------------------------------------------------------------------
# Methode      : s e t z e _ e c k e n
# Klasse       : Graph
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Ersetzt die gesamte Eckenmenge.
#                Die alte Menge wird vorher durch das Setzen auf undef
#                freigegeben
# Parameter    : Referenz auf Array (mit Ecke-Objekten)
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    $_[0]->_ecken(undef);
    $_[0]->_ecken($_[1]);

} # sub setze_ecken


sub loesche_ecken {
# -----------------------------------------------------------------------------
# Methode      : l o e s c h e _ e c k e n
# Klasse       : Graph
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Setzt die gesamte Eckenmenge auf eine leere Menge.
#                Die alte Menge wird vorher durch das Setzen auf undef
#                freigegeben
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    $_[0]->_ecken(undef);
    $_[0]->_ecken([]);

} # sub loesche_ecken


sub ecke {
# -----------------------------------------------------------------------------
# Methode      : e c k e
# Klasse       : Graph
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Setter / Getter fr ein Ecke(nobjekt)
# Parameter    : 1) Index
#                2) Wert (optional)
# Rckgabewert : Der aktuelle Wert (im Falle des Getters) oder der alte Wert
#                (im falle des Setters).
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    if (@_ == 3) {
        my $aw = $_[0]->_ecken()->[$_[1]];
        $_[0]->_ecken()->[$_[1]] = $_[2];
        return $aw;
    }
    else {
        return $_[0]->_ecken()->[$_[1]];
    }

} # sub ecke


sub entnehme_ecke {
# -----------------------------------------------------------------------------
# Methode      : e n t n e h m e _ e c k e
# Klasse       : Graph
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Entfernt eine Ecke aus der Eckenmenge und gibt diese zurck.
# Parameter    : Index
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    return splice @{$_[0]->_ecken()}, $_[1], 1;

} # sub entnehme_ecke


sub fuege_ecke_hinzu {
# -----------------------------------------------------------------------------
# Methode      : f u e g e _ e c k e _ h i n z u
# Klasse       : Graph
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Fgt eine Ecke zur Eckenmenge hinzu
# Parameter    : Ecke-Objekt
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    push @{$_[0]->_ecken()}, $_[1];

} # sub fuege_ecke_hinzu




# =============================================================================
#
#
#   M E T H O D E N
#
#
# =============================================================================


sub ecke_einfuegen {
# -----------------------------------------------------------------------------
# Methode      : e c k e _ e i n f u e g e n
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Fgt eine neue Ecke in den Graphen ein.
# Parameter    : 1) X-Koordinate
#                2) Y-Koordinate
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# 0.0.2 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::ecke_loeschen falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 2;

    my $x = shift;
    my $y = shift;

    print "Graph2d::ecke_einfuegen($x, $y)\n" if $Debug;

    #--------------------------------------------------------------------------
    # Basisklassenfunktionalitt aufrufen:
    #--------------------------------------------------------------------------
    $self->SUPER::ecke_einfuegen();

    #--------------------------------------------------------------------------
    # Koordinaten der Ecke im Raster ablegen:
    #--------------------------------------------------------------------------
    my $e = new Graph::GED::Ecke;
    $e->x($x);
    $e->y($y);
    $self->fuege_ecke_hinzu($e);

} # sub Graph2d::ecke_einfuegen


sub ecke_loeschen {
# -----------------------------------------------------------------------------
# Methode      : e c k e _ l o e s c h e n
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Lscht die angegebene Ecke mit allen inzidierenden Kanten
#                aus dem Graphen.
# Parameter    : zu lschende Ecke
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# 0.0.2 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph2d::ecke_loeschen falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 1;
    die "Graph2d::ecke_loeschen aufgerufen, aber der Graph hat keine Ecken!"
        unless $self->n() > 0;

    my $e = shift;

    print "ecke_loeschen($e)\n" if $Debug;

    #--------------------------------------------------------------------------
    # Basisklassenfunktionalitt aufrufen:
    #--------------------------------------------------------------------------
    $self->SUPER::ecke_loeschen($e);

    #--------------------------------------------------------------------------
    # Ecke lschen:
    #--------------------------------------------------------------------------
    $self->entnehme_ecke($e);
} # sub Graph2d::ecke_loeschen


sub ecke_mergen {
# -----------------------------------------------------------------------------
# Methode      : e c k e _ m e r g e n
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Mergt die angegebene Ecke (d.h. die Ecke wird gelscht und die
#                Kanten zusammengezogen.
# Parameter    : Zu mergende Ecke
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# 0.0.2 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::ecke_mergen mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 1;


    my $e = shift;

    print "ecke_mergen($e)\n" if $Debug;

    #--------------------------------------------------------------------------
    # Basisklassenfunktionalitt aufrufen:
    #--------------------------------------------------------------------------
    $self->SUPER::ecke_mergen($e);


    #--------------------------------------------------------------------------
    # Ecke lschen:
    #--------------------------------------------------------------------------
    $self->entnehme_ecke($e);
} # sub Graph2d::ecke_mergen


sub clear {
# -----------------------------------------------------------------------------
# Methode      : c l e a r
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Lscht alle Ecken und Kanten.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 09.02.2003 - CD - Erstellt
# 0.0.2 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph2d::clear mit Parametern aufgerufen!"
        if scalar @_ > 0;

    print "Graph2d::clear\n" if $Debug;

    #--------------------------------------------------------------------------
    # Ecken lschen:
    #--------------------------------------------------------------------------
    $self->loesche_ecken();

    #--------------------------------------------------------------------------
    # Basisfunktionalitt aufrufen:
    #--------------------------------------------------------------------------
    $self->SUPER::clear();
} # sub Graph2d::clear


sub ecke_zu_nah {
# -----------------------------------------------------------------------------
# Methode      : e c k e _ z u _ n a h
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Testet, ob die angegebenen Koordinaten einer schon vorhandenen
#                Ecke zu nahe kommen.
# Parameter    : x, y - zu testendes Koordinatenpaar
# Rckgabewert : 0 oder 1 (1 meint Kollision)
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 08.02.2004 - CD - Neu als Klassenmethode
# 0.0.4 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::ecke_zu_nah mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 2;

    my $x     = shift;
    my $y     = shift;

    print "Graph2d::ecke_zu_nah, x='$x', y='$y', ",
          "delta='", $self->delta(), "'\n"
          if $Debug;

    die "Interner Fehler!" if scalar @{$self->_ecken()} != $self->n();

    for my $i (0..$self->n()-1) {
        my $ecke = $self->ecke($i);
        if (
            abs($ecke->x() - $x) < $self->delta() and
            abs($ecke->y() - $y) < $self->delta()
           )
        {
            print "Kollison mit Ecke $i auf (",$ecke->x(),", ",$ecke->y(),")\n"
                  if $Debug>1;
            return 1;
        }
    }

    return 0;
} # sub Graph2d::ecke_zu_nah


sub ecke_zu_nah_ohne {
# -----------------------------------------------------------------------------
# Methode      : e c k e _ z u _ n a h _ o h n e
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Testet, ob die angegebenen Koordinaten einer schon vorhandenen
#                Ecke zu nahe kommen, mit aunahme der angegebenen Ecke.
# Parameter    : x, y - zu testendes Koordinatenpaar
#                e    - Ecke
# Rckgabewert : 0 oder 1 (1 meint Kollision)
# -----------------------------------------------------------------------------
# 0.0.1 - 05.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 08.02.2004 - CD - Neu als Klassenmethode
# 0.0.4 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::ecke_zu_nah_ohne mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 3;

    my $x     = shift;
    my $y     = shift;
    my $e     = shift;

    print "Graph2d::ecke_zu_nah_ohne, x='$x', y='$y', Ecke = '$e', ",
          "delta='", $self->delta(), "'\n"
          if $Debug;

    die "Interner Fehler!" if scalar @{$self->_ecken()} != $self->n();

    for my $i (0..$self->n()-1) {
        next if $i == $e;
        my $ecke = $self->ecke($i);
        if (
            abs($ecke->x() - $x) < $self->delta() and
            abs($ecke->y() - $y) < $self->delta()
           )
        {
            print "Kollison mit Ecke $i auf (",$ecke->x(),", ",$ecke->y(),")\n"
                  if $Debug>1;
            return 1;
        }
    }

    return 0;
} # sub Graph2d::ecke_zu_nah_ohne


sub meint_ecke {
# -----------------------------------------------------------------------------
# Methode      : m e i n t _ e c k e
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Es wird die Ecke zu den Koordinaten herausgesucht, die am
#                nchsten liegt. Dabei darf nicht zu weit entfernt geklickt
#                werden.
# Parameter    : x, y
# Rckgabewert : Eckennummer oder -1, wenn keine Ecke in der Nhe liegt.
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 08.02.2004 - CD - Neu als Klassenmethode
# 0.0.4 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::meint_ecke mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 2;


    my $x     = shift;
    my $y     = shift;


    print "Graph2d::meint_ecke, x='$x', y='$y', ",
          "delta='", $self->delta(), "'\n"
          if $Debug;

    my $e     = -1;


    die "Interner Fehler!" if scalar @{$self->_ecken()} != $self->n();

    for my $i (0..$self->n()-1) {
        my $ecke = $self->ecke($i);
        if (
            abs($ecke->x() - $x) < $self->delta() and
            abs($ecke->y() - $y) < $self->delta()
           )
        {
            print "Ecke $i auf (", $ecke->x(), ", ", $ecke->y(),
                  ") ist gemeint.\n"
                  if $Debug>1;
            $e = $i;
            last;
        }
    }


    return $e;

} # sub Graph2d::meint_ecke


sub meint_kante {
# -----------------------------------------------------------------------------
# Methode      : m e i n t _ k a n t e
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Es wird die Kante zu den Koordinaten herausgesucht, die am
#                nchsten liegt. Dabei darf nicht zu weit entfernt geklickt
#                werden.
# Parameter    : x, y
# Rckgabewert : Kantennummer oder -1, wenn keine Ecke in der Nhe liegt.
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 10.02.2003 - CD - Mit Funktion gefllt.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.4 - 08.02.2004 - CD - Neu als Klassenmethode
# 0.0.5 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::meint_kante mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 2;


    my $x     = shift;
    my $y     = shift;

    print "Graph2d::meint_kante, x='$x', y='$y', ",
          "delta='", $self->delta(), "'\n"
          if $Debug;


    die "Interner Fehler!" if scalar @{$self->_kanten()} != $self->m();

    my $k = -1; # nchste Kante

    #--------------------------------------------------------------------------
    # Schleife ber alle Kanten:
    #--------------------------------------------------------------------------
    for my $i (0..$self->m()-1) {
        my $kante = $self->kante($i);
        my $ax = $self->ecke($kante->a())->x();
        my $ay = $self->ecke($kante->a())->y();
        my $ex = $self->ecke($kante->e())->x();
        my $ey = $self->ecke($kante->e())->y();

        my $abs = GEDgeom::abstand_punkt_linie($x, $y, $ax, $ay, $ex, $ey);

        if ($abs < $self->delta()) {
            if ($k >= 0) {
                print "Uneindeutig! Kante $k und Kante $i sind nah dran.\n"
                    if $Debug;
                return -1;
            }
            else {
                $k = $i;
                print "Kante $k (",
                      $kante->a(), ", ", $kante->e(),
                      ") ist gemeint.\n",
                      "[Abstand ist $abs]\n"
                      if $Debug;
                $k = $i;
            }
        }
    }

    return $k;
} # sub meint_kante


sub r2d {
# -----------------------------------------------------------------------------
# Methode      : r 2 d
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Berechnet Delta aus dem Radius.
#                In Funktion verschoben, falls Radius gendert wird, was
#                geplant ist.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 08.02.2004 - CD - Neu als Klassenmethode
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::r2d mit Parametern aufgerufen!"
        if scalar @_ > 0;


    print "r2d: Radius = '", $self->radius(),
          "', Delta-Alt = '", $self->delta(), "', "
          if $Debug > 1;

    $self->delta(2 * $self->radius() + $self->radius() + 2);

    print "Delta-Neu = '", $self->delta(), "'\n" if $Debug > 1;
} # sub Graph2d::r2d


sub struktur_einfuegen {
# -----------------------------------------------------------------------------
# Methode      : s t r u k t u r _ e i n f u e g e n
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Fgt Kreise / Vollstndige Graphen ein
# Parameter    : Strukturkennung, beginnt mt C ode K gefolgt von einer
#                natrlichen Zahl > 2.
#                Oder 'M' fr den Mittelpunkt.
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 11.02.2003 - CD - Erstellt
# 0.0.2 - 12.02.2003 - CD - Koordinatenberechnung korrigiert.
#                           Mittelpunkt einzeichenbar.
# 0.0.3 - 18.03.2003 - CD - Neue Linientypkrzel verwendet.
# 0.0.4 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.5 - 05.02.2004 - CD - canvas_groesse() aufgerufen zur Ermittlung der
#                           Gre der Zeichenflche.
# 0.0.6 - 07.02.2004 - CD - Radius wird an zurckgelieferte Breite angepasst.
# 0.0.7 - 08.02.2004 - CD - Radius vergrert.
# 0.0.8 - 09.02.2004 - CD - Neu als Klassenmethode. Die Klassenvariablen
#                           $MinX, $MinY, $MaxX, $MaxY werden bei jeder
#                           Grennderung der Zeichenflche im aufrufenden
#                           Programm gendert!
#                           Auerdem wurden die Methoden zum Einfgen
#                           von Ecken und Kanten verwendet.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::struktur_einfuegen mit falscher Anzahl Parametern aufgerufen!"
        if scalar @_ != 1;

    my $struktur = shift;                # 'C3', ...
    my $pi       = 3.141592653589793238; # Kreiszahl PI (abgeschnitten...)
    my $offx     = int($MaxX/2); # Mittelpunkt des Kreises, x-Koord.
    my $offy     = int($MaxY/2); # Mittelpunkt des Kreises, y-Koord.
    my $radius   = ($MaxX<=$MaxY?$MaxX:$MaxY) / 2 - 30;

    print "Graph2d::struktur_einfuegen, Struktur = '$struktur'\n" if $Debug;


    #--------------------------------------------------------------------------
    # Mittelpunkt:
    #--------------------------------------------------------------------------
    if (lc($struktur) eq 'm') {
        $self->ecke_einfuegen($offx, $offy);
        return;
    }

    #--------------------------------------------------------------------------
    # Kreis oder vollstndiger Graph:
    #--------------------------------------------------------------------------
    $struktur =~ /^(\w)(\d+)$/;

    my $c_oder_k = $1;
    my $zahl     = $2;

    $c_oder_k = '' unless defined $c_oder_k;
    $zahl     = 0  unless defined $zahl;

    print "Eingefgt werden soll ein ",
          lc($c_oder_k) eq 'c' ? "Kreis" : "Vollstndiger Graph",
          " mit $zahl Ecken.\n";

    die "Falscher Aufruf von struktur_einfgen, Parameter war '$struktur'!"
        unless (lc($c_oder_k) eq 'c' or lc($c_oder_k) eq 'k') and
               $zahl > 2 and
               $zahl < 100;

    my $startecke = $self->n();
    my $endecke   = $self->n() + $zahl - 1;

    for my $i ($startecke .. $endecke) {
        #----------------------------------------------------------------------
        # Eckenkoordinaten festlegen und Ecke einfgen:
        #----------------------------------------------------------------------
        my $n      = 1 + $i - $startecke;  # Nummer der aktuell zu setzenden
                                           # Ecke, beginnend mit 1
        my $phi    = ($n-1)*(2*$pi)/$zahl; # Winkel zwischen der Linie vom
                                           # Mittelpunkt zur aktuellen Ecke
                                           # und der x-Achse.
        my $nx     = $radius * cos $phi;   # x-Koordinate der aktuellen Ecke
        my $ny     = $radius * sin $phi;   # y-Koordinate der aktuellen Ecke

        $self->ecke_einfuegen(int($nx+$offx+.5), int($ny+$offy+.5));
    }

    for my $i ($startecke .. $endecke) {
        #----------------------------------------------------------------------
        # Kreiskanten einziehen:
        #----------------------------------------------------------------------
        if (lc($c_oder_k) eq 'c') {
            my $j = $i==$endecke ? $startecke : $i+1;
            $self->kante_einfuegen($i, $j);
        }
        #----------------------------------------------------------------------
        # Alle Kanten einziehen:
        # (aber nicht doppelt, deshalb erst ab $i+1)
        #----------------------------------------------------------------------
        elsif (lc($c_oder_k) eq 'k') {
            for my $j ($i+1 .. $endecke) {
                $self->kante_einfuegen($i, $j);
            }
        }
    }
} # sub Graph2d::struktur_einfuegen


sub erzeuge_liniengraphen  {
# -----------------------------------------------------------------------------
# Methode      : e r z e u g e _ l i n i e n g r a p h e n
# Klasse       : Graph2d
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Erzeugt aus dem gegebenen Graphen seinen Liniengraphen.
# Parameter    : keine
# Rckgabewert : keiner (ein neuer Graph wird erzeugt)
# -----------------------------------------------------------------------------
# 0.0.1 - 06.02.2004 - CD - Erstellt
# 0.0.2 - 08.02.2004 - CD - Neu als Klassenmethode
# 0.0.3 - 10.02.2004 - CD - neue Hilfsmethoden verwendet.
#                           Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $self = shift;

    die "Graph::GED::Graph2d::r2d mit Parametern aufgerufen!"
        if scalar @_ > 0;

    print "erzeuge_liniengraphen\n" if $Debug;

    die "Interner Fehler!" if scalar @{$self->_kanten()} != $self->m();

    #--------------------------------------------------------------------------
    # Graph hat keine Kanten:
    #--------------------------------------------------------------------------
    if ($self->m() == 0) {
        $self->clear();
    }

    #--------------------------------------------------------------------------
    # Graph hat Kanten:
    #--------------------------------------------------------------------------
    else {
        my @ecken  = (); # neue Eckenmenge
        my @kanten = (); # neue Kantenmenge
        my $n      = $self->m();
        my $m      = 0;

        #----------------------------------------------------------------------
        # Neue Ecken berechnen:
        #----------------------------------------------------------------------
        for my $k (0..$self->m()-1) {
            my $kante = $self->kante($k);
            my $ecke  = new Graph::GED::Ecke;
            $ecke->x( int(($self->ecke($kante->a())->x() +
                           $self->ecke($kante->e())->x()) / 2) );
            $ecke->y( int(($self->ecke($kante->a())->y() +
                           $self->ecke($kante->e())->y()) / 2) );
            push @ecken, $ecke;
        }

        #----------------------------------------------------------------------
        # Neue Kanten berechnen:
        #----------------------------------------------------------------------
        for my $k1 (0..$self->m()-2) {
            for my $k2 ($k1+1..$self->m()-1) {
                my $kante1 = $self->kante($k1);
                my $kante2 = $self->kante($k2);
                if (
                    $kante1->a() == $kante2->a() or
                    $kante1->a() == $kante2->e() or
                    $kante1->e() == $kante2->a() or
                    $kante1->e() == $kante2->e()
                   )
                {
                    my $kante = new Graph::GED::Kante;
                    $kante->a($k1);
                    $kante->e($k2);
                    $kante->form('k_ins');
                    push @kanten, $kante;
                    ++$m;
                }
            }
        }

        #----------------------------------------------------------------------
        # Graph lschen:
        #----------------------------------------------------------------------
        $self->clear();

        #----------------------------------------------------------------------
        # Liniengraphendaten speichern:
        #----------------------------------------------------------------------
        $self->setze_ecken (\@ecken );
        $self->setze_kanten(\@kanten);

        $self->n($n);
        $self->m($m);

        #----------------------------------------------------------------------
        # Weitere Grapheneigenschaften zurcksetzen:
        #----------------------------------------------------------------------
        $self->kantenform('');
    }
} # sub Graph2d::erzeuge_liniengraphen

return 1;

__END__

=head1 NAME

Graph2d.pm - a module for graphs mit two dimensional coordiantes


=head1 COPYRIGHT

Copyright 2004 Christian Duehl. All rights reserved.


This library is free software. You can redistribute it and/or
modify it under the same terms as perl itself.

=cut

