# -----------------------------------------------------------------------------
# Programm         : K a n t e . p m
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Erstellt         : 10. Februar 2004
# Zuletzt gendert : 10. Februar 2004
# Aufgabe          : Kantenklasse
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# Globale private Datei-Variablen:
# -----------------------------------------------------------------------------
my $Debug  = 2; # Debug level


# -----------------------------------------------------------------------------
# Klasse           : K a n t e
# abgeleitet von   : none
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Beschreibung     : Eine Kanten-Klasse.
# Attribute        : a                  - Anfangsecke
#                    e                  - Endecke
#                    form               - Form der Kante fr die Darstellung
# Klassen-Methoden : new                - Erstellt ein Objekt dieser Klasse.
# Objekt-Methoden  : _property          - Hilfsfunktion fr Getter / Setter
#                    a                  - Getter / Setter
#                    e                  - Getter / Setter
#                    form               - Getter / Setter
#                    inzidiert_mit_ecke - Test, ob Kante an Ecke stt.
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------
package Graph::GED::Kante;


use strict;
use warnings;

use Data::Dumper;

sub new {
# -----------------------------------------------------------------------------
# Methode      : n e w
# Klasse       : Kante
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Erzeugt eine neue Kante (oder ein Objekt einer Klasse,
#                die von dieser Klasse abgeleitet wurde und uns bittet, das
#                Objekt fr sie zu erzeugen).
# Parameter    : 1) Klasse
#                2) ev. gewnschte Klasse (im Fall einer abgeleiteten Klasse)
#                Und ggf. Attribute: siehe Klassenbeschreibung oben
# Rckgabewert : Das geblesste neue Objekt.
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    my $class = shift; # Die Klasse, von der new aufgerufen wurde:
                       #     my $object = Graph->new(...);
                       # oder
                       #     my $object = new Graph(...);


    my $wantclass;     # Dies ist die Klasse, in welche das neue Objekt ge-
                       # blessed werden soll.
                       # Falls die Methode new mit einer gerade Anzahl an
                       # Parametern aufgerufen wurde (nachdem $class schon ent-
                       # nommen wurde), wurde keine gewnschte Klasse angege-
                       # ben. In diesem Fall verwenden wir $class.
                       # Anderenfalls verwenden wir die bergebene Klasse.

    my $n = scalar @_; # Bestimmt die Anzahl an verbliebenen Parametern.

    #--------------------------------------------------------------------------
    # Falls noch Parameter da sind und ihre Anzahl ungerade ist, dann mchte
    # der Aufrufer, dass wir das Objekt auf die gewnschte Klasse blessen, die
    # als nchster Parameter angegeben ist.
    # Also holen wir sie mit shift aus den Aufrufparametern und legen sie
    # in $wantclass ab.
    #--------------------------------------------------------------------------
    if ($n > 0 and ($n >> 1) << 1 != $n) {
        $wantclass = shift;
    }
    #--------------------------------------------------------------------------
    # Anderenfalls wurde keine gewnschte Klasse angegeben und wir verwenden
    # $class aus dem ersten Parameter:
    #--------------------------------------------------------------------------
    else {
        $wantclass = $class;
    }

    #--------------------------------------------------------------------------
    # Ausgabe der Aufrufparameter:
    #--------------------------------------------------------------------------
    print "Kante::new\n",
          "\tclass      = '$class'\n",
          "\twant class = '$wantclass'\n",
          "\tn          = $n\n",
          "\tParameter  = @_\n",
          if $Debug > 1;

    #--------------------------------------------------------------------------
    # Wir erzeugen ein Objekt in der gewnschten Klasse (eine geblessde Refe-
    # renz auf einen ev. leeren anonymen Hash):
    #--------------------------------------------------------------------------
    my $self = bless({@_}, $wantclass);

    #--------------------------------------------------------------------------
    # Nun setzen wir noch ein paar Attribute:
    #--------------------------------------------------------------------------
    $self->a   (-1);
    $self->e   (-1);
    $self->form('');

    #--------------------------------------------------------------------------
    # ... und geben das erzeugte Objekt zurck:
    #--------------------------------------------------------------------------
    return $self;

} # sub Kante::new


# -----------------------------------------------------------------------------
# Methode      : _ p r o p e r t y
# Klasse       : Kante
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Private Funktion fr die einfache Definition von Gettern und
#                Settern.
# Parameter    : Attribut, Parameter
# Rckgabewert : Der aktuelle Wert (im Falle des Getters) oder der alte Wert
#                (im falle des Setters).
# -----------------------------------------------------------------------------
# 0.0.1 - 08.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------
sub _property ($$;$) {
    my $self   = shift;    # Objekt
    my $attr   = shift;    # Attribute, das gesetzt oder geholt wird
    my $setter = @_ == 1;  # Ist die Methode Setter?
    my $value  = shift;    # Zu setzender Wert, falls Setter

    # Falls man hier "if (defined $value)" benutzen wrde, so knnte man keine
    # undefinierten Werte setzen, deshalb verwenden wir diese Form:
    if ($setter) {
        my $old_value = $self->{$attr};
        $self->{$attr} = $value;
        return $old_value;
    }
    else {
        return $self->{$attr};
    }
} # sub Kante::_property


# -----------------------------------------------------------------------------
# The getter/setter methods:
# -----------------------------------------------------------------------------
sub e    { return shift->_property('e',    @_) }
sub a    { return shift->_property('a',    @_) }
sub form { return shift->_property('form', @_) }


sub inzidiert_mit_ecke {
# -----------------------------------------------------------------------------
# Methode      : i n z i d i e r t _ m i t _ e c k e
# Klasse       : Kante
# -----------------------------------------------------------------------------
# Autor        : Christian Dhl
# Aufgabe      : Testet, ob die Kante mit der gegebenen Ecke inzidiert.
# Parameter    : Ecke (Index, nicht Objekt)
# Rckgabewert : wahr oder falsch
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2004 - CD - erstellt
# -----------------------------------------------------------------------------

    my $self = shift;
    my $ecke = shift;

    return ($self->a() == $ecke or $self->e() == $ecke) ? 1 : 0;
} # sub inzidiert_mit_ecke


return 1;

__END__

=head1 NAME

Kante.pm - a module for a edge of a graph


=head1 COPYRIGHT

Copyright 2004 Christian Duehl. All rights reserved.

This library is free software. You can redistribute it and/or
modify it under the same terms as perl itself.

=cut
