#!/usr/bin/perl
# -----------------------------------------------------------------------------
# Programm         : g e d . p l
# -----------------------------------------------------------------------------
# Autor            : Christian Dhl
# Erstellt         : 31. Januar 2003
# Zuletzt gendert : 10. Januar 2004
# Aufgabe          : Ein grafischer Editor fr Graphen.
# -----------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Pakete / Pragmas
#------------------------------------------------------------------------------
use strict;
use warnings;

use Tk;
use Tk::Dialog;
use Tk::ErrorDialog;

use Cwd;                # fr cwd() - Ermittlung des aktuellen
                        #             Arbeitsverzeichnisses

use Graph::GED::FHist;
use Graph::GED::Geom;
use Graph::GED::Graph2d;

#------------------------------------------------------------------------------
# Todo-Text:
#------------------------------------------------------------------------------
    my $Todotext = <<'TODOTEXT';
- Kanten wahlweise so zeichnen, dass sie nur an die Ecken stoen und nicht bis
  zum Mittelpunkt gehen! (Ohne die Verzierungen msste man ja nur die beiden
  Ecken jeweils neuzeichnen).

- HTML-Hilfe mit Screenshots erstellen, die man ber Hilfe ... starten kann.
  oder mit Texten und Bildern im Textwidget (dafr ($top, $text) zurckliefern
  und ROText benutzen).

- Anbindung an Algorithmen ermglichen, so dass diese visualisiert werden
  knnen. (Ecken / Kanten hervorheben...)

- Automatische Umordnungen der Ecken ...

- Automatisches Vermeiden von Kantenberschneidungen, wenn das geht ...
  Linienberschneidungen diagnostizieren...
  Algorithmus: Wann schneiden sich zwei Strecken in der Ebene?

- Kontextmen?!

- Iconleiste : Drucken... Funktionalitt wie?

- Rckgngigfunktion
  Dafr braucht man den Graphen ausgelagert, dann kann man den aktuellen Graphen
  und n ltere und m neuere Speichern.

- merken, ob gendert wurde.
  falls nderung, so Abfrage ob gespeichert werden soll beim Verlassen...
  ==
  Anzeige, ob Graph gendert wurde (Stern rechts unten neben der Statusbar?!)

- Linienzge automatisch verfeinern (mit Skala) (Einfgen von Zwischenecken
  vom Grad 2 an entsprechenden Punkten ["entsprechend" => Spline...]).

- Hintergrundbild einladen (und Canvas auf seine Gre bringen, falls mglich
  (dazu gesamt- und canvas-geometry holen und rechnen).

- Flchen fllen...
  Idee: Wenn Linien dazukommen und dadurch Flchen aufteilen, wird ein neuer
  Farbwert erzeugt.
  berlegen, od das nur bei ebenen Graphen gemacht wird.

- Aufspaltung des Programms in verschiedene Richtungen (ev. per Auswahl ber
  Men oder per internem Define?)

- "Slideshow"
  Ganz links Zeitbalken.
  Automatische Abspielmglichkeit als Slider ... und Anwahl einzelner
  Zeitpunkte per Hand.
  Einzelne Zeitpunkte lassen sich als .ged speichern, das ganze lsst sich als
  anderes Format speichern, einfach eine Hintereinanderreihung von GED-Formaten,
  davor die Anzahl Graphen und der Abspiel-Delay.
  ==
  Filmfunktion
  Dafr Regler am linken Rand, Slider fr Bild zu Bildschaltung, "+", "lschen"
  Unter Speichern kann man einzelne Graphen als auch "Filme" speichern.

- Ecken / Kanten hervorheben... dafr $EckenH[$i], $KantenH[$j]
  (H fr Highlight), normalerweise 0 (=normale Kante), oder eben 1 (hervor-
  gehoben). Ev. andere Werte spter fr andersartige Hervorhebungen, etwa mit
  verschiedenen Farben, so man verschiedene Hervorhebungen bentigt.

- Hilfstexte auch (oder nur??) in die Statusbar (Ecke einfgen... etc). Nein.

- Funktionsbersicht (Auflistung der Funktionen in ihrer Reihenfolge und kurze
  Erklrung).
  Hier ev. Prototypliste mit Kommentaren ergnzen.

- Datei schlieen im Dateidialog (Namen merken... neue Datei)

- Ecken-, Kanten- und Hintergrundfarbe durch User auf Einstellblatt
  konfigurierbar.
  ==
  Ecken und Kantenmerkmale frei whlbar (Farbe / Dicke)

- Probleme beim Vorbelegen der Namen fr das Wandeln in LaTeX bzw. PS unter
  Windows 98. (Unter Win2k ok)

- Probleme mit dem Dateipfad unter Windows 98. (Unter Win2k ok)

- Modus, in dem man Ecken anfgt, die automatisch mit einer (normalen?) Kante
  mit der zuletzt eingefgten verbunden werden.
  [Ev. auch in allen Kantenausprgungen.]

- Mehrfachkantenproblem lsen. Am besten ist es so, dass der Editor erkennt,
  dass da eine zustzliche Kante eingezeichnet wird. Er muss die Kanten dann im
  leichten  Bogen darstellen.
  Bei ungerader Anzahl ist die erste gerade, die zweite rechts davon leicht
  gewlbt, die dritte links, die vierte wieder rechts...
  Bei gerader Anzahl genauso ohne die mittlere Kante und dafr mit etwas
  schwcherer Startwlbung.

- Hilftexte anzeigen (Tooltips)
  Tk::Baloon zur Beschreibung der Oberflchenelemente verwenden.

- Tk:ProgressBar (in Statuszeile oder extra darber) whrend Berechnungen
  (etwa Liniengraph)

- Unterstzung mehrerer Graphen (n Stck), Unterscheidung durch verschiedene
  Ecken- und Kantenfarben, bei allen Funktionen die Graphen zur Auswahl bringen
  in Frame mit Canvas-Items.
  Werden zwei Graphen durch eine Kante verbundenm muss daraus einer werden.
  Listbox zum Whlen des Graphen.
  Farben mssen natrlich auch fr alle Graphen whlbar sein.

- Konfigurationsseiten mit Tk::NoteBook (S. 576 Mastering Perl/Tk).

- Iconhintergrnde angleichen (das Wei ist etwas unterschiedlich [oder wirkt
  so wegen der blauen Linien?]).

- Funktionen zum Vergrern und Verkleinern einbauen. Und Schalter dafr.

- Funktionen zum Verschieben des gesamten Graphen (mit Weigerung, falls Teile
  aus dem sichtbaren Bereich wandern).

- Es sollte mglich sein, mehrere Ecken irgendwie mit der Maus zu markieren
  (mit einer Art Lassofunktion) und dann gemeinsam zu behandeln (Lschen und
  insb. Verschieben).

- Sollte Ecken- und Kantenfarbe mit abgespeichert (und dann auch geladen)
  werden? Ja.

- Sollen einzelne Ecken und Kanten individuell gefrbt werden knnen? Ja.
  Dies wre insb. fr die Erstellung der Filme (siehe weiter oben interessant,
  um schon auf Stellen aufmerksam zu machen, die sich gleich verndern).
  Dann auch Funktion, die allen Ecken bzw. Kanten die Farbe zuweist.

- Funktion, die alle Ecken im Raster einrasten lsst, mit Suche nach anderen
  Positionen in der Nhe, bei Zuweisung auf den gleichen Gitterpunkt.
  Dafr wr die Rckgngig-Funktion gut.

- Rechtsklick auf Ecke: Eigenschaftsmen, wenn keine Ecke gemeint, Test ob
  Kante gemeint ist.
  Dabei sollen auch Texte an Ecken und Kanten mglich sein (Position, Inhalt,
  Farbe).

- Pinselfrbetool: Es wird ein Palettenbild rechts zwischen den Buttons ange-
  zeigt, daraus kann der User mit Pinselchen eine Farbe whlen und damit auf
  die Zeichenflche klicken. Mit meint_ecke und dann meint_kante wird getestet,
  welche Ecke oder Kante gemeint war und wenn es eindeutig ist, das entspre-
  chende Element mit dieser Farbe eingefrbt.

- POD erweitern.

- Plttbare Graphen erkennen, Funktion, die plttbare Graphen ohne
  Kantenberschneidungen darstellt.

- Fr ebene Graphen: sonst deaktivierte Meneintrge sind dann anwhlbar:
      * Aus dem Graphen den Graphen erstellen, der entsteht, wenn man in jedes
        Land eine neue Ecke setzt und zwei dieser Ecken mit einer Kante
        verbindet, wenn die Lnder aneinander stoen.
      * Triangulierung: in alle Lnder Kanten einfgen, bis alle Lnder
        dreieckig sind. Optional mit oder ohne uerem Land. (Ev. muss bei mit
        eine Eckenumordnung erfolgen, damit der Graph eben bleibt, aber ev.
        auch schon ohne.:

         2 *-----------* 1
             \         |
               \       |
              3  *     |
                 |     |
                 |     |
                 |     |
                 |     |
                 |     |
                 |     |
                 |     |
              4  *-----* 5

        Fgt man eine Kante 2-4 oder 2-5 ein, so liegt die direkte Verbindung
        auerhalb des Landes.)

- Funktion, die den Graphen bei Proportionserhaltung vergrert und zentriert
  so dass er wieder voll zu sehen ist.

- load as new selecton
TODOTEXT


#------------------------------------------------------------------------------
# globale Variablen:
#------------------------------------------------------------------------------
my %Linientypen = ('e_ins' => 'Ecke einfgen',
                   'e_del' => 'Ecke lschen',
                   'e_mer' => 'Ecke mergen',
                   'e_mv1' => 'Ecke verschieben (schnelle Methode)',
                   'e_mv2' => 'Ecke verschieben (schne Methode)',
                   'k_ins' => 'normale Kante einfgen',
                   'k_del' => 'Kante lschen',
                   'k_inh' => 'Kante einfgen: Pfeil hin',
                   'k_inz' => 'Kante einfgen: Pfeil zurck',
                   'k_inb' => 'Kante einfgen: Pfeil hin und zurck',
                  );

my %Konfig = (
              debug         => 1,                    # Wert fr Debugausgaben,
                                                     # je hher der Wert,
                                                     # desto mehr wird ausge-
                                                     # geben, bei 0 wird
                                                     # nichts ausgegeben.
              version       => '0.0.27',             # Programmversion
              version_datum => '10.02.2004',         # Programmdatum

              mw            => undef,                # Hauptfenster-Widget
              canvas        => undef,                # Canvas-Widget
              menu          => undef,                # Menu-Widget
              menufont      => '{Arial} 8 {normal}', # Schriftart des Menu

              gitterzeigen  => 0,                    # Hilfs-Gitter anzeigen?
              gitterweite   => 25,                   # Weite des Gitters
              rastimgitter  => 0,                    # Im Gitter einrasten?
              gitterfarbe   => '#C0C0C0',            # Farbe des Gitters

              dateiname     => '',                   # Dateiname der gerade
                                                     # bearbeiten Datei
                                                     # (inklusive Pfad)
              pfad          => cwd(),                # Pfad zum Laden von
                                                     # Dateien.
                                                     # (Klappt nicht unter Win
                                                     # 98, aber unter Win 2k?!)

              statuszeile   => '',                   # Anzuzeigender Text in
                                                     # der Statuszeile

              linientyp     => 'e_ins',              # Mit den Checkbuttons
                                                     # verbunden

              startecke     => -1,                   # Startecke der Kante, die
                                                     # gerade gezeichnet wird.
              zx            => 0,                    # x-Koordinate und
              zy            => 0,                    # y-Koordinate des
                                                     # Zeichnenanfangs
             );

my $Graph  = new Graph::GED::Graph2d;
$Graph->kantenform('k_ins');


my @GitterX     = ();      # x-Koordinaten von senkrechten Gitterlinien
my @GitterY     = ();      # y-Koordinaten von waagerechten Gitterlinien


#------------------------------------------------------------------------------
# Prototypen:
#------------------------------------------------------------------------------
# Oberflche:
sub tk_start ();
sub add_file_menu ();
sub bind_start ();
sub zeichnen_anfang ($$$);
sub aendere_item ($$$);
sub zeichnen_ende ($$$);
sub refresh ();
sub clear (;$);
sub zeichne_ecke ($);
sub zeichne_kante ($);
sub lade_datei ();
sub speichere_datei ();
sub speichere_datei_als ();
sub export_nach_latex ();
sub export_nach_postscript ();
sub dump_eingeben ();
sub anzeige_fenster ($$$$;$$);
sub zeige_daten_an ();
sub hilfe ();
sub graph_erkl ();
sub history ();
sub todo ();
sub ueber_ged ();
sub canvas_groesse ();
sub waehle_eckenfarbe ();
sub waehle_kantenfarbe ();
sub tk_beenden ();

# Logik:
sub beenden ();
sub struktur_einfuegen ($);
sub raste_ein ($$);
sub erzeuge_liniengraphen ();
sub do_all_the_tests ();

# Daten:
sub dump_data ();
sub save ($);
sub load ($);
sub neue_datei ();
sub toLaTeX ($;$$$);
sub add ($);

#------------------------------------------------------------------------------
# Programmstart:
#------------------------------------------------------------------------------
$Graph->r2d();
print "Pfad = '$Konfig{pfad}'\n" if $Konfig{debug} > 1;
#do_all_the_tests();

Graph::GED::FHist::load();
tk_start();

$Konfig{statuszeile} = 'Willkommen bei GED';

$Konfig{mw}->after(100,
                    sub {
                         ($Graph2d::MinX, $Graph2d::MinY,
                          $Graph2d::MaxX, $Graph2d::MaxY) = canvas_groesse();
                    }
                  );
MainLoop();
exit;


###############################################################################
###############################################################################
####                                                                       ####
####                            TTTTT   K   K                              ####
####                              T     K  K                               ####
####                              T     KKK                                ####
####                              T     K  K                               ####
####                              T     K   K                              ####
####                                                                       ####
###############################################################################
###############################################################################


sub tk_start () {
# -----------------------------------------------------------------------------
# sub          : t k _ s t a r t
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Startet den Oberflchenkram.
#                Dies ist in eine Funktion ausgelagert worden, um den globalen
#                Namensbereich nicht zu berfrachten.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 31.01.2003 - CD - Erstellt
# 0.0.2 - 11.02.2003 - CD - Men umgestellt nach durchforsten der perldoc...
#                           toplevel menu mit cascading untermens...
# 0.0.3 - 18.03.2003 - CD - Neue Linientypenkrzel verwendet, lokale Variable
#                           $linientyptext eingefhrt.
# 0.0.4 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.5 - 06.02.2004 - CD - Neues Men "Ansicht".
# 0.0.6 - 06.02.2004 - CD - Button zum Eckenmergen hinzugefgt.
# 0.0.7 - 07.02.2004 - CD - Bindung frs Neuzeichnen der Zeichenflche.
#                           Ecken- und Kantenfarbe bers Ansichtsmen whlbar.
# 0.0.8 - 09.02.2004 - CD - Erstes Bearbeiten Men auskommentiert.
#                           Umstellungen auf die Verwendung von Graph2d.
#                           Eckenradiuswahl ins Men verlagert.
#                           Versionsnummer im Titel mit anzeigen.
# -----------------------------------------------------------------------------

    print "tk_start\n" if $Konfig{debug};

    my $linientyptext = 'Ecke einfgen';

    #--------------------------------------------------------------------------
    # TK-Hauptfenster:
    #--------------------------------------------------------------------------
    my $mw = MainWindow->new();
    $mw->title('G - E - D   ' . $Konfig{version});

    my $icon = $mw->Photo(-file   => 'res/ged.bmp',
                          -height => 32,
                          -width  => 32,
                         );
    $mw->Icon(-image => $icon);


    #--------------------------------------------------------------------------
    # Status-Bar:
    #--------------------------------------------------------------------------
    my $stat_l = $mw->Label(-relief       => 'groove', # ridge
                            -textvariable => \$Konfig{statuszeile},
                            -borderwidth  => 2,
                           #-background   => '#d7d7d7',
                           #-state        => 'disabled',
                            -anchor       => 'w',
                           );

    #--------------------------------------------------------------------------
    # Men:
    #--------------------------------------------------------------------------
    my $mf = $mw->Frame(#-relief      => 'ridge',
                        -borderwidth => 2,
                       );#


    # Menu-Bar:
    $Konfig{menu} = $mf->Menu(-type => 'menubar',
                              -font => $Konfig{menufont},
                              );

    $mw->configure(-menu => $Konfig{menu});

    # Eintrge in der Menu-Bar:
    $Konfig{menu}->cascade(-label     => 'Datei',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );
    $Konfig{menu}->cascade(-label     => 'Bearbeiten',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );
    #$Konfig{menu}->cascade(-label     => 'Bearbeiten2',
    #                       -underline => 10,
    #                       -font      => $Konfig{menufont},
    #                      );
    $Konfig{menu}->cascade(-label     => 'Ansicht',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );
    $Konfig{menu}->cascade(-label     => 'Manipulationen',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );
    $Konfig{menu}->cascade(-label     => 'Interna',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );
    $Konfig{menu}->separator(); # Rest rechtsbndig
    $Konfig{menu}->cascade(-label     => 'Hilfe',
                           -underline => 0,
                           -font      => $Konfig{menufont},
                          );

    # Dateimen:
    add_file_menu();

    ## Bearbeitenmen:
    #my $menu_bearbeiten = $Konfig{menu}
    #    ->Menu(-font      => $Konfig{menufont},
    #           -tearoff   => 0,
    #           -menuitems => [ ["command" => "Dreieck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C3' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Viereck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C4' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Fnfeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C5' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Sechseck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C6' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Siebeneck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C7' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Achteck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C8' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Neuneck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C9' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           '-',
    #                           ["command" => "K_3 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K3' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_4 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K4' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_5 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K5' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_6 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K6' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_7 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K7' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_8 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K8' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_9 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K9' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_10 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K10' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_11 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K11' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_12 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K12' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_13 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K13' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           '-',
    #                           ["command" => "Zwanzigeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C20' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Dreisigeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C30' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Vierzigeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C40' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Fnfzigeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C50' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "Neununneunzigeck einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'C99' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           '-',
    #                           ["command" => "K_20 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K20' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_30 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K30' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_40 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K40' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_50 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K50' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           ["command" => "K_99 einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'K99' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                           '-',
    #                           ["command" => "Mittelpunkt einfgen",
    #                            -command  => [ \&struktur_einfuegen, 'M' ],
    #                            -font     => $Konfig{menufont},
    #                           ],
    #                         ],
    #          );
    #$Konfig{menu}->entryconfigure('Bearbeiten', -menu => $menu_bearbeiten);

    # Bearbeitenmen2:
    my $menu_bearbeiten2 = $Konfig{menu}
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               );
    $menu_bearbeiten2->cascade(-label     => 'Kreise',
                               -underline => 0,
                               -font      => $Konfig{menufont},
                              );
    $menu_bearbeiten2->cascade(-label     => 'Vollstndige Graphen',
                               -underline => 0,
                               -font      => $Konfig{menufont},
                              );
    $menu_bearbeiten2->command(-label     => "Mittelpunkt einfgen",
                               -command  => [ \&struktur_einfuegen, 'M' ],
                               -font     => $Konfig{menufont},
                              );
    my $menu_bearbeiten_kreise =
    $menu_bearbeiten2
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ["command" => "Dreieck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C3' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Viereck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C4' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Fnfeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C5' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Sechseck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C6' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Siebeneck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C7' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Achteck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C8' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Neuneck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C9' ],
                                -font     => $Konfig{menufont},
                               ],
                               '-',
                               ["command" => "Zwanzigeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C20' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Dreisigeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C30' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Vierzigeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C40' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Fnfzigeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C50' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "Neununneunzigeck einfgen",
                                -command  => [ \&struktur_einfuegen, 'C99' ],
                                -font     => $Konfig{menufont},
                               ],
                             ],
              );
    $menu_bearbeiten2->entryconfigure('Kreise',
                                      -menu => $menu_bearbeiten_kreise);
    my $menu_bearbeiten_vgraphen = $menu_bearbeiten2
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ["command" => "K_3 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K3' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_4 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K4' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_5 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K5' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_6 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K6' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_7 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K7' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_8 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K8' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_9 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K9' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_10 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K10' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_11 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K11' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_12 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K12' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_13 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K13' ],
                                -font     => $Konfig{menufont},
                               ],
                               '-',
                               ["command" => "K_20 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K20' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_30 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K30' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_40 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K40' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_50 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K50' ],
                                -font     => $Konfig{menufont},
                               ],
                               ["command" => "K_99 einfgen",
                                -command  => [ \&struktur_einfuegen, 'K99' ],
                                -font     => $Konfig{menufont},
                               ],
                             ],
              );
    $menu_bearbeiten2->entryconfigure('Vollstndige Graphen',
                                      -menu => $menu_bearbeiten_vgraphen);

    #$Konfig{menu}->entryconfigure('Bearbeiten2', -menu => $menu_bearbeiten2);
    $Konfig{menu}->entryconfigure('Bearbeiten', -menu => $menu_bearbeiten2);

    # Ansichtmen:
    my $menu_ansicht = $Konfig{menu}
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ['checkbutton' => "Gitternetz anzeigen",
                                -variable     => \$Konfig{gitterzeigen},
                                -command      => \&refresh,
                                -underline    => 0,
                                -font         => $Konfig{menufont},
                               ],
                               [qw(cascade Gitterweite -tearoff 1 -underline 6
                                   -menuitems),
                                [map ['radiobutton' => $_,
                                      -variable => \$Konfig{gitterweite},
                                      -command  => \&refresh,
                                     ],
                                     qw(5 10 15 20 25 30 35 40 45 50
                                        60 70 80 100),
                                ],
                               ],
                               ['checkbutton' => "Am Gitternetz einrasten",
                                -variable     => \$Konfig{rastimgitter},
                                -command      => \&refresh,
                                -underline    => 17,
                                -font         => $Konfig{menufont},
                               ],
                               '-',
                               ['command'     => "Anzeige erneuern",
                                -command      => \&refresh,
                                -accelerator  => 'F5',
                                -font         => $Konfig{menufont},
                                -underline    => 17,
                               ],
                               '-',
                               ['command'     => "Eckenfarbe whlen",
                                -command      => \&waehle_eckenfarbe,
                                -font         => $Konfig{menufont},
                                -underline    => 0,
                               ],
                               ['command'     => "Kantenfarbe whlen",
                                -command      => \&waehle_kantenfarbe,
                                -font         => $Konfig{menufont},
                                -underline    => 0,
                               ],
                               '-',
                               [qw(cascade Eckenradius -tearoff 1 -underline 6
                                  -menuitems),
                                [map ['radiobutton' => $_,
                                      -variable => \$Graph->{radius}, ###UNSCHOEN !!!
                                      -command  => \&refresh,
                                     ],
                                     qw(3 4 5 6 7 8 9 10 12 14 16 18 20 25 30
                                        35 40 50 75 100),
                                ],
                               ],
                             ],
              );
    $Konfig{menu}->entryconfigure('Ansicht', -menu => $menu_ansicht);

    # Manipulatorenmen:
    my $menu_manip = $Konfig{menu}
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ["command"    => "In Liniengraphen umwandeln",
                                -command     => \&erzeuge_liniengraphen,
                                -underline   => 3,
                                -font        => $Konfig{menufont},
                               ],
                               #["command"    => 'Dump eingeben',
                               # -command     => \&dump_eingeben,
                               # -font        => $Konfig{menufont},
                               #],
                             ],
              );
    $Konfig{menu}->entryconfigure('Manipulationen', -menu => $menu_manip);

    # Internamen:
    my $menu_interna = $Konfig{menu}
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ["command"    => "interne Daten anzeigen",
                                -command     => \&zeige_daten_an,
                                -accelerator => 'Ctrl-I',
                                -font        => $Konfig{menufont},
                               ],
                               ["command"    => 'Dump eingeben',
                                -command     => \&dump_eingeben,
                                -font        => $Konfig{menufont},
                               ],
                             ],
              );
    $Konfig{menu}->entryconfigure('Interna', -menu => $menu_interna);

    # Hilfemen:
    my $menu_hilfe = $Konfig{menu}
        ->Menu(-font      => $Konfig{menufont},
               -tearoff   => 0,
               -menuitems => [ ["command"    => "Hilfe",
                                -command     => \&hilfe,
                                -accelerator => 'F1',
                                -font        => $Konfig{menufont},
                               ],
                               '-',
                               ["command"    => "Was sind Graphen?",
                                -command     => \&graph_erkl,
                                -font        => $Konfig{menufont},
                               ],
                               ["command"    => "History",
                                -command     => \&history,
                                -font        => $Konfig{menufont},
                               ],
                               ["command"    => "Todo",
                                -command     => \&todo,
                                -font        => $Konfig{menufont},
                               ],
                               '-',
                               ["command"    => "ber GED",
                                -command     => \&ueber_ged,
                                -font        => $Konfig{menufont},
                               ],
                             ],
              );
    $Konfig{menu}->entryconfigure('Hilfe', -menu => $menu_hilfe);


    #--------------------------------------------------------------------------
    # Zeichenflche:
    #--------------------------------------------------------------------------
    my $graf_lw = $mw->Canvas(-background => 'white',
                              -state      => 'disabled',
                              -width      => 80,
                              -height     => 25,
                              -relief     => 'flat',
                              -cursor     => 'crosshair',
                             );

    $Konfig{canvas} = $graf_lw;
    bind_start(); # <----- $Konfig{canvas}

    #--------------------------------------------------------------------------
    # Schalter:
    #--------------------------------------------------------------------------
    my $f = $mw->Frame(-relief      => 'groove',
                       -borderwidth => 2,
                      );


    my $clr_b = $f->Button(-text           => 'Alles lschen',
                           -command        => \&clear,
                          )
                    ->pack(#-expand => 1,
                           -fill   => 'x',
                           -side   => 'top',
                          );

    #my $skala = $f->Scale(-from     => 1,
    #                      -to       => 50,
    #                      -label    => 'Eckenradius',
    #                      -orient   => 'horizontal',
    #                      -variable => \$Graph->{radius}, ###UNSCHOEN !!!
    #                      -command  => sub {$Graph->r2d();
    #                                        refresh();
    #                                       },
    #                     )
    #               ->pack();

    my $quit_b = $f->Button(-text           => 'Beenden',
                            -command        => \&beenden,
                           )
                     ->pack(#-expand => 1,
                            -fill   => 'x',
                            -side   => 'bottom',
                           );
    my $refr_b = $f->Button(-text           => 'Neu zeichnen',
                            -command        => \&refresh,
                           )
                     ->pack(#-expand => 1,
                            -fill   => 'x',
                            -side   => 'bottom',
                           );

    #--------------------------------------------------------------------------
    # Bilder-Buttons:
    #--------------------------------------------------------------------------
    my $fb = $mw->Frame();

    # Dateibutton-Frame:
    my $fdb = $fb->Frame(-relief      => 'groove',
                         -borderwidth => 2,
                        )
                  ->pack(-side => 'left',
                         -padx        => 2,
                        );
    my @dbilder = ($mw->Photo(-file => 'res/datei_neu.gif'),
                   $mw->Photo(-file => 'res/datei_oeffnen.gif'),
                   $mw->Photo(-file => 'res/datei_speichern.gif'),
                   $mw->Photo(-file => 'res/datei_speichern_unter.gif'),
                  );
    my @dbefehle = (\&neue_datei,
                    \&lade_datei,
                    \&speichere_datei,
                    \&speichere_datei_als,
                  );
    for my $i (0..$#dbilder) {
        $fdb->Button(-text    => 'text',
                     -command => $dbefehle[$i],
                     -image   => $dbilder[$i],
                     -relief  => 'flat',
                    )
              ->pack(-side => 'left');
    }

    # Editbutton-Frame:
    my $feb1 = $fb->Frame(-relief      => 'groove',   # erzeugen
                          -borderwidth => 2,
                         )
                   ->pack(-side => 'left',
                          -padx        => 2,
                         );
    my $feb2 = $fb->Frame(-relief      => 'groove',   # modifizieren
                          -borderwidth => 2,
                         )
                   ->pack(-side => 'left',
                          -padx        => 2,
                         );
    my $feb3 = $fb->Frame(-relief      => 'groove',  # lschen
                          -borderwidth => 2,
                         )
                   ->pack(-side => 'left',
                          -padx        => 2,
                         );
    my @bilder = ($mw->Photo(-file => 'res/ecke_neu.gif'),
                  $mw->Photo(-file => 'res/ecke_weg.gif'),
                  $mw->Photo(-file => 'res/ecke_mergen.gif'),
                  $mw->Photo(-file => 'res/ecke_verschieben.gif'),
                  $mw->Photo(-file => 'res/ecke_verschieben2.gif'),
                  $mw->Photo(-file => 'res/kante.gif'),
                  $mw->Photo(-file => 'res/kante_loeschen.gif'),
                  $mw->Photo(-file => 'res/kante_hin.gif'),
                  $mw->Photo(-file => 'res/kante_zurueck.gif'),
                  $mw->Photo(-file => 'res/kante_beide.gif'),
                 );
    my @frames = ($feb1, $feb3, $feb3, $feb2, $feb2, $feb1, $feb3, $feb1, $feb1, $feb1);
    my @buttons = ();
    my @befehle = (sub {$Konfig{linientyp}     = 'e_ins';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                            #$_->configure(-relief => 'flat');
                        }
                        $buttons[0]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() == 0) {
                            print "\a";
                            $Konfig{statuszeile} = "Keine Ecken zum Lschen da!";
                            return;
                        }
                        $Konfig{linientyp}     = 'e_del';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[1]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() == 0) {
                            print "\a";
                            $Konfig{statuszeile} = "Keine Ecken zum Mergen da!";
                            return;
                        }
                        $Konfig{linientyp}     = 'e_mer';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        $_->configure(-relief => 'raised') for @buttons;
                        $buttons[2]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() == 0) {
                            print "\a";
                            $Konfig{statuszeile} = "Keine Ecken zum Verschieben da!";
                            return;
                        }
                        $Konfig{linientyp}     = 'e_mv1';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[3]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() == 0) {
                            print "\a";
                            $Konfig{statuszeile} = "Keine Ecken zum Verschieben da!";
                            return;
                        }
                        $Konfig{linientyp}     = 'e_mv2';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[4]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() < 2) {
                            print "\a";
                            $Konfig{statuszeile} = "Zu wenig Ecken vorhanden!";
                            return;
                        }
                        $Konfig{linientyp}     = 'k_ins';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[5]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->m() == 0) {
                            print "\a";
                            $Konfig{statuszeile} = "Keine Kanten zum Lschen da!";
                            return;
                        }
                        $Konfig{linientyp}     = 'k_del';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[6]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() < 2) {
                            print "\a";
                            $Konfig{statuszeile} = "Zu wenig Ecken vorhanden!";
                            return;
                        }
                        $Konfig{linientyp}     = 'k_inh';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[7]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() < 2) {
                            print "\a";
                            $Konfig{statuszeile} = "Zu wenig Ecken vorhanden!";
                            return;
                        }
                        $Konfig{linientyp}     = 'k_inz';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[8]->configure(-relief => 'sunken');
                       },
                   sub {if ($Graph->n() < 2) {
                            print "\a";
                            $Konfig{statuszeile} = "Zu wenig Ecken vorhanden!";
                            return;
                        }
                        $Konfig{linientyp}     = 'k_inb';
                        $linientyptext = $Linientypen{$Konfig{linientyp}};
                        for (@buttons) {
                            $_->configure(-relief => 'raised');
                        }
                        $buttons[9]->configure(-relief => 'sunken');
                       },
                  );
    for my $i (0..$#bilder) {
        push @buttons, $frames[$i]->Button(-text    => 'text',
                                           -command => $befehle[$i],
                                           -image   => $bilder[$i],
                                           -relief  => 'raised',
                                           #-relief  => 'flat',
                                          )
                                    ->pack(-side => 'left');
    }
    $buttons[0]->configure(-relief => 'sunken');

    # Editbutton-Erklrtext-Frame:
    my $febt = $fb->Frame(-relief      => 'groove',
                          -borderwidth => 2,
                         )
                   ->pack(-side   => 'left',
                          -padx   => 2,
                          -ipady  => 4,
                          -expand => 1,
                          -fill   => 'x',
                         );
    $febt->Label(-textvariable => \$linientyptext,
                 -foreground   => 'blue',
                )
          ->pack(-side => 'left');

    #--------------------------------------------------------------------------
    # Elemente packen:
    #--------------------------------------------------------------------------
    $stat_l-> pack(-side   => 'bottom',
                  #-expand => 1,
                   -fill   => 'x',
                   -anchor => 'w',
                  );
    $mf->     pack(-side   => 'top',
                   #-expand => 1,
                   -fill   => 'x',
                   -anchor => 'n',
                  );
    $fb->     pack(-side   => 'top',
                   #-expand => 1,
                   -fill   => 'x',
                  );
    $graf_lw->pack(-side   => 'left',
                   -expand => 1,
                   -fill   => 'both',
                  );
    $f->      pack(-side   => 'left',
                   #-expand => 1,
                   -fill   => 'y',
                  );

    #--------------------------------------------------------------------------
    # Restliches:
    #--------------------------------------------------------------------------
    $mw->bind ('<Control-b>', \&beenden);
    $mw->bind ('<Escape>',    sub {$graf_lw->focus()});
    $mw->bind ('<F5>',        sub {$refr_b->invoke()});

    $mw->bind ('<Control-n>', \&neue_datei);
    $mw->bind ('<Control-l>', \&lade_datei);
    $mw->bind ('<Control-s>', \&speichere_datei);
    $mw->bind ('<Control-i>', \&zeige_daten_an);
    $mw->bind ('<F1>',        \&hilfe);

    $mw->bind ('<Alt-d>',     sub {$Konfig{menu}->postcascade('Datei');});
    $mw->bind ('<Alt-b>',     sub {$Konfig{menu}->postcascade('Bearbeiten');});
    $mw->bind ('<Alt-i>',     sub {$Konfig{menu}->postcascade('Interna');});
    $mw->bind ('<Alt-h>',     sub {$Konfig{menu}->postcascade('Hilfe');});

    # Zum Neuzeichnen fr das Gitter:
    $Konfig{canvas}->CanvasBind ('<Configure>', \&refresh );

    $mw->geometry('600x500');

    $Konfig{mw} = $mw;
} # sub tk_start


sub add_file_menu () {
# -----------------------------------------------------------------------------
# sub          : a d d _ f i l e _ m e n u
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Fgt das Dateimen hinzu.
#                Ausgelagert, um aktuelle bearbeitete Dateien anzuzeigen.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.3 - 09.02.2004 - CD - Ansicht erneuern auskommentiert (ist jetzt im
#                           Men Ansicht.
# 0.0.4 - 10.02.2004 - CD - Module in Namensraum Graph::GED:: verschoben.
# -----------------------------------------------------------------------------

    print "add_file_menue\n" if $Konfig{debug};


    my $menu_datei =
    $Konfig{menu}->Menu(-font      => $Konfig{menufont},
                -tearoff   => 0,
                -menuitems => [ ["command"    => "Neu",
                                 -command     => \&neue_datei,
                                 -accelerator => 'Ctrl-N',
                                 -font        => $Konfig{menufont},
                                 -underline   => 0,
                                ],
                                ["command"    => "Laden",
                                 -command     => \&lade_datei,
                                 -accelerator => 'Ctrl-L',
                                 -font        => $Konfig{menufont},
                                ],
                                ["command"    => "Speichern",
                                 -command     => \&speichere_datei,
                                 -accelerator => 'Ctrl-S',
                                 -font        => $Konfig{menufont},
                                ],
                                ["command"    => "Speichern unter",
                                 -command     => \&speichere_datei_als,
                                 -font        => $Konfig{menufont},
                                ],
                                '-',
                                ["command"    => "Export nach LaTeX",
                                 -command     => \&export_nach_latex,
                                 -font        => $Konfig{menufont},
                                ],
                                ["command"    => "Export nach Postscript",
                                 -command     => \&export_nach_postscript,
                                 -font        => $Konfig{menufont},
                                ],
                                #'-',
                                #["command"    => "Anzeige erneuern",
                                # -command     => \&refresh,
                                # -accelerator => 'F5',
                                # -font        => $Konfig{menufont},
                                #],
                              ],
               );
    $menu_datei->separator();
    for (reverse Graph::GED::FHist::array()) {
        $menu_datei->command(-label       => $_,
                             -command     =>
                              [sub {$Konfig{dateiname} = $_[0];
                                    clear();
                                    load($_[0]);
                                    refresh();
                                    $Konfig{mw}->title("G - E - D   -   ($Konfig{dateiname})");
                                   }, $_
                              ],
                             #-accelerator => 'Ctrl-B', #'ESC',
                             -font        => $Konfig{menufont},
                            );
    }
    $menu_datei->separator();
    $menu_datei->command(
                         -label       => "Beenden",
                         -command     => \&beenden,
                         -accelerator => 'Ctrl-B', #'ESC',
                         -font        => $Konfig{menufont},
                        );
    $Konfig{menu}->entryconfigure('Datei', -menu => $menu_datei);
} # sub add_file_menu


sub bind_start () {
# -----------------------------------------------------------------------------
# sub          : b i n d _ s t a r t
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Bindet <Button-1> an zeichen_anfang(), falls es noch keine
#                Bindung gibt.
#                Wenn es eine <Motion>-Bindung gibt, dann muss man dem Benutzer
#                erlauben, das Zeichnen des Elements zu beenden, bevor
#                <Button-1> erneut gebunden wird.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 31.01.2003 - CD - Erstellt
# 0.0.2 - 04.02.2003 - CD - Canvas-Widget muss nun nicht mehr bergeben werden.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    my @bindings  = $Konfig{canvas}->Tk::bind("<Motion>");
    return if scalar @bindings;

    $Konfig{canvas}->Tk::bind("<Button-1>", [\&zeichnen_anfang, Ev('x'), Ev('y')]);
} # sub bind_start


sub zeichnen_anfang ($$$) {
# -----------------------------------------------------------------------------
# sub          : z e i c h n e n _ a n f a n g
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Wird aufgerufen, wenn der Benutzer mit der Maus auf die
#                Arbeitsflche klickt und noch kein Zeichenvorgang stattfindet.
#                Abhngig vom ausgewhlten "Linientyp" (kann auch etwa 'Ecke'
#                sein), wird das Zeichnen der Linie begonnen (oder - wie im
#                Fall von 'Ecke' - das Objekt gezeichnet, wenn es keiner zwei
#                Mausklicks bedarf).
# Parameter    : Canvas-Widget, x, y
#                Auerdem wird die globale Variable '$Konfig{linientyp}' ausge-
#                wertet.
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1  - 31.01.2003 - CD - Erstellt
# 0.0.2  - 03.02.2003 - CD - Eckenkoordinaten speichern
#                            Kantenkoordinaten auf Ecken setzen und nur in der
#                            Nhe von Ecken zu Zeichnen beginnen!
#                            Eckenlschen eingebaut.
# 0.0.3  - 05.02.2003 - CD - 'Ecke verschieben' eingebaut.
#                            'Ecke verschieben 2' eingebaut.
# 0.0.4  - 10.02.2003 - CD - An neue Linientypenbezeichungen angepasst.
# 0.0.5  - 18.03.2003 - CD - Neue Linientypenkrzel verwendet. Die Langformen
#                            sind im Hash %Linientypen ber die Krzel als
#                            Schlssel zugnglich.
# 0.0.6  - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                            Umstellung vieler globaler Variablen auf %Graph.
# 0.0.7  - 06.02.2004 - CD - Beim Eckensetzen ggf. am Gittereinrasten.
# 0.0.8  - 06.02.2004 - CD - Eckenmergen eingebaut.
#                            Ecken/Kantenfunktionalitten ausgelagert.
# 0.0.9  - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.10 - 10.02.2004 - CD - Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $w = shift; # widget
    my $x = shift; # x-Koordinate
    my $y = shift; # y-Koordinate

    print "zeichnen_anfang x='$x', y='$y', Linientyp='$Konfig{linientyp}'\n"
          if $Konfig{debug};

    # -------------------------------------------------------------------------
    # Vorarbeiten:
    # -------------------------------------------------------------------------

    # Im Fall von Linientypen Startkoordinaten auf die nchste Ecke setzen:
    if ($Konfig{linientyp} eq 'k_ins' or
        $Konfig{linientyp} eq 'k_inh' or
        $Konfig{linientyp} eq 'k_inz' or
        $Konfig{linientyp} eq 'k_inb' or
        $Konfig{linientyp} eq 'e_mv1' or
        $Konfig{linientyp} eq 'e_mv2'  )
    {
        my $e = $Graph->meint_ecke($x, $y);
print "===========> Ecke $e <=========\n";
        if ($e > -1 and $Graph->n() > 1) { # Linienzeichnen macht erst ab 2
                                           # Ecken Sinn!
                                           # Ecken verschieben auch ?!
            $Konfig{zx} = $Graph->ecke($e)->x();
            $Konfig{zy} = $Graph->ecke($e)->y();
            $Konfig{startecke} = $e;
            $Graph->kantenform($Konfig{linientyp});
        }
        else {
            print "\a";
            $Konfig{statuszeile} = 'Sie mssen an einer Ecke anfangen!';
            return;
        }
    }
    else {
        $Konfig{zx} = $x;
        $Konfig{zy} = $y;
    }


    # -------------------------------------------------------------------------
    # Operationen, die in aendere_item() und zeichnen_ende weiter behandelt
    # werden:
    # -------------------------------------------------------------------------

    # ----------
    if ($Konfig{linientyp} eq 'k_ins') {
        $w->createLine($Konfig{zx}, $Konfig{zy}, $x, $y,
                       -width => 1,
                       -tags  => 'zeichnemichjetzt',
                       -fill  => $Graph->kantenfarbe(),
                      );
    }
    # ---------->
    elsif ($Konfig{linientyp} eq 'k_inh') {
        $w->createLine($Konfig{zx}, $Konfig{zy}, $x, $y,
                       -width      => 1,
                       -tags       => 'zeichnemichjetzt',
                       -arrow      => 'last',
                       -arrowshape => [5, 7, 3],
                       -fill       => $Graph->kantenfarbe(),
                      );
    }
    # <----------
    elsif ($Konfig{linientyp} eq 'k_inz') {
        $w->createLine($Konfig{zx}, $Konfig{zy}, $x, $y,
                       -width      => 1,
                       -tags       => 'zeichnemichjetzt',
                       -arrow      => 'first',
                       -arrowshape => [5, 7, 3],
                       -fill       => $Graph->kantenfarbe(),
                      );
    }
    # <---------->
    elsif ($Konfig{linientyp} eq 'k_inb') {
        $w->createLine($Konfig{zx}, $Konfig{zy}, $x, $y,
                       -width      => 1,
                       -tags       => 'zeichnemichjetzt',
                       -arrow      => 'both',
                       -arrowshape => [5, 7, 3],
                       -fill       => $Graph->kantenfarbe(),
                      );
    }
    # * --->
    elsif ($Konfig{linientyp} eq 'e_mv1') {
        $w->createLine($Konfig{zx}, $Konfig{zy}, $x, $y,
                       -width      => 1,
                       -tags       => 'zeichnemichjetzt',
                       -width      => 1 + 2 * $Graph->radius(),
                       -arrow      => 'last',
                       -arrowshape => [
                                       5 + $Graph->radius(),
                                       7 + $Graph->radius(),
                                       3 + $Graph->radius(),
                                      ],
                       -fill       => $Graph->kantenfarbe(),
                      );
    }



    # -------------------------------------------------------------------------
    # Operationen, die hier bereits abgeschlossen werden knnen:
    # -------------------------------------------------------------------------

    # *
    if ($Konfig{linientyp} eq 'e_ins') {
        # falls am Gitter eingerastet werden soll, Koordinaten einrasten:
        if ($Konfig{rastimgitter}) {
            ($Konfig{zx}, $Konfig{zy}) = raste_ein($Konfig{zx}, $Konfig{zy});
        }

        if ($Graph->ecke_zu_nah($Konfig{zx}, $Konfig{zy})) {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind zu dicht an einer anderen Ecke!';
            return;
        }
        else {
            $Graph->ecke_einfuegen($Konfig{zx}, $Konfig{zy});
            zeichne_ecke($Graph->n()-1);
            $w->Tk::bind("<Motion>",  "");
            bind_start();
        }
    }
    # -*
    elsif ($Konfig{linientyp} eq 'e_del') {
        my $e = $Graph->meint_ecke($x, $y);
        if ($e > -1) {
            $Graph->ecke_loeschen($e);
            refresh();
        }
        else {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind nicht dicht genug an einer Ecke!';
            return;
        }
    }

    # -* merge
    elsif ($Konfig{linientyp} eq 'e_mer') {
        my $e = $Graph->meint_ecke($x, $y);
        if ($e > -1) {
            $Graph->ecke_mergen($e);
            refresh();
        }
        else {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind nicht dicht genug an einer Ecke!';
            return;
        }
    }
    # - ---------
    elsif ($Konfig{linientyp} eq 'k_del') {
        my $k = $Graph->meint_kante($x, $y);
        if ($k > -1) {
            $Graph->kante_loeschen($k);
            refresh();
        }
        else {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind nicht dicht genug an einer Kante oder '.
                           'zu dicht an zweien!';
            return;
        }
    }
    else {
        # Im Fall von "echten Linien" (also solchen Objekten, die eine
        # zweite Benutzerangabe zum Beenden des Zeichnens bentigen) wird
        # <Motion> an aendere_item() und <Button-1> an zeichnen_ende()
        # gebunden:
        $w->Tk::bind("<Motion>",   [\&aendere_item,  Ev('x'), Ev('y')]);
        $w->Tk::bind("<Button-1>", [\&zeichnen_ende, Ev('x'), Ev('y')]);
    }
} # sub zeichnen_anfang


sub aendere_item ($$$) {
# -----------------------------------------------------------------------------
# sub          : a e n d e r e _ i t e m
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Diese Funktion ist an <Motion> gebunden, wenn ein
#                Zeichenvorgang luft.
# Parameter    : Canvas-Widget, x, y
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 31.01.2003 - CD - Erstellt
# 0.0.2 - 05.02.2003 - CD - 'Ecke verschieben 2' eingebaut.
# 0.0.3 - 10.02.2003 - CD - An neue Linientypenbezeichungen angepasst.
# 0.0.4 - 18.03.2003 - CD - Neue Linientypenkrzel verwendet.
# 0.0.5 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.6 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.7 - 10.02.2004 - CD - Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $w = shift; # widget
    my $x = shift; # x-Koordinate
    my $y = shift; # y-Koordinate

    print "aendere_item x='$x', y='$y'\n" if $Konfig{debug} > 1;

    if ($Konfig{linientyp} eq 'e_mv2') {
        my $e = $Konfig{startecke}; # hier steckt die Ecke drin!
        $Graph->ecke($e)->x($x);
        $Graph->ecke($e)->y($y);
        refresh();
    }
    else {
        $w->coords('zeichnemichjetzt', $Konfig{zx}, $Konfig{zy}, $x, $y);
        # Hier wird auf den Tag 'zeichnemichjetzt' zugegriffen, der in
        # zeichnen_anfang() vergeben wurde.
    }
} # sub aendere_item


sub zeichnen_ende ($$$) {
# -----------------------------------------------------------------------------
# sub          : z e i c h n e n _ e n d e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Diese Funktion wird aufgerufen, wenn der Benutzer beim
#                Zeichnen eines Objektes das zweite Mal klickt.
#                Damit wird der Zeichenvorgang beendet, die Bindungen von
#                <Motion> aufgehoben und die Bindung von <Button-1> durch
#                den Aufruf von bind_start() wieder auf zeichnen_anfang()
#                gesetzt.
# Parameter    : Canvas-Widget, x, y
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1  - 31.01.2003 - CD - Erstellt
# 0.0.2  - 03.02.2003 - CD - Ecke bestimmen, falls keine da, wird das Beenden
#                            verweigert.
#                            Kantendaten speichern.
# 0.0.3  - 05.02.2003 - CD - 'Ecke verschieben' eingebaut.
#                            'Ecke verschieben 2' eingebaut.
#                            Schleifen verhindert.
# 0.0.4  - 10.02.2003 - CD - An neue Linientypenbezeichungen angepasst.
# 0.0.5  - 18.03.2003 - CD - Neue Linientypenkrzel verwendet.
#                            Bei Ecke Schnell verschieben nicht mehr auf zu
#                            nah zur Ausgangsecke getestet.
# 0.0.6  - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                            Umstellung vieler globaler Variablen auf %Graph.
# 0.0.7  - 06.02.2004 - CD - Beim Eckenverschieben ggf. am Gittereinrasten.
# 0.0.8  - 06.02.2004 - CD - Ecken/Kantenfunktionalitten ausgelagert.
# 0.0.9  - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.10 - 10.02.2004 - CD - Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $w = shift; # widget
    my $x = shift; # x-Koordinate
    my $y = shift; # y-Koordinate

    print "zeichnen_ende x='$x', y='$y'\n" if $Konfig{debug};

    if ($Konfig{linientyp} eq 'e_mv1') {
        my $e = $Konfig{startecke}; # hier steckt die Ecke drin!

        # falls am Gitter eingerastet werden soll, Koordinaten einrasten:
        if ($Konfig{rastimgitter}) {
            ($x, $y) = raste_ein($x, $y);
        }

        if ($Graph->ecke_zu_nah_ohne($x, $y, $e)) {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind zu dicht an einer anderen Ecke!';
            return;
        }

        else {
            #my $e = $Konfig{startecke}; # hier steckt die Ecke drin!
            print "Ecke $e wird verschoben, von (",
                   $Graph->ecke($e)->x(), ", ", $Graph->ecke($e)->y(),
                   ") auf ($x, $y).\n" if $Konfig{debug};                     #"
            $w->coords('zeichnemichjetzt', $Konfig{zx}, $Konfig{zy}, $x, $y);
            $w->delete('zeichnemichjetzt'); # dtag
            $Graph->ecke($e)->x($x);
            $Graph->ecke($e)->y($y);
            refresh();
        }
    }
    elsif ($Konfig{linientyp} eq 'e_mv2') {
        my $e = $Konfig{startecke}; # hier steckt die Ecke drin!

        # falls am Gitter eingerastet werden soll, Koordinaten einrasten:
        if ($Konfig{rastimgitter}) {
            ($x, $y) = raste_ein($x, $y);
        }

        if ($Graph->ecke_zu_nah_ohne($x, $y, $e)) {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind zu dicht an einer anderen Ecke!';
            return;
        }
        else {
            print "Ecke $e wird verschoben, von (",
                   $Graph->ecke($e)->x(), ", ", $Graph->ecke($e)->y(),
                   ") auf ($x, $y).\n" if $Konfig{debug};                     #"
            $Graph->ecke($e)->x($x);
            $Graph->ecke($e)->y($y);
            refresh();
        }
    }
    else { # Kanten
        my $e = $Graph->meint_ecke($x, $y);
        if ($e > -1) {
            if ($e == $Konfig{startecke}) {
                print "\a";
                $Konfig{statuszeile} = 'Schleifen sind im Moment nicht mglich!';
                return;
            }
            $x = $Graph->ecke($e)->x();
            $y = $Graph->ecke($e)->y();
            $Graph->kante_einfuegen($Konfig{startecke}, $e);
        }
        else {
            print "\a";
            $Konfig{statuszeile} = 'Sie sind zu nicht dicht genug an einer Ecke!';
            return;
        }

        $w->coords('zeichnemichjetzt', $Konfig{zx}, $Konfig{zy}, $x, $y);
        $w->dtag('zeichnemichjetzt');
        # Hier wird auf den Tag 'zeichnemichjetzt' zugegriffen, der in
        # zeichnen_anfang() vergeben wurde.
        # Auerdem wird der Tag jetzt von diesem Objekt entfernt, sonst wrde
        # es beim Zeichenen des nchsten Objekts mit verndert.

        $Konfig{zx} = $Graph->ecke($e)->x();
        $Konfig{zy} = $Graph->ecke($e)->y();
        $Konfig{startecke} = $e;
    }

    $w->Tk::bind("<Motion>",  "");
    bind_start();
    $Konfig{statuszeile} = ''; # ok :)
} # sub zeichnen_ende


sub refresh () {
# -----------------------------------------------------------------------------
# sub          : r e f r e s h
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Alles neu zeichnen.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 06.02.2004 - CD - Falls gewnscht Gitternetz einzeichnen.
#                           Gitterlinienkoordinaten in @GitterX und @GitterY
#                           merken.
# 0.0.4 - 06.02.2004 - CD - canvas_groesse() aufgerufen.
# 0.0.5 - 07.02.2004 - CD - canvas_groesse() aufgerufen und die Daten in den
#                           Klassenvariablen $MinX, $MinY, $MaxX, $MaxY der
#                           Klasse Graph2d gespeichert.
# 0.0.6 - 08.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.7 - 09.02.2004 - CD - Gitterkoordinaten auch berechnen, wenn nur
#                           eingerastet werden soll.
# -----------------------------------------------------------------------------
    print "refresh\n" if $Konfig{debug};

    #--------------------------------------------------------------------------
    # Aktuelle Gre der Zeichenflche ermitteln:
    #--------------------------------------------------------------------------
    ($Graph2d::MinX, $Graph2d::MinY,
     $Graph2d::MaxX, $Graph2d::MaxY) = canvas_groesse();

    #--------------------------------------------------------------------------
    # Zeichenflche leeren:
    #--------------------------------------------------------------------------
    $Konfig{canvas}->delete('all');

    #--------------------------------------------------------------------------
    # Gitternetz einzeichnen:
    #--------------------------------------------------------------------------
    if ($Konfig{gitterzeigen} or $Konfig{rastimgitter}) {
        @GitterX = (); # ev. vorhandene
        @GitterY = (); # alte Eintrge lschen

        for (
             my $x  =  $Konfig{gitterweite};
                $x  <= $Graph2d::MaxX;
                $x  += $Konfig{gitterweite}
            )
        {
            $Konfig{canvas}->createLine($x, $Graph2d::MinY, $x, $Graph2d::MaxY,
                                        -width => 1,
                                        -fill  => $Konfig{gitterfarbe},
                                       )
                                       if $Konfig{gitterzeigen};
            push @GitterX, $x;
        }

        for (
             my $y =  $Konfig{gitterweite};
                $y <= $Graph2d::MaxY;
                $y += $Konfig{gitterweite}
            )
        {
            $Konfig{canvas}->createLine($Graph2d::MinX, $y, $Graph2d::MaxX, $y,
                                        -width => 1,
                                        -fill  => '#C0C0C0',
                                       )
                                       if $Konfig{gitterzeigen};
            push @GitterY, $y;
        }
    }

    #--------------------------------------------------------------------------
    # Graphen neu einzeichnen:
    #--------------------------------------------------------------------------
    zeichne_ecke($_)  for (0..$Graph->n()-1);
    zeichne_kante($_) for (0..$Graph->m()-1);
} # sub refresh


sub clear (;$) {
# -----------------------------------------------------------------------------
# sub          : c l e a r
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Alles lschen
# Parameter    : bind, siehe Kommentar vom 05.02.2003 (optional)
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 04.02.2003 - CD - Canvas-Widget muss nun nicht mehr bergeben werden.
# 0.0.3 - 05.02.2003 - CD - Parameter $bind hinzugefgt. Bei 0 wird bind_start
#                           nicht aufgerufen, d.h. der Aufrufer kmmert sich
#                           selbst um die Bindung. Bei anderen Werten oder ohne
#                           Parameter wird bind_start aufgerufen.
#                           Bentigt wird dies, um das Malen von Ecken nach
#                           Doppelklick auf Namen der Datei beim Laden zu
#                           verhindern.
# 0.0.4 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.5 - 09.02.2004 - CD - Umstellung auf Graphenklassen.
# -----------------------------------------------------------------------------

    my $bind = shift;

    $bind = 1 unless defined $bind;

    print "clear - bind = '$bind'\n" if $Konfig{debug};

    #--------------------------------------------------------------------------
    # Graphendarstellung lschen:
    #--------------------------------------------------------------------------
    $Konfig{canvas}->delete('all');

    #--------------------------------------------------------------------------
    # Graphendaten lschen:
    #--------------------------------------------------------------------------
    $Graph->clear();

    #--------------------------------------------------------------------------
    # Bindung aufheben, falls man gerade am Zeichnen ist:
    #--------------------------------------------------------------------------
    $Konfig{canvas}->Tk::bind("<Motion>",  "");

    #--------------------------------------------------------------------------
    # Bindungen wieder herstellen, falls gewnscht:
    #--------------------------------------------------------------------------
    bind_start() if $bind;

} # sub clear


sub zeichne_ecke ($) {
# -----------------------------------------------------------------------------
# sub          : z e i c h n e _ e c k e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeichnet die angegebene Ecke ein.
# Parameter    : Eckennummer 0 .. $Graph->n()-1
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 04.02.2003 - CD - Programmabbruch bei undefinierten Koordinaten
#                           eingebaut.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Graph.
# 0.0.4 - 07.02.2004 - CD - Verwendung des Farbwertes $Graph{eckenfarbe}
#                           statt hardvercodetem Rot.
# 0.0.5 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.6 - 10.02.2004 - CD - Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $e = shift;

    my $x = $Graph->ecke($e)->x();
    my $y = $Graph->ecke($e)->y();

    die "Koordinaten von Ecke $e sind undefiniert!" unless defined $x and
                                                           defined $y;

    print "zeichne_ecke, e = '$e', (N = '",
          $Graph->n(), "')\n",
          "    (", $x, ", ", $y, ")\n",
          "    Radius = '", $Graph->radius(),
          "', Delta = '", $Graph->delta(), "'\n"
          if $Konfig{debug} > 1;

    $Konfig{canvas}->
        createOval($x-$Graph->radius(), $y-$Graph->radius(),
                   $x+$Graph->radius(), $y+$Graph->radius(),
                   -width   => 1,
                   -fill    => $Graph->eckenfarbe(),
                   -outline => $Graph->eckenfarbe(),
                  );
} # sub zeichne_ecke


sub zeichne_kante ($) {
# -----------------------------------------------------------------------------
# sub          : z e i c h n e _ k a n t e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeichnet die angegebene Kante ein.
# Parameter    : Kantennummer 0 .. $Graph{m}-1
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 04.02.2003 - CD - Programmabbruch bei undefinierten Koordinaten
#                           eingebaut.
# 0.0.3 - 11.02.2003 - CD - Angepasst an neue Linientypennamen.
# 0.0.4 - 18.03.2003 - CD - Neue Linientypenkrzel verwendet.
# 0.0.5 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.6 - 07.02.2004 - CD - Verwendung des Farbwertes $Graph{kantenfarbe}
#                           statt hardvercodetem Schwarz.
# 0.0.7 - 09.02.2004 - CD - Arrowshape abhngig vom Radius.
# 0.0.8 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.9 - 10.02.2004 - CD - Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $k = shift;

    my $ea   = $Graph->kante($k)->a();
    my $ee   = $Graph->kante($k)->e();
    my $form = $Graph->kante($k)->form();

    die "Ecken von Kante $k sind undefiniert!" unless defined $ea and
                                                      defined $ee and
                                                      defined $form;
    my $xa   = $Graph->ecke($ea)->x();
    my $ya   = $Graph->ecke($ea)->y();
    my $xe   = $Graph->ecke($ee)->x();
    my $ye   = $Graph->ecke($ee)->y();

    die "Koordinaten von Ecke $ea sind undefiniert!" unless defined $xa and
                                                            defined $ya;
    die "Koordinaten von Ecke $ee sind undefiniert!" unless defined $xe and
                                                            defined $ye;

    print "zeichne_kante, k = '$k', (M = '",
          $Graph->m(), "')\n",
          "    ",   $ea,
          " --- ",  $ee,
          ",    (", $xa,
          ", ",     $ya,
          " -> ",   $xe,
          ", ",     $ye,
          ")\n"
          if $Konfig{debug} > 1;

    my $arrow = 'none';

    print "Kante $k von Ecke $ea nach Ecke $ee, ($xa,$ya) -> ($xe, $ye)\n"
          if $Konfig{debug} > 1;

    $arrow = 'last'  if $form eq 'k_inh';
    $arrow = 'first' if $form eq 'k_inz';
    $arrow = 'both'  if $form eq 'k_inb';

    if ($arrow eq 'none') {
        $Konfig{canvas}->
            createLine($xa, $ya, $xe, $ye,
                       -width => 1,
                       -fill  => $Graph->kantenfarbe(),
                      );
    }
    else {
        $Konfig{canvas}->
            createLine($xa, $ya, $xe, $ye,
                       -width      => 1,
                       -arrow      => $arrow,
                      #-arrowshape => [5, 7, 3],
                       -arrowshape => [
                                       2*$Graph->radius() - 1,
                                       2*$Graph->radius() + 1,
                                       $Graph->radius(),
                                      ],
                       -fill       => $Graph->kantenfarbe(),
                      );
    }

} # sub zeichne_kante


sub lade_datei () {
# -----------------------------------------------------------------------------
# sub          : l a d e _ d a t e i
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ein Dialog zum Laden einer Graphendatei.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 13.02.2003 - CD - Endlich wird der Klick nach Doppelklick nicht mehr
#                           in dem Canvas ausgewertet.
#                           Dank Tk::after / Ishka von www.perl.de :)
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    print "lade_datei\n" if $Konfig{debug};

    #
    # Bindungen zu <Motion> und <Button-1> lsen:
    # (sonst setztz man mit dem Click auf OK ev eine Ecke, falls darunter das
    # Canvas-Widget ist.)
    #
    #my @bindings  = $Konfig{canvas}->Tk::bind("<Motion>");
    #print "Bindungen: '", @bindings, "'\n";
    #my @bindings2  = $Konfig{canvas}->Tk::bind("<Button-1>");
    #print "Bindungen2: '", @bindings2, "'\n";
    $Konfig{canvas}->Tk::bind("<Motion>",    "");
    $Konfig{canvas}->Tk::bind("<Button-1>",  "");
    #$Konfig{canvas}->Tk::bind("<Button-1>",  sub {print "JAUJAUJAU\n"});
    #@bindings  = $Konfig{canvas}->Tk::bind("<Motion>");
    #print "Bindungen: '", @bindings, "'\n";
    #@bindings2  = $Konfig{canvas}->Tk::bind("<Button-1>");
    #print "Bindungen2: '", @bindings2, "'\n";

    my $typen = [
        ['Interne Graphen Dateien', '.ged'           ],
        ['Alle Dateien',            '*'              ],
#       ['HTML-Dateien',            ['.html', '.htm']],
    ];
    my $dn = $Konfig{mw}->getOpenFile(-filetypes  => $typen,
                              -initialdir => $Konfig{pfad},
                             );

    if (defined $dn and $dn ne "") {
        $Konfig{dateiname} = $dn;
        print "Dateiname = '$dn'\n";
        $Konfig{mw}->title('G - E - D   ' . $Konfig{version} . "   -   ($dn)");
        clear(0);
        load($dn);
        refresh();
    }

    #
    # Bindungen wieder herstellen:
    #
    #@bindings  = $Konfig{canvas}->Tk::bind("<Motion>");
    #print "Bindungen: '", @bindings, "'\n";
    #@bindings2  = $Konfig{canvas}->Tk::bind("<Button-1>");
    #print "Bindungen2: '", @bindings2, "'\n";
    $Konfig{mw}->after(1000, \&bind_start);
} # sub lade_datei


sub speichere_datei () {
# -----------------------------------------------------------------------------
# sub          : s p e i c h e r e _ d a t e i
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ein Dialog zum Speichern einer Graphendatei.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2003 - CD - Doppelten Aufruf von save im Fall von Speichern
#                           mit leerem Dateinamen verhindert.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------
    print "speichere_datei, Dateiname ist '$Konfig{dateiname}'\n" if $Konfig{debug};

    if ($Konfig{dateiname} eq '') {
        speichere_datei_als();
    }
    else {
        save($Konfig{dateiname});
    }
} # sub speichere_datei


sub speichere_datei_als () {
# -----------------------------------------------------------------------------
# sub          : s p e i c h e r e _ d a t e i _ a l s
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ein Men zum Speichern einer Graphendatei unter einem anderen
#                Namen.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 11.02.2003 - CD - -initialfile rausgenommen wegen Problemen in tk.pm
# 0.0.3 - 17.02.2003 - CD - Dateinamen in Historie eingetragen.
#                           Rumpfnamen als Vorschlag (-initialfile) bergeben.
# 0.0.4 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    print "speichere_datei_als, Dateiname ist '$Konfig{dateiname}'\n" if $Konfig{debug};

    my $name = $Konfig{dateiname};
    $name =~ s:.*/([^/]*).ged:$1:g;

    my $typen = [
        ['Interne Graphen Dateien', '.ged'],
        ['Alle Dateien',            '*'   ],
    ];
    my $dn = $Konfig{mw}->getSaveFile(-filetypes        => $typen,
                              -defaultextension => 'ged',
                              -initialfile      => $name,
#                              -initialdir       => $Konfig{pfad},
# Entfllt, da die Datei mit absolutem Pfad angegeben wird...
                             );

    if (defined $dn and $dn ne "") {
        $Konfig{dateiname} = $dn;
        print "Dateiname = '$Konfig{dateiname}'\n";
        $Konfig{mw}->title('G - E - D   ' . $Konfig{version} . "   -   ($Konfig{dateiname})");
        speichere_datei();
        add($Konfig{dateiname});
    }
} # sub speichere_datei_als


sub export_nach_latex () {
# -----------------------------------------------------------------------------
# sub          : e x p o r t _ n a c h _ l a t e x
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ein Men zum Speichern einer Graphendatei im LaTeX-Format.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 13.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    print "export_nach_latex, Dateiname ist '$Konfig{dateiname}'\n" if $Konfig{debug};

    my $name = $Konfig{dateiname};

    $name =~ s/\.ged$/.tex/;

    my $typen = [
        ['LaTeX-Dateien',           '.tex'],
        ['Interne Graphen Dateien', '.ged'],
        ['Alle Dateien',            '*'   ],
    ];
    my $dn = $Konfig{mw}->
                getSaveFile(-title            => "Graph nach LaTeX exportieren",
                            -filetypes        => $typen,
                            -defaultextension => 'tex',
#                             -initialfile      => $name,
# macht leider auch Probleme
#                             -initialfile      => $Konfig{dateiname},
# Dann knallts in tk.pm ...
#                             -initialdir       => $Konfig{pfad},
# Entfllt, da die Datei mit absolutem Pfad angegeben wird...
                             );

    if (defined $dn and $dn ne "") {
        print "LaTeX-Dateiname = '$dn'\n" if $Konfig{debug} > 1;
        toLaTeX($dn);
        $Konfig{statuszeile} = "Datei als '$name' nach LaTeX exportiert.";
    }

} # sub export_nach_latex


sub export_nach_postscript () {
# -----------------------------------------------------------------------------
# sub          : e x p o r t _ n a c h _ p o s t s c r i p t
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ein Men zum Speichern einer Graphendatei im PS-Format.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 13.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    print "export_nach_postscript, Dateiname ist '$Konfig{dateiname}'\n" if $Konfig{debug};

    my $name = $Konfig{dateiname};

    $name =~ s/\.ged$/.ps/;

    my $typen = [
        ['Postscript-Dateien',      '.ps'],
        ['Interne Graphen Dateien', '.ged'],
        ['Alle Dateien',            '*'   ],
    ];
    my $dn = $Konfig{mw}->
                getSaveFile(-title            => "Graph nach Postscript " .
                                                 "exportieren",
                            -filetypes        => $typen,
                            -defaultextension => 'ps',
#                            -initialfile      => $name,
# macht leider auch Probleme
#                            -initialfile      => $Konfig{dateiname},
# Dann knallts in tk.pm ...
#                            -initialdir       => $Konfig{pfad},
# Entfllt, da die Datei mit absolutem Pfad angegeben wird...
                             );

    if (defined $dn and $dn ne "") {
        print "Postscript-Dateiname = '$dn'\n" if $Konfig{debug} > 1;
        $Konfig{canvas}->postscript(-file => $dn);

        $Konfig{statuszeile} = "Datei als '$name' nach Postscript exportiert.";
    }
} # sub export_nach_postscript


sub dump_eingeben () {
# -----------------------------------------------------------------------------
# sub          : d u m p _ e i n g e b e n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ermglicht es, eine interne Datei / einen Dump per Hand
#                einzugeben.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 12.03.2003 - CD - Funktionalitt eingebaut
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.4 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# -----------------------------------------------------------------------------

    print "dump_eingeben\n" if $Konfig{debug};

    sub load_dump {
        print "load_dump\n" if $Konfig{debug};

        my $text = shift;

        $Graph->clear();

        # Linientypenhash aufbauen:
        my %typen;
        for (keys %Linientypen) {
            $typen{$Linientypen{$_}} = $_;
        }


        my @lines = split /\n/, $text;

        my $hx = 0;
        my $hy = 0;
        my $he = 0;
        my $ha = 0;
        my $hf = 0;

        my $l = ''; # aktuelle Zeile
        my $z = 0;  # Zeilennummer

        # Kommentarkopf berlesen:
        do {
            $l = shift @lines;
            ++$z;
        } while '#' eq substr $l, 0, 1;

        # Eckenzahl einlesen:
        return "Fehler in Zeile $z - N fehlt!" unless defined $l;
        (my $n) = $l =~ /^\s*(\d+)\s*$/;
        return "Fehler in Zeile $z - N fehlt!" unless defined $1;


        # Eckenkoordinaten einlesen:
        for (0..$n-1) {
            $l = shift @lines;
            ++$z;
            return "Fehler in Zeile $z - Eckenkoordinate fehlt!"
                unless defined $l;
            $l =~ /^\s*(\d+)\s*;\s*(\d+)\s*$/;
            return "Fehler in Zeile $z - Eckenkoordinate fehlt!"
                unless defined $1 and defined $2;
            $Graph->ecke_einfuegen($1, $2);
        }


        # Kantenzahl einlesen:
        $l = shift @lines;
        ++$z;
        return "Fehler in Zeile $z - M fehlt!" unless defined $l;
        chomp $l;
        (my $m) = $l =~ /^\s*(\d+)\s*$/;

        return "Fehler in Zeile $z - M fehlt!" unless defined $1;

        # Eckenkoordinaten einlesen:
        for (0..$m-1) {
            $l = shift @lines;
            ++$z;
            return "Fehler in Zeile $z - Kantendaten fehlen!"
                unless defined $l;
            $l =~ /^\s*(\d+)\s*;\s*(\d+)\s*;\s*(.*)\s*$/;
            return "Fehler in Zeile $z - Kantendaten fehlen!"
                unless defined $1 and defined $2 and defined $3;
            $Graph->kante_einfuegen($1, $2, exists $typen{$3}?$typen{$3}:$3);
        }

        return '';
    } # sub load_dump


    #
    # Neues Toplevel-Fenster zur Texteingabe erzeugen:
    #
    my $tl = $Konfig{mw}->Toplevel();
    $tl->title('Interne Daten');
    $tl->Label(-text   => 'Interne Datenstruktur:',
               #-anchor => 'w',
              )
        ->pack(-anchor => 'w');
    my $txt = $tl->Scrolled("Text",
                        -scrollbars => 'osoe',
                        -background => '#d7d7d7',
                        -foreground => 'blue',
                        -width      => 40,
                        -height     => 25,
                        -relief     => 'flat',
                        -font       => '{Courier New} 10 {normal}',
                        -wrap       => 'none',
                       )
                ->pack();
    $tl->Button(-text    => 'Dump laden',
                -command => sub {clear();
                                 my $rtext = load_dump($txt->get('1.0', 'end'));
                                 if ($rtext eq '') {
                                     $Konfig{dateiname} = '';
                                     $Konfig{statuszeile} = 'Dump erfolgreich eingelesen.';
                                     refresh();
                                     $tl->destroy();
                                 }
                                 else {
                                     print "\a";
                                     $Konfig{statuszeile} = $rtext;
                                 }
                                },
               )
         ->pack(-expand => '1',
                -fill   => 'x',
                -side   => 'left',
               );


    #
    # Rest: grab verhindert das Zurckschalten auf $WM per Klick, focus sorgt
    #       dafr, dass $tl und in diesem $txt auch wirklich aktiv ist:
    #
    $tl->grab();
    $txt->focus();
} # sub dump_eingeben


sub anzeige_fenster ($$$$;$$) {
# -----------------------------------------------------------------------------
# sub          : a n z e i g e _ f e n s t e r
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeigt etwas in einem Extra-Fenster an.
# Parameter    : Notwendig:
#                  1) Titel
#                  2) Label
#                  3) Font
#                  4) anzuzeigender Text
#                Optional:
#                  5) Breite           (default: 80       )
#                  6) Hhe             (default: 35       )
#                  7) Textfarbe        (default: 'blue'   )
#                  8) Hintergrundfarbe (default: '#d7d7d7')
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 18.11.2003 - CD - Erstellt
# 0.0.2 - 20.11.2003 - CD - Bindungen fr PageUp, PageDn, Home und End...
#                           Optionale Parameter fr Breite, Hhe, Textfarbe und
#                           Hintergrundfarbe eingebaut.
# 0.0.3 - 04.12.2003 - CD - Verbesserungen: Button in Extraframe, das vor dem
#                           Textfeld gepackt wird, beim Expanden wird die
#                           Zeile mit dem Schalter nicht mehr vergrert.
# 0.0.4 - 08.02.2004 - CD - In ged.pl kopiert und an %Konfig angepasst.
# -----------------------------------------------------------------------------

    my $titel  = shift;
    my $label  = shift;
    my $font   = shift;
    my $text   = shift;
    my $width  = shift || 80;
    my $height = shift || 35;
    my $tcolor = shift || 'blue';
    my $bcolor = shift || '#d7d7d7';

    print "anzeige_fenster(\n",
          "                Titel : $titel\n",
          "                Label : $label\n",
          "                Font  : $font\n",
          "               )\n"
          if $Konfig{debug};


    # -------------------------------------------------------------------------
    # Neues Toplevel-Fenster erzeugen, das den Text anzeigt:
    # -------------------------------------------------------------------------
    my $tl = $Konfig{mw}->Toplevel();
    $tl->title($titel);
    $tl->Label(-text   => $label,
               #-anchor => 'w',
              )
        ->pack(-anchor => 'w');
    my $fr = $tl->Frame()
                 ->pack(-expand => '0',
                        -fill   => 'x',
                        -side   => 'bottom',
                       );
    my $txt = $tl->Scrolled("Text",
                            -scrollbars => 'osoe',
                            -background => $bcolor,
                            -foreground => $tcolor,
                            -state      => 'disabled',
                            -width      => $width,
                            -height     => $height,
                            -relief     => 'flat',
                            -font       => $font,
                            -wrap       => 'none',
                           )
                     ->pack(-side       => 'top',
                            -expand     => 1,
                            -fill       => 'both',
                           );
    my $ok = $fr->Button(-text        => 'OK',
                         -command     => sub {$tl->destroy();
                                              #$Konfig{mw}
                                              #  ->bind('<Escape>', \&beenden);
                                              $Konfig{mw}->focus();
                                             },
                         -default     => 'active',
                         -padx        => 15,
                        )
                  ->pack(-expand      => '0',
                         -fill        => 'none',
                         -side        => 'right',
                        );

    $txt->configure(-state => 'normal');
    $txt->delete('1.0', 'end');
    $txt->insert('end', $text);
    #$txt->insert('end', "\n");
    $txt->configure(-state => 'disabled');

    #
    # Bindungen zum $MW fr Escape lsen und an Lschen dieses Fensters binden.
    # (Beim Beenden des Fensters wird ESC wieder an $MW gebunden (siehe oben).)
    #
    $tl->bind('<Return>', sub{$ok->invoke()});
    #Konfig{mw}->bind ('<Escape>', '');
    $tl->bind('<Escape>', sub{$ok->invoke()});
    #        *$text*->yviewScroll(*number, what*)
    #            This command adjust the view in the window up or down
    #            according to *number* and *what*. *Number* must be an
    #            integer. *What* must be either units or pages. If *what* is
    #            units, the view adjusts up or down by *number* lines on the
    #            display; if it is pages then the view adjusts by *number*
    #            screenfuls. If *number* is negative then earlier positions
    #            in the text become visible; if it is positive then later
    #            positions in the text become visible.
    $txt->bind('<Prior>', sub { $txt->yviewScroll(-1, 'units') } );
    $txt->bind('<Next>',  sub { $txt->yviewScroll( 1, 'units') } );
    #$txt->bind('<Home>',  sub { $txt->see('1.0') } );
    #$txt->bind('<End>',   sub { $txt->see('end') } );
    $txt->bind('<Home>',  sub { $txt->yviewMoveto(0) } );
    $txt->bind('<End>',   sub { $txt->yviewMoveto(1) } );
    # geht beides, unteres wohl etwas schneller
    $txt->bind('<Left>',  sub { $txt->yviewScroll(-1, 'units') } );
    $txt->bind('<Up>',    sub { $txt->yviewScroll(-1, 'units') } );
    $txt->bind('<Right>', sub { $txt->yviewScroll( 1, 'units') } );
    $txt->bind('<Down>',  sub { $txt->yviewScroll( 1, 'units') } );
    # irgendwas stimmt noch nicht ganz... da mssen eingebaute Funktionalitten
    # mit reinspielen...

    #$txt->bind('<F9>',    sub { $txt->yviewScroll(-1, 'units') } );
    #$txt->bind('<F10>',   sub { $txt->yviewScroll( 1, 'units') } );
    #$txt->bind('<F5>',    sub { $txt->yviewScroll(-1, 'pages') } );
    #$txt->bind('<F6>',    sub { $txt->yviewScroll( 1, 'pages') } );

    #
    # Rest:
    # (grab verhindert das zurckschalten auf $WM per Klick, focus sorgt dafr,
    # dass $tl auch wirklich aktiv ist.)
    #
    $tl->grab();
    $tl->focus();
    $txt->focus(); # ?
} # sub anzeige_fenster


sub zeige_daten_an () {
# -----------------------------------------------------------------------------
# sub          : z e i g e _ d a t e n _ a n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeigt die interne Datenstruktur in einem Fenster an.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 08.02.2004 - CD - anzeige_fenster() zum Anzeigen verwendet.
# 0.0.4 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.5 - 10.02.2004 - CD - Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------
    print "zeige_daten_an\n" if $Konfig{debug};

    #
    # Text zusammensetzen:
    #
    my $text = $Graph->n() . "\n";
    for my $i (0..$Graph->n()-1) {
        $text .= sprintf "%d;%d\n", $Graph->ecke($i)->x(),
                                    $Graph->ekce($i)->y();
    }

    $text .= $Graph->m() . "\n";
    for my $i (0..$Graph->m()-1) {
        $text .= sprintf "%d;%d;%s\n", $Graph->kante($i)->a(),
                                       $Graph->kante($i)->e(),
                                       $Graph->kante($i)->form();
    }


    anzeige_fenster('Interne Daten',
                    'Interne Datenstruktur:',
                    '{Courier New} 10 {normal}',
                    $text,
                   );
} # sub zeige_daten_an


sub hilfe () {
# -----------------------------------------------------------------------------
# sub          : h i l f e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeigt einen Hilfstext an.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2003 - CD - Neues Toplevel-Fenster zur Anzeige spendiert.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.4 - 08.02.2004 - CD - anzeige_fenster() zum Anzeigen verwendet.
# -----------------------------------------------------------------------------

    print "hilfe\n" if $Konfig{debug};

    my $text = <<"HILFETEXT";
     GED   V$Konfig{version} vom $Konfig{version_datum}
     ~~~

...
HILFETEXT

    anzeige_fenster('Hilfe zu GED',
                    'Hilfe:',
                    '{Courier New} 10 {normal}',
                    $text,
                   );
} # sub hilfe


sub graph_erkl () {
# -----------------------------------------------------------------------------
# sub          : g r a p h _ e r k l
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Gibt eine Erklrung zu Graphen aus.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2003 - CD - Neues Toplevel-Fenster zur Anzeige spendiert.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.4 - 08.02.2004 - CD - anzeige_fenster() zum Anzeigen verwendet.
# -----------------------------------------------------------------------------

    print "graph_erkl\n" if $Konfig{debug};

    my $text = <<'GRAPHERKL';
G - E - D ist ein grafischer Editor fr Graphen aus der Graphentheorie.

Graphen bestehen aus einer Menge von Ecken N = {e_1, e_2, ..., e_n} und einer
Menge von Kanten M = {k_1, k_2, ..., k_m}, welche jeweils zwei Ecken
miteinander verbinden.

Die Kanten kann man sich deshalb jeweils als ein Paar von Ecken vorstellen,
wenn die Kante k1 die Ecke e1 mit der Ecke e3 verbindet, kann man schreiben:
k1 = (e1, e3).
GRAPHERKL

    anzeige_fenster('Was sind Graphen?',
                    'Was sind Graphen?',
                    '{Courier New} 10 {normal}',
                    $text,
                   );
} # sub graph_erkl


sub history () {
# -----------------------------------------------------------------------------
# sub          : h i s t o r y
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeigt die History an.

# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 13.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.3 - 08.02.2004 - CD - anzeige_fenster() zum Anzeigen verwendet.
# -----------------------------------------------------------------------------

    print "history\n" if $Konfig{debug};

    #
    # History-Text:
    #
    my $text = <<'HISTORYTEXT';
Version 0.0.1 - 31.01.2003 (6.882 Byte - 195 Zeilen - ged_2003_01_31.pl)
~~~~~~~~~~~~~
Aufbauend auf dem Beispiel "Ein Zeichenprogramm" auf Seite 213/214 im Buch
"Einfhrung in Perl / Tk" von Nancy Walsh entsteht das Grundgerst.

Man kann Kreise setzten (Ecken) und beliebige Striche ziehen.

Funktionen:
    tk_start
    bind_start
    zeichnen_anfang
    aendere_item
    zeichnen_ende


Version 0.0.2 - 03.02.2003 (25.370 Byte - 678 Zeilen - ged_2003_02_03.pl)
~~~~~~~~~~~~~
- Ideensammlung relativ am Anfang der Datei als Kommentare eingefgt.
- $Canvas eingefhrt.
- weitere globale Variablen: $N, $Radius, $Delta, @EckenX, @EckenY, @KantenA,
  @KantenE, @Kantenform, $M, $KantenA, $Kantenform, $Zx, $Zy.
- Clear-Button rechts oben eingefgt.
- Quit- und Refresh-Button eingefgt.
- ESC an Programmende und F5 an refresh gebunden.
- Zeichenanfangsecke ($KantenA) und Kantenform ($Kantenform) merken.
- Eckenkoordinaten beim Zeichnen in den Arrays ablegen und $N hochzhlen.
- Eckenlschen eingebaut.
- Kanten drfen nur noch in der Nhe von Ecken beginnen und enden und rasten
  dann auf diesen ein.

Neue Funktionen:
    ecke_zu_nah
    meint_ecke
    beenden
    r2d
    refresh
    clear
    zeichne_ecke
    zeichne_kante

Version 0.0.3 - 04.02.2003 (29.915 Byte - 800 Zeilen - ged_2003_02_04_a.pl)
~~~~~~~~~~~~~
- Men eingefgt.
- Skalaelement zur Grennderung des Radius der Eckendarstellung eingefgt.
- Nach Eckenlschen hhere Eckennummern korrigiert.
- Ausgabe aus beenden nach save verschoben, in beenden save aufgerufen.
- Debug-Startausgaben mit Funktionsnamen in jede Funktion eingebaut.
- In clear Motion-Bindung aufheben - Zeichenvorgang wird damit unterbrochen.
- Kantenzeichnen korrigiert.

Neue Funktionen:
    save
    ueber_ged (leerer Rumpf)
    neue_datei (leerer Rumpf)
    lade_datei (leerer Rumpf)
    speichere_datei (leerer Rumpf)
    speichere_datei_als (leerer Rumpf)


Version 0.0.4 - 04.02.2003 (48.289 Byte - 1253 Zeilen - ged_2003_02_04_b.pl)
~~~~~~~~~~~~~
- $Debug und $Dateiname als globale Variablen eingefhrt.
- $MW eingefhrt.
- Hilfemen um Graphenerklrung und "ber GED" erweitert.
- Acceleratoren im Men eingebaut (Tastenkrzelanzeige).
- Dummy-Bearbeitenmen und Internamen eingebaut.
- Einige Tastaturbindungen vorgenommen.
- bind_start erhlt jetzt das Canvas nicht mehr als Parameter
- Data::Dumper zu Debug-Zwecken verwendet.
- Einige Ausgaben von $Debug abhngig gemacht.
- beenden ruft nicht mehr save auf.
- clear erhlt jetzt das Canvas nicht mehr als Parameter und setzt die globalen
  Ecken / Kantenarrays auf leere Listen nachdem sie auf undef gesetzt wurden.
- zeichne_ecke bricht jetzt bei falschem Aufruf mit Fehler ab.
- zeichne_kante bricht jetzt bei falschem Aufruf mit Fehler ab.
- save schreibt in eine Datei ($Dateiname) und nicht nur auf den Bildschirm.
- ueber_ged, neue_datei, lade_datei, speichere_datei mit Leben gefllt,
  waren vorher leere Blcke.

Neue Funktionen:
    dump_data
    load
    graph_erkl
    zeige_daten_an
    hilfe
    dump_eingeben (noch ohne Funktionalitt)


Version 0.0.5 - 04.02.2003 (49.134 Byte - 1283 Zeilen - ged_2003_02_04_c.pl)
~~~~~~~~~~~~~
- Cwd zur Ermittlung des Arbeitsverzeichnisses verwendet. (-> $Pfad)
- in load Laden der Eckenzahl korrigiert und das Einlesen der Kanten eingebaut.
- $Pfad per -initialdir in speichere_datei_als verwendet.


Version 0.0.6 - 05.02.2003 (65.573 Byte - 1724 Zeilen - ged_2003_02_05.pl)
~~~~~~~~~~~~~
- $Debug wird als erste Variable definiert.
- Neue Methode "Ecke verschieben 2" (Linientyp).
- Linientyp "Linie" heit jetzt "Kante".
- Neue Methode "Kante lschen" (Linientyp).
- Statuszeilenausgaben an verschiedenen Stellen eingebaut.
- Speichern _unter_ statt Speichern _als_.
- ndern der Radiusgre fr die Eckenkreise fhrt jetzt ein automatisches
  refresh durch, d.h. man sieht die nderung gleich auf dem Bildschirm.
- Methoden zum Ecken verschieben (2 Stck) und Kanten lschen realisiert.
- Schleifen verhindert, d.h. Kanten drfen nur noch zwischen verschiedenen
  Ecken verlaufen.
- meint_ecke durch last beschleunigt.
- Parameter in clear() eingebaut, Bindungen werden nur auf Wunsch wieder
  hergestellt.
- Viele Ausgaben abhngig von $Debug gemacht (verschiedene Level).
- Titelanzeige bei neue_datei und lade_datei gendert.
- Doppelten Aufruf von Save in speichere_datei verhindert.
- -initialdir in speichere_datei_als ausgebaut, wird mit absolutem Pfad
  angegeben und fhrt dann zu Fehlern.
- graph_erkl mit neuem Toplevel-Window versehen.
- Hilfe mit neuem Toplevel-Window versehen.

Neue Funktionen:
    ecke_zu_nah_ohne
    meint_kante (aber noch nicht funktionstchtig...)


Version 0.0.7 - 08.02.2003 (71.673 Byte - 1863 Zeilen - ged_2003_02_08.pl)
~~~~~~~~~~~~~
- Linientyp "Ecke" in "Ecke einfgen" gendert.
- Icon fr GED erzeugt und dieses in tk_start dem MainWindow zugewiesen.
- Arbeitswerkzeugwahl nun ber Editbuttons am oberen Rand und nicht mehr ber
  Radioboxes am rechten Rand.


Version 0.0.8 - 10.02.2003 (88.312 Byte - 2249 Zeilen - ged_2003_02_10.pl)
~~~~~~~~~~~~~
- Linientypennamen gendert.
- Durchgngigen Menufont in allen Menelementen verwendet.
- Editbuttons in drei Gruppen (erzeugen, modifizieren und lschen) aufgeteilt
  und optisch voneinander abgesetzt.
- Tests eingebaut, so dass man keine Kante einfgen kann, wenn nur eine Ecke da
  ist etc.
- Kantenlschen: Kantenzahl runterzhlen und refresh eingebaut.
- Neues Icon auch bei "ber GED" verwendet.
- meint_kante mit der richtigen Funktion befllt.

Neue Funktionen:
    abstand_punkt_linie
    punkt_abstand
    floor
    do_all_the_tests


Version 0.0.9 - 11.02.2003 (95.174 Byte - 2401 Zeilen - ged_2003_02_11.pl)
~~~~~~~~~~~~~
- Gesamtes Mensystem umgestellt nach ausfhrlichem Schmkern in den perldocs
  (menu, ...), dies wurde in obigem Buch nicht vernnftig erklrt, jetzt hat
  das Programm ein richtig "normales" Men, in das man mit Alt-Buchstabe, Alt,
  F10 wechseln und in dem man mit den Cursortasten gewohnt navigieren kann.
- Linientypennamen gendert (Nacharbeiten).
- -initialfile rausgenommen in speichere_datei_als.


Version 0.0.10 - 12.02.2003 (98.898 Byte - 2492 Zeilen - ged_2003_02_12_a.pl)
~~~~~~~~~~~~~~
- Im Men Bearbeiten kann man nun Kreise und vollstndige Graphen einfgen
  (C3, C4, C5, C6, C7, C8, C9, K3, K4, K5, K6, K7).

Neue Funktionen:
    struktur_einfuegen


Version 0.0.11 - 12.02.2003 (107.338 Byte - 2669 Zeilen - ged_2003_02_12_b.pl)
~~~~~~~~~~~~~~
- Funtion todo eingefgt, ToDo-Texte sind als HERE-Dokument in diese Funktion
  gewandert.
- Grob geschtzte Versionsnummer $Version (5) und Datum $Datum eingefgt.
  Version und Datum werden nun bei "ber GED" angezeigt.
- Grafische Elemente (Icons etc.) ins Unterverzeichnis res verschoben.
- Weitere Kn's (K8 bis K13, K20, K30, K40, K50, K99), sowie Cn's (C20, C30,
  C40, C50, C99) sowie das Einfgen des Mittelpunktes in das Bearbeitenmen
  aufgenommen.
- ESC beendet nun nicht mehr das Programm, sondern Ctrl-B. Entsprechend wird
  ESC in den Diversen Funktionen mit eigenen Toplevel-Windows hinterher auch
  nicht wieder an $MW gebunden.
- Fehlermeldung in meint_kante ausgeben, wenn es uneindeutig ist.
- struktur_einfuegen erweitert / verbessert, Koordinatenberechnung ist nun
  richtig. Schleifeninvariante Variablen vor der Schleife deklariert und
  initialisiert.

Neue Funktionen:
    todo


Version 0.0.12 - 13.02.2003 (138.257 Byte - 3395 Zeilen - ged_2003_02_13.pl)
~~~~~~~~~~~~~~
- Speichern im LaTeX-Modus eingebaut
- Speichern im Postscript-Modus eingebaut
- Beim Doppelklick im Laden-Men wird nun dieser nicht mehr im Canvas ausgewer-
  tet, dank tK::after.
- Der ToDo-Text ist wieder an den Dateianfang gewandert, in eine globale
  Variable. (Here-Dokument)
- Diese History angelegt und teilweise rekonstruiert, Versionsnummern
  rckwirkend vergeben / korrigiert.
- Men "Bearbeiten 2" mit kascadierenden Submens als Alternative zu Men
  Bearbeiten eingefgt.
- Men Hilfe ist jetzt wieder rechtsbndig (durch letzten Seperator der
  Menubar!).
- In do_all_tests Zeilen umgebrochen, so dass sie in die ersten 80 Zeichen pro
  Zeile passen.

Neue Funktionen:
    history
    toLaTeX
    export_nach_latex
    export_nach_postscript


Version 0.0.13 vom 17.02.2003
~~~~~~~~~~~~~~
> 136.747 Byte - 3.405 Zeilen -      ged_2003_02_17.pl
>   5.816 Byte -   167 Zeilen - GEDfhist_2003_02_17.pm
> -------         ----
> 142.563 Byte - 3.572 Zeilen

- Verwaltung der zuletzt bearbeiteten Dateien in GEDfhist.pm / ged.pl eingebaut.
- Haupt-Men in globaler Variable $Menu zugnglich gemacht (um die vernderten
  bearbeiteten Dateien ins Men eintragen zu knnen).
  Dito $Menuefont, aber beide nur im Block mit tk_start und add_file_menu.
- Mainteil ans Ende verlegt, sonst sind die Blockvariablen nicht initialisiert.

Neue Funktionen:
    GEDfhist::load
    GEDfhist::save
    GEDfhist::add
    GEDfhist::array
    GEDfhist::min
    GEDfhist::max
    add
    add_file_menu


Version 0.0.14 vom 12.03.2003
~~~~~~~~~~~~~~
> 140.598 Byte - 3.519 Zeilen -      ged_2003_03_12.pl
>   5.816 Byte -   167 Zeilen - GEDfhist_2003_02_17.pm
> -------        -----
> 146.414 Byte - 3.686 Zeilen

- Funktion dump_eingeben mit Leben gefllt.

Neue Funktionen:
    dump_eingeben (war bisher nur ein Rumpf)
    load_dump (local in dump_eingeben)


Version 0.0.15 vom 18.03.2003
~~~~~~~~~~~~~~
> 142.919 Byte - 3.581 Zeilen -      ged_2003_03_18.pl
>   5.816 Byte -   167 Zeilen - GEDfhist_2003_02_17.pm
> -------        -----
> 148.735 Byte - 3.748 Zeilen

- Linientypen werden nun ber ein Hash definiert, das ein Krzel als Schlssel
  und den schnen Langtext als Wert hat. Gespeichert word nur der Schlssel,
  beim Laden werden Werte in Schlssel bertragen, um alte Dateien lesen zu
  knnen.
- Beim schnellen Eckenverschieben wird nun nicht mehr auf berschneidung mit
  der Ausgangsecke getestet.


Version 0.0.16 vom 05.02.2004
~~~~~~~~~~~~~~
> 151.988 Byte - 3.658 Zeilen -      ged_2004_02_05.pl
>   5.816 Byte -   167 Zeilen - GEDfhist_2003_02_17.pm
> -------        -----
> 157.804 Byte - 3.825 Zeilen

- Viele globale Variablen in Hashes %Konfig und %Graph zusammengefasst.


Version 0.0.17 vom 06.02.2004
~~~~~~~~~~~~~~
> 158.920 Byte - 3.840 Zeilen -      ged_2004_02_06.pl
>   5.816 Byte -   167 Zeilen - GEDfhist_2003_02_17.pm
> -------        -----
> 164.736 Byte - 4.007 Zeilen

- Einfgen von groben Kommentarblcken zur Abtrennung der Funktionen in
  Oberflche, Logik und Daten (Dateien), Sortieren der Funktionen.
- Verschieben der Kommentarblcke unter den Anfang der Sub's, damit man ganze
  Funktionen im Editor bersichtlich zusammenfalten kann.
- Es kann optional ein Gitterzetz in variabler Weite eingeblendet werden.
  (Geplant ist das Optionale Einrasten beim Setzen und Verschieben von Ecken
  auf den Ratserpunkten, die Variable und der Menpunkt sind auch schon da,
  die Funktionalitt fehlt aber noch.)

Neue Funktionen:
    tk_beenden


Version 0.0.18 vom 06.02.2004
~~~~~~~~~~~~~~
> 163.121 Byte - 3.982 Zeilen -    ged_2004_02_06_b.pl
>   5.554 Byte -   159 Zeilen - GEDfhist_2004_02_06.pm
> -------        -----
> 168.675 Byte - 4.141 Zeilen

- Einrastfunktion am Gitter eingebaut.
- Alle Funktionen mit Prototypen versehen und diese zu Beginn des Programms
  genannt.

Neue Funktionen:
    rast_ein


Version 0.0.19 vom 06.02.2004
~~~~~~~~~~~~~~
> 167.786 Byte - 4.108 Zeilen -    ged_2004_02_06_c.pl
>   5.554 Byte -   159 Zeilen - GEDfhist_2004_02_06.pm
> -------        -----
> 173.340 Byte - 4.267 Zeilen

- Schnittstelle von load und save gendert, nun muss der Dateiname als Para-
  meter angegeben werden.
- Neues Men "Manipulatoren" mit dem Punkt "In Liniengraphen umwandeln".
- Umwandlung des Graphen in seinen Liniengraphen

Neue Funktionen:
    erzeuge_liniengraphen


Version 0.0.20 vom 06.02.2004
~~~~~~~~~~~~~~
> 179.181 Byte - 4.418 Zeilen -    ged_2004_02_06_d.pl
>   5.554 Byte -   159 Zeilen - GEDfhist_2004_02_06.pm
> -------        -----
> 184.735 Byte - 4.577 Zeilen

- Funktion zur Ermittlung der Canvasgre vorbereitet und in refresh() und
  struktur_einfuegen() eingebaut. Bisher wird aber nur ein fest eingetragenes
  Gren-Quadrupel zurckgegeben.
- Verschiedenen Funktionen rund um Kanten und Ecken hinzugefgt und an anderen
  Stellen aufgerufen. (Verlagerung von Komplexitt).
- Eckenmergen realisiert.
- Todo-Texte aufgerumt.

Neue Funktionen:
    canvas_groesse
    ecke_einfuegen
    ecke_loeschen
    ecke_mergen
    kante_existiert
    kante_einfuegen
    kante_loeschen


Version 0.0.21 vom 07.02.2004
~~~~~~~~~~~~~~
> 182.814 Byte - 4.489 Zeilen -      ged_2004_02_07.pl
>   5.554 Byte -   159 Zeilen - GEDfhist_2004_02_06.pm
> -------        -----
> 188.368 Byte - 4.648 Zeilen

- Geometry zur Grenermittlung in canvas_groesse() verwendet.
- Refresh wird jetzt per Event bei Grennderungen des Fensters aufgerufen,
  so dass das Gitter und auch die eingefgten Graphen an die aktuelle
  Fenstergre angepasst werden.
- Ecken und Kantenfarbe ist nun nicht mehr fest rot/schwarz, sondern
  variabel $Graph{eckenfarbe} bzw. $Graph{kantenfarbe}.
- Ecken- und Kantenfarbe ber Men Ansicht whlbar.
- Waitcursor bei Liniengraphenberechnung eingeschaltet.


Version 0.0.22 vom 08.02.2004
~~~~~~~~~~~~~~
> 179.294 Byte - 4.374 Zeilen -      ged_2004_02_08.pl
>   5.584 Byte -   162 Zeilen - GEDfhist_2004_02_08.pm
> -------        -----
> 184.878 Byte - 4.536 Zeilen

- mit "use Tk::ErrorDialog;" werden jetzt grafische Fehlermeldungen erzeugt.
- anzeige_fenster() zum einfacheren Anzeigen der Daten in zeige_daten_an(),
  hilfe(), graph_erkl(), history() und todo() verwendet.

Neue Funktionen:
    anzeige_fenster


Version 0.0.23 vom 08.02.2004
~~~~~~~~~~~~~~
> 181.451 Byte - 4.425 Zeilen -    ged_2004_02_08_b.pl
>   5.584 Byte -   162 Zeilen - GEDfhist_2004_02_08.pm
> -------        -----
> 187.035 Byte - 4.587 Zeilen

- mit "use Tk::ErrorDialog;" werden jetzt grafische Fehlermeldungen erzeugt.
- anzeige_fenster() zum einfacheren Anzeigen der Daten in zeige_daten_an(),
  hilfe(), graph_erkl(), history() und todo() verwendet.
- Bug der nicht mehr funktionierenden Linienarten auer normal behoben (es
  fehlte ein Komma vor einem weiteren eingefgten Parameter [-fill]
  von createLine() hinter -arrowshape).


Version 0.0.24 vom 09.02.2004
~~~~~~~~~~~~~~
> 156.599 Byte - 3.713 Zeilen -      ged_2004_02_09.pl
>   5.584 Byte -   162 Zeilen - GEDfhist_2004_02_08.pm
>   9.064 Byte -   273 Zeilen -  GEDgeom_2004_02_08.pm
>  21.437 Byte -   528 Zeilen -    Graph_2004_02_09.pm
>  31.765 Byte -   776 Zeilen -  Graph2d_2004_02_09.pm
> -------        -----
> 224.449 Byte - 5.452 Zeilen

- linientyp, startecke, zx und zy sind jetzt nicht mehr in %Graph, sondern in
  %Konfig, da diese Informationen inhaltlich nicht zum Graphen, sondern zum
  Zeichnen desselben whrend des Linienziehens dienen.
- Gitterfarbe jetzt ber %Konfig einstellbar, nicht mehr in der Funktion hart
  verdrahtet.
- Funktionalitt ins neue Modul GEDgeom.pm ausgelagert (abstand_punkt_linie,
  punkt_abstand [und floor]).
- Erstes Bearbeiten Men auskommentiert.
- Menpunkt Ansicht erneuern aus dem Dateimen entfernt (ist auch im
  Ansichtsmen gewesen)
- Neue Klasen Graph und Graph2d, in die viel Funktionalitt ausgelagert wurde.

Ausgelagerte Funktionen (gelscht):
    ecke_zu_nah
    ecke_zu_nah_ohne
    meint_ecke
    meint_kante
    r2d
    ecke_einfuegen
    ecke_loeschen
    ecke_mergen
    kante_existiert
    kante_einfuegen
    kante_loeschen

Ausgelagerte Funktionalitten (entkernt):
    clear
    struktur_einfuegen
    erzeuge_liniengraphen

Neue Funktionen:
    waehle_eckenfarbe
    waehle_kantenfarbe


Funktionen in GEDgeom.pm:
    abstand_punkt_linie
    punkt_abstand
    floor

Methoden in Graph:
    new
    _property
    n
    m
    kantenform
    KantenA
    KantenE
    Kantenform
    ecke_einfuegen
    ecke_loeschen
    ecke_mergen
    kante_existiert
    kante_einfuegen
    kante_loeschen
    clear

Methoden in Graph2d:
    new
    radius
    delta
    eckenfarbe
    kantenfarbe
    EckenX
    EckenY
    ecke_einfuegen
    ecke_loeschen
    ecke_mergen
    clear
    ecke_zu_nah
    ecke_zu_nah_ohne
    meint_ecke
    meint_kante
    r2d
    struktur_einfuegen
    erzeuge_liniengraphen


Version 0.0.25 vom 09.02.2004
~~~~~~~~~~~~~~
> 161.976 Byte - 3.822 Zeilen -     ged_2004_02_09_b.pl
>   5.875 Byte -   177 Zeilen -  GEDfhist_2004_02_09.pm
>   9.358 Byte -   291 Zeilen -   GEDgeom_2004_02_09.pm
>  21.707 Byte -   545 Zeilen -   Graph_2004_02_09_b.pm
>  32.073 Byte -   795 Zeilen - Graph2d_2004_02_09_b.pm
> -------        -----
> 230.989 Byte - 5.630 Zeilen

- Bug beseitigt der Auftrat, wenn man im Gitterraster einrasten mchte ohne
  es anzuzeigen.
- Eckenradiuseinstellung von der Oberflche ins Men verlagert (abreibar)
- Gitterweitenmen abreibar gemacht
- Fehler behoben: Wurde im Farbwahlmen ESC gedrckt, so kommt keine Farbe
  zurck und die dargestellten Dinge (Ecken bzw. Kanten) verschwanden.
- POD angefangen mit Titel und Copyright, um die Sourcen zum Download anbieten
  zu knnen. (Sie sind damit unter der Doppellizenz GPL / artistic, siehe
  perldoc perlgpl bzw. perldoc perlartistic.)


Version 0.0.26 vom 10.02.2004
~~~~~~~~~~~~~~
> 163.838 Byte - 3.884 Zeilen -      ged_2004_02_10.pl
>   5.875 Byte -   177 Zeilen - GEDfhist_2004_02_09.pm
>   9.358 Byte -   291 Zeilen -  GEDgeom_2004_02_09.pm
>  25.986 Byte -   676 Zeilen -    Graph_2004_02_10.pm
>  37.248 Byte -   941 Zeilen -  Graph2d_2004_02_10.pm
>   7.283 Byte -   173 Zeilen -     Ecke_2004_02_10.pm
>   8.403 Byte -   199 Zeilen -    Kante_2004_02_10.pm
> -------        -----
> 257.991 Byte - 6.343 Zeilen

- Klassen fr Ecken und Kanten eingefhrt und die Graphenklassen um Hilfs-
  funktionen erweitert, so dass die interne Datenstruktur vor ged.pl total
  gekapselt ist.

Neue Methoden in Graph:
    _kanten
    setze_kanten
    loesche_kanten
    kante
    entnehme_kante
    fuege_kante_hinzu

Neue Methoden in Graph2d:
    _ecken
    setze_ecken
    loesche_ecken
    ecke
    entnehme_ecke
    fuege_ecke_hinzu

Methoden in Ecke.pm:
    _property
    x
    y

Methoden in Kante.pm:
    _property
    a
    e
    form
    inzidiert_mit_ecke

Version 0.0.27 vom 10.02.2004
~~~~~~~~~~~~~~
> 164.922 Byte - 3.905 Zeilen -     ged_2004_02_10_b.pl
>   5.884 Byte -   177 Zeilen -     FHist_2004_02_10.pm
>   9.367 Byte -   291 Zeilen -      Geom_2004_02_10.pm
>  26.238 Byte -   676 Zeilen -   Graph_2004_02_10_b.pm
>  37.453 Byte -   941 Zeilen - Graph2d_2004_02_10_b.pm
>   7.295 Byte -   173 Zeilen -    Ecke_2004_02_10_b.pm
>   8.417 Byte -   199 Zeilen -   Kante_2004_02_10_b.pm
> -------        -----
> 259.576 Byte - 6.363 Zeilen

- Alle Module in den Namensraum Graph::GED:: verschoben.
- Tippfehler bei Load "for," statt "form" verbessert.
HISTORYTEXT


    anzeige_fenster('History',
                    'History:',
                    '{Courier New} 10 {normal}',

                    $text,
                   );
} # sub history


sub todo () {
# -----------------------------------------------------------------------------
# sub          : t o d o
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : ToDo-Text anzeigen
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 12.02.2003 - CD - Erstellt
# 0.0.2 - 13.02.2003 - CD - Text in globale Variable verschoben, damit die
#                           ToDo-Liste wieder am Anfang dieser Datei steht.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.4 - 08.02.2004 - CD - anzeige_fenster() zum Anzeigen verwendet.
# -----------------------------------------------------------------------------

    print "todo\n" if $Konfig{debug};

    anzeige_fenster('Ideen',
                    'Ideen:',
                    '{Courier New} 10 {normal}',
                    $Todotext,
                   );
} # sub todo


sub ueber_ged () {
# -----------------------------------------------------------------------------
# sub          : u e b e r _ g e d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Zeigt etwas Informationen ber GED an.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 10.02.2003 - CD - GED-Icon verwendet
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.4 - 09.02.2004 - CD - Hinweis auf die Webseite eingebaut.
# -----------------------------------------------------------------------------

    print "ueber_ged\n" if $Konfig{debug};

    my $icon = $Konfig{mw}->Photo(-file   => 'res/ged.bmp',
                          -height => 32,
                          -width  => 32,
                         );
    my $dialog = $Konfig{mw}->Dialog(-text           => <<'HERE2' . "Version $Konfig{version} / $Konfig{version_datum}",
G - E - D ist ein grafischer Editor fr Graphen aus der Graphentheorie.

GED bietet die Mglichkeit, Ecken und Kanten leicht mit der Maus auf der
Arbeitsflche zu positionieren und erlaubt es, den entstandenen Graphen in
unterschiedlichen Formaten abzuspeichern.

Autor: Christian Dhl (e.mail: christian@duehl.de)

Webseite: http://www.duehl.de/christian/perl/ged.html

HERE2
                                #-bitmap         => 'info',
                                 -image          => $icon,
                                 -title          => 'ber G-E-D',
                                 -default_button => 'OK',
                                 -buttons        => [ 'OK' ],
                                #-font           => '{Courier New} 10 {normal}',
                                 -font           => '{Times New Roman} 12 {normal}',
                                );
    $dialog->Show(-global);
} # sub ueber_ged


sub canvas_groesse () {
# -----------------------------------------------------------------------------
# sub          : c a n v a s _ g r o e s s e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Ermittelt die Koordinaten des sichtbaren Bereiches der
#                Zeichenflche.
# Parameter    : keine
# Rckgabewert : (xmin, ymin, xmax, ymax)
# -----------------------------------------------------------------------------
# 0.0.1 - 06.02.2004 - CD - Erstellt
# 0.0.2 - 07.02.2004 - CD - Geometry zur Grenermittlung verwendet.
# -----------------------------------------------------------------------------

    print "canvas_groesse\n" if $Konfig{debug};


    #my ($x, $y, $w, $h) = $Konfig{canvas}->bbox("all");
    #print "x=$x y=$y w=$w h=$h\n";
    #use Data::Dumper;
    #print Dumper($Konfig{canvas}->bbox("all")), "\n";

    my $geom           = $Konfig{canvas}->geometry();
    my ($wh, $px, $py) = split /\+/, $geom;
    my ($xx, $yy)      = split /x/, $wh;
    print "$geom ($xx x $yy + $px + $py)\n" if $Konfig{debug};


    return (0, 0, $xx, $yy);   #(0,0, 486, 430);
} # sub canvas_groesse


sub waehle_eckenfarbe () {
# -----------------------------------------------------------------------------
# sub          : w a e h l e _ e c k e n f a r b e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Whlt die Eckenfarbe per Dialog.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 09.02.2004 - CD - Erstellt
# -----------------------------------------------------------------------------

    my $farbe = $Konfig{mw}->chooseColor(-title        => 'Eckenfarbe whlen',
                                         -initialcolor => $Graph->eckenfarbe(),
                                        );
    $Graph->eckenfarbe($farbe) if $farbe;
    refresh();
} # sub waehle_eckenfarbe


sub waehle_kantenfarbe () {
# -----------------------------------------------------------------------------
# sub          : w a e h l e _ k a n t e n f a r b e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Whlt die Kantenfarbe per Dialog.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 09.02.2004 - CD - Erstellt
# -----------------------------------------------------------------------------

    my $farbe = $Konfig{mw}->chooseColor(-title        => 'Kantenfarbe whlen',
                                         -initialcolor => $Graph->kantenfarbe(),
                                        );
    $Graph->kantenfarbe($farbe) if $farbe;
    refresh();
} # sub waehle_kantenfarbe


sub tk_beenden () { $Konfig{mw}->destroy() }


###############################################################################
###############################################################################
####                                                                       ####
####              L        OOO     GGG      I     K   K                    ####
####              L       O   O   G         I     K  K                     ####
####              L       O   O   G  GG     I     KKK                      ####
####              L       O   O   G   G     I     K  K                     ####
####              LLLLL    OOO     GGG      I     K   K                    ####
####                                                                       ####
###############################################################################
###############################################################################



sub beenden () {
# -----------------------------------------------------------------------------
# sub          : b e e n d e n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Wird zum Ende des Programms aufgerufen.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 14.02.2003 - CD - History wird gespeichert.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.4 - 06.02.2004 - CD - Statt exit wird tk_beenden aufgerufen.
# 0.0.5 - 10.02.2004 - CD - Module in Namensraum Graph::GED:: verschoben.
# -----------------------------------------------------------------------------

    print "beenden\n" if $Konfig{debug};
    dump_data() if $Konfig{debug};

    Graph::GED::FHist::save();

    tk_beenden();
} # sub beenden


sub struktur_einfuegen ($) {
# -----------------------------------------------------------------------------
# sub          : s t r u k t u r _ e i n f u e g e n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Fgt Kreise / Vollstndige Graphen ein
# Parameter    : Strukturkennung, beginnt mt C ode K gefolgt von einer
#                natrlichen Zahl > 2.
#                Oder 'M' fr den Mittelpunkt.
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 09.02.2004 - CD - Funktionalitt in die Klasse Graph2d ausgelagert.
# -----------------------------------------------------------------------------

    $Graph->struktur_einfuegen(@_);
    refresh();
} # sub struktur_einfuegen


sub raste_ein ($$) {
# -----------------------------------------------------------------------------
# sub          : r a s t e _ e i n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Rastet ein Koordinatenpaar auf den nchsten Gitterlinien-
#                kreuzungspunkt ein.
# Parameter    : 1) X-Koordinate
#                2) Y-Koordinate
# Rckgabewert : (x-Koordinate, y-Koordinate)
# -----------------------------------------------------------------------------
# 0.0.1 - 06.02.2004 - CD - Erstellt
# -----------------------------------------------------------------------------

    my $x = shift;
    my $y = shift;

    print "x=$x, X:@GitterX\n",
          "y=$y, Y:@GitterY\n"
          if $Konfig{debug} > 1;

    # X-Koordinate bearbeiten:
    my $xindex = 0;
    my $xminab = abs($x-$GitterX[0]);
    for (1..$#GitterX) {
        if ($xminab > abs($x-$GitterX[$_])) {
            $xminab = abs($x-$GitterX[$_]);
            $xindex = $_;
        }
    }
    print "naechster Wert zu $x ist Index $xindex ($GitterX[$xindex])\n"
          if $Konfig{debug} > 1;

    # Y-Koordinate bearbeiten:
    my $yindex = 0;
    my $yminab = abs($y-$GitterY[0]);
    for (1..$#GitterY) {
        if ($yminab > abs($y-$GitterY[$_])) {
            $yminab = abs($y-$GitterY[$_]);
            $yindex = $_;
        }
    }
    print "naechster Wert zu $y ist Index $yindex ($GitterY[$yindex])\n"
          if $Konfig{debug} > 1;


    return ($GitterX[$xindex], $GitterY[$yindex]);
} # sub raste_ein


sub erzeuge_liniengraphen () {
# -----------------------------------------------------------------------------
# sub          : e r z e u g e _ l i n i e n g r a p h e n
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Erzeugt aus dem gegebenen Graphen seinen Liniengraphen.
# Parameter    : keine
# Rckgabewert : keiner (ein neuer Graph wird erzeugt)
# -----------------------------------------------------------------------------
# 0.0.1 - 06.02.2004 - CD - Erstellt
# 0.0.2 - 07.02.2004 - CD - Waitcursor anzeigen whrend Berechnung und refresh.
# 0.0.3 - 08.02.2004 - CD - eigentliche Funktionalitt in Klasse Graph2d aus-
#                           gelagert.
# -----------------------------------------------------------------------------

    print "erzeuge_liniengraphen\n" if $Konfig{debug};


    $Konfig{mw}->Busy();

    #----------------------------------------------------------------------
    # Eigentlichen Liniengraphen erzeugen:
    #----------------------------------------------------------------------
    $Graph->erzeuge_liniengraphen();

    #----------------------------------------------------------------------
    # Weitere Eigenschaften zurcksetzen:
    #----------------------------------------------------------------------
    $Graph->kantenform('k_ins');
    $Konfig{startecke}  = -1;
    $Konfig{zx}         = 0;
    $Konfig{zy}         = 0;

    refresh();

    $Konfig{mw}->Unbusy();
} # sub erzeuge_liniengraphen


sub do_all_the_tests () {
# -----------------------------------------------------------------------------
# sub          : d o _ a l l _ t h e _ t e s t s
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Testet alles mgliche und hlt dann an.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 10.02.2003 - CD - Erstellt
# 0.0.2 - 13.02.2003 - CD - Tests umgebrochen, so dass alles in die ersten 80
#                           Zeichen passt...
# 0.0.3 - 10.02.2004 - CD - Module in Namensraum Graph::GED:: verschoben.
# -----------------------------------------------------------------------------

    #
    # floor
    #
    print "floor($_)=", floor($_), "\n" for (1.4,566.2,0,-24,-55.1);

    #
    # punkt_abstand
    #
    my ($x1, $y1, $x2, $y2);
    $x1=0;  $y1=0;  $x2=10; $y2=0;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=10; $y1=0;  $x2=0;  $y2=0;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=0;  $y2=10; print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=10; $x2=0;  $y2=0;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";

    $x1=1;  $y1=0;  $x2=10; $y2=0;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=1;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=2;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=3;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=4;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=5;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=6;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=7;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=8;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=9;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";
    $x1=0;  $y1=0;  $x2=10; $y2=10; print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";

    $x1=2;  $y1=2;  $x2=3;  $y2=3;  print "Abstand ($x1,$y1)-($x2,$y2) = ",
                        Graph::GED::Geom::punkt_abstand($x1,$y1,$x2,$y2), "\n";

    #
    # abstand_punkt_linie
    #
    my ($x, $y, $ax, $ay, $bx, $by);

    $x=1; $y=1; $ax=0; $ay=0; $bx=2; $by=2;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    $x=2; $y=2; $ax=0; $ay=0; $bx=6; $by=6;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    # Murks, da es nur fr ganze Zahlen geht:
    #$x=2.432; $y=2.432; $ax=0; $ay=0; $bx=6; $by=6;
    #print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
    #      Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    $x=2432; $y=2432; $ax=0; $ay=0; $bx=6000; $by=6000;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    $x=-1; $y=-1; $ax=0; $ay=0; $bx=-2; $by=-2;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";
    $x=-2; $y=-2; $ax=0; $ay=0; $bx=-6; $by=-6;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    $x=-1; $y=-1; $ax=-2; $ay=-2; $bx=0; $by=0;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";
    $x=-2; $y=-2; $ax=-6; $ay=-6; $bx=0; $by=0;
    print "Abstand ($x,$y) von ($ax,$ay)---($bx,$by) ist ",
          Graph::GED::Geom::abstand_punkt_linie($x,$y, $ax,$ay, $bx,$by), "\n\n";

    exit;
} # sub do_all_the_tests



###############################################################################
###############################################################################
####                                                                       ####
####              DDDD      A     TTTTT   EEEEE   N   N                    ####
####              D   D    A A      T     E       NN  N                    ####
####              D   D   AAAAA     T     EEEE    N N N                    ####
####              D   D   A   A     T     E       N  NN                    ####
####              DDDD    A   A     T     EEEEE   N   N                    ####
####                                                                       ####
###############################################################################
###############################################################################



sub dump_data () {
# -----------------------------------------------------------------------------
# sub          : d u m p _ d a t a
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Gibt die internen Daten auf dem Bildschirm aus.
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 03.02.2003 - CD - Erstellt
# 0.0.2 - 03.02.2003 - CD - In dump_data umbenannt.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.4 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.5 - 10.02.2004 - CD - Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    print "dump_data\n" if $Konfig{debug};

    print $Graph->n(), "\n";
    for my $i (0..$Graph->n-1) {
        print $Graph->ecke($i)->x(), ";",
              $Graph->ecke($i)->y(), "\n";
    }

    print $Graph->m(), "\n";
    for my $i (0..$Graph->m()-1) {
        print $Graph->kante($i)->a(), ";",
              $Graph->kante($i)->e(), ";",
              $Graph->kante($i)->form(), "\n";
    }
} # sub dump_data


sub save ($) {
# -----------------------------------------------------------------------------
# sub          : s a v e
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Interne Speicherroutine.
# Parameter    : Dateiname
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt.
# 0.0.2 - 14.02.2003 - CD - Dateiname der History zugefgt.
# 0.0.3 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.4 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.5 - 10.02.2004 - CD - Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $dateiname = shift;

    print "save, Name = '$dateiname' <--------\n" if $Konfig{debug};


    open (OUT, ">$dateiname") or
        die "Kann '$dateiname' nicht zum Schreiben ffnen: $!";

    print OUT <<'HERE';
# Anzahl Ecken
# x-Koordinate der ersten Ecke;y-Koordinate der ersten Ecke
# x-Koordinate der zweiten Ecke;y-Koordinate der zweiten Ecke
# ...
# x-Koordinate der letzten Ecke;y-Koordinate der letzten Ecke
# Anzahl Kanten
# Anfangsecke der ersten Kante;Endecke der ersten Kante;Form der ertsen Kante
# Anfangsecke der zweiten Kante;Endecke der zweiten Kante;Form der zweiten Kante
# ...
# Anfangsecke der letzten Kante;Endecke der letzten Kante;Form der letzten Kante
HERE
    print OUT $Graph->n(), "\n";
    for my $i (0..$Graph->n-1) {
        print OUT $Graph->ecke($i)->x(), ";",
                  $Graph->ecke($i)->y(), "\n";
    }

    print OUT $Graph->m(), "\n";
    for my $i (0..$Graph->m()-1) {
        print OUT $Graph->kante($i)->a(),    ";",
                  $Graph->kante($i)->e(),    ";",
                  $Graph->kante($i)->form(), "\n";
    }

    close OUT or die "Kann '$dateiname' nicht schlieen: $!";

    $Konfig{statuszeile} = "Datei '$dateiname' gespeichert.";
    add($dateiname);
} # sub save


sub load ($) {
# -----------------------------------------------------------------------------
# sub          : l o a d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Interne Laderoutine.
# Parameter    : Dateiname
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 17.02.2003 - CD - Dateinamen in History gespeichert.
# 0.0.3 - 18.03.2003 - CD - Neue Linientypenkrzel verwendet. Dafr werden
#                           beim Laden die ausfhrlichen Formen in die kurzen
#                           bersetzt, um alte Dateien richtig laden zu knnen.
# 0.0.4 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.5 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# -----------------------------------------------------------------------------

    my $dateiname = shift;

    print "load ($dateiname)\n" if $Konfig{debug};

    $Graph->clear();

    open (IN, "<$dateiname") or
        die "Kann '$dateiname' nicht zum Lesen ffnen: $!";

    my $hx = 0;
    my $hy = 0;
    my $he = 0;
    my $ha = 0;
    my $hf = 0;

    my $l = '';

    my %typen;

    # Linientypenhash aufbauen:
    for (keys %Linientypen) {
        $typen{$Linientypen{$_}} = $_;
    }

    # Kommentarkopf berlesen:
    do {
        $l = <IN>;
    } while '#' eq substr $l, 0, 1;

    # Eckenzahl einlesen:
    #$l = <IN>;
    die "Fehler in '$dateiname' - N fehlt!" unless defined $l;
    chomp $l;
    (my $n) = $l =~ /^(\d+)$/;
    die "Fehler in '$dateiname' - N fehlt!" unless defined $1;

    # Eckenkoordinaten einlesen:
    for (0..$n-1) {
        $l = <IN>;
        die "Fehler in '$dateiname' - Eckenkoordinate fehlt!" unless defined $l;
        chomp $l;
        $l =~ /^(\d+);(\d+)$/;
        die "Fehler in '$dateiname' - Eckenkoordinate fehlt!"
            unless defined $1 and defined $2;
        $Graph->ecke_einfuegen($1, $2);
    }


    # Kantenzahl einlesen:
    $l = <IN>;
    die "Fehler in '$dateiname' - M fehlt!" unless defined $l;
    chomp $l;
    (my $m) = $l =~ /^(\d+)$/;
    die "Fehler in '$dateiname' - M fehlt!" unless defined $1;

    # Eckenkoordinaten einlesen:
    for (0..$m-1) {
        $l = <IN>;
        die "Fehler in '$dateiname' - Kantendaten fehlen!" unless defined $l;
        chomp $l;
        $l =~ /^(\d+);(\d+);(.*)$/;
        die "Fehler in '$dateiname' - Kantendaten fehlen!"
            unless defined $1 and defined $2 and defined $3;
        $Graph->kante_einfuegen($1, $2, exists $typen{$3}?$typen{$3}:$3);
    }

    close IN or die "Kann '$dateiname' nicht schlieen: $!";

    $Konfig{statuszeile} = "Datei '$dateiname' geladen.";

    add($dateiname);
} # sub load


sub neue_datei () {
# -----------------------------------------------------------------------------
# sub          : n e u e _ d a t e i
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Lscht alles. Eventuell wird hier mal mehr gemacht, als nur
#                clear aufzurufen, wenn man sich noch Dateinamen merkt o.a..
# Parameter    : keine
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 04.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# -----------------------------------------------------------------------------

    print "neue_datei\n" if $Konfig{debug};
    clear();
    $Konfig{dateiname} = '';
    $Konfig{mw}->title('G - E - D   ' . $Konfig{version});
} # sub neue_datei


sub toLaTeX ($;$$$) {
# -----------------------------------------------------------------------------
# sub          : t o L a T e X
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Gibt den Graphen in Form einer LaTeX-Datei aus.
# Parameter    : dname      - Der Dateiname. Und optional:
#                faktor     - Mastabsvergrerung oder - verkleinerung.
#                xmax, ymax - Bestimmen zusammen mit dem Faktor die Gre (bei
#                             -1 werden diese Gren automatisch berechnet).
#                Es muss der Name angegeben werden, die anderen Parameter
#                knnen weggelassen werden, dann werden sie mit 1 bzw. -1 ini-
#                tialisiert.
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 13.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
#                           Umstellung vieler globaler Variablen auf %Graph.
# 0.0.3 - 09.02.2004 - CD - Umstellungen auf die Verwendung von Graph2d.
# 0.0.4 - 10.02.2004 - CD - Umstellung auf die Kantenklasse.
#                           Umstellung auf die Eckenklasse.
# -----------------------------------------------------------------------------

    my $dname  = shift;
    my $faktor = shift;
    my $xmax   = shift;
    my $ymax   = shift;


    die "toLaTeX ohne Dateinamen aufgerufen" unless defined $dname;
    $faktor =  1                             unless defined $faktor;
    $xmax   = -1                             unless defined $xmax;
    $ymax   = -1                             unless defined $ymax;

    # -------------------------------------------------------------------------
    # xmax und ymax berechnen, falls gewnscht:
    # -------------------------------------------------------------------------
    if ($xmax == -1) {
        for my $i (0..$Graph->n()-1) {
            $xmax = $Graph->ecke($i)->x() if $xmax < $Graph->ecke($i)->x();
        }
    }
    if ($ymax == -1) {
        for my $i (0..$Graph->n()-1) {
            $ymax = $Graph->ecke($i)->y() if $ymax < $Graph->ecke($i)->y();
        }
    }
    # Eventuell xmin, ymin berechnen, von allen Werten diese subtrahieren!
    # Aber nur bei Automatikberechnung!

    # -------------------------------------------------------------------------
    # Ankndigung der folgenden Aktion:
    # -------------------------------------------------------------------------
    print "Speichere Graphen als LaTeXfile $dname ...\n" if $Konfig{debug};

    # -------------------------------------------------------------------------
    # Eigentliches Speichern:
    # -------------------------------------------------------------------------
    open(LOUT, ">$dname") or
        die "Kann Datei '$dname' nicht zum Schreiben ffnen: $!";

    print LOUT "%% Dies ist eine von GED automatisch erzeugte Datei!\n",
               "%% Graph: $dname\n",
               "\\unitlength 1.00mm\n",
               "\\begin{picture}(", $xmax*$faktor, ',', $ymax*$faktor, ")\n";

    # Ecken ausgeben:
    for my $i (0..$Graph->n()-1) {
        my $x = $Graph->ecke($i)->x() * $faktor;
        my $y = $Graph->ecke($i)->y() * $faktor;
        my $n = 'Bezeichnung'; # $Graph->EckenName()->[$i] spter vielleicht ...

        # Ecke:
        print LOUT "    \\put(", $x, ',', $y, "){\\circle*{1.5}}\n";          #"

        # Eckennamen:
        print LOUT "    \\put(", (1.0 + $x), ',', ($y - 2.5), ")",
                   "{\\makebox(0,0)[lb]{{\\small ", $n, "}}}\n";
    }

    # Kanten ausgeben:
    for my $i (0..$Graph->m()-1) {
        my $x1 = $Graph->ecke($Graph->kante($i)->a())->x() * $faktor;
        my $y1 = $Graph->ecke($Graph->kante($i)->a())->y() * $faktor;
        my $x2 = $Graph->ecke($Graph->kante($i)->e())->x() * $faktor;
        my $y2 = $Graph->ecke($Graph->kante($i)->e())->y() * $faktor;

        my $dx   = $x2 - $x1;
        my $dy   = $y2 - $y1;
        my $dist = sqrt($dx*$dx + $dy*$dy);
        my $wdh = int(5 * $dist);

        $dx = $dx / $wdh;
        $dy = $dy / $wdh;

        print LOUT "    \\multiput(", $x1, ",", $y1, ")(", $dx, ",", $dy, ")",
                   "{", $wdh, "}{\\circle*{0.1}}\n";
    }

    print LOUT "\\end{picture}\n";

    close LOUT or die "Kann Datei '$dname' nicht schlieen: $!";
} # sub toLaTeX


sub add ($) {
# -----------------------------------------------------------------------------
# sub          : a d d
# -----------------------------------------------------------------------------
# Autor        : CD
# Aufgabe      : Fgt den Dateinamen in die Liste ein und aktualisiert das
#                Men.
# Parameter    : Dateiname
# Rckgabewert : keiner
# -----------------------------------------------------------------------------
# 0.0.1 - 17.02.2003 - CD - Erstellt
# 0.0.2 - 05.02.2004 - CD - Umstellung vieler globaler Variablen auf %Konfig.
# 0.0.3 - 10.02.2004 - CD - Module in Namensraum Graph::GED:: verschoben.
# -----------------------------------------------------------------------------

    my $dateiname = shift;

    Graph::GED::FHist::add($dateiname);
    add_file_menu();
} # sub add

__END__

=head1 NAME

ged.pl - a graph editor with a Perl/Tk gui

=head1 COPYRIGHT


Copyright 2004 Christian Duehl. All rights reserved.

This program is free software. You can redistribute it and/or
modify it under the same terms as perl itself.

=cut


