/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderedNonOverwritingMap<K, V> {
    private final Map<K, V> valuesByKeys = new HashMap();
    private final List<K> orderedKeys = new ArrayList<K>();

    public void put(K k, V v) {
        this.checkAddKeyValuePairConstraints(k, v);
        this.putUnchecked(k, v);
    }

    private void checkAddKeyValuePairConstraints(K k, V v) {
        if (null == k) {
            throw new IllegalArgumentException("Der Schl\u00fcssel darf nicht null sein!");
        }
        if (null == v) {
            throw new IllegalArgumentException("Der Wert darf nicht null sein!");
        }
        if (this.containsKey(k)) {
            throw new IllegalArgumentException("Der Schl\u00fcssel '" + k + "' ist bereits vorhanden!");
        }
    }

    private void putUnchecked(K k, V v) {
        this.valuesByKeys.put(k, v);
        this.orderedKeys.add(k);
    }

    public int size() {
        return this.valuesByKeys.size();
    }

    public boolean containsKey(K k) {
        return this.valuesByKeys.containsKey(k);
    }

    public V get(K k) {
        if (!this.containsKey(k)) {
            throw new IllegalArgumentException("Kein Eintrag zum Schl\u00fcssel '" + k + "' gefunden!");
        }
        return this.valuesByKeys.get(k);
    }

    public Set<K> keySet() {
        return this.valuesByKeys.keySet();
    }

    public List<K> getOrderedKeys() {
        return this.orderedKeys;
    }

    public boolean isEmpty() {
        return this.orderedKeys.isEmpty();
    }

    public boolean containsValue(V v) {
        return this.valuesByKeys.containsValue(v);
    }

    public void clear() {
        this.valuesByKeys.clear();
        this.orderedKeys.clear();
    }

    public void addOrderedNonOverwritingMap(OrderedNonOverwritingMap<K, V> orderedNonOverwritingMap) {
        for (K k : orderedNonOverwritingMap.getOrderedKeys()) {
            if (this.containsKey(k)) {
                throw new IllegalArgumentException("Die Antwort hat bereits ein Feld mit dem Schl\u00fcssel '" + k + "'.");
            }
            this.putUnchecked(k, orderedNonOverwritingMap.get(k));
        }
    }

    public String toString() {
        return this.toString("OrderedNonOverwritingMap");
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " [");
        boolean bl = true;
        for (K k : this.getOrderedKeys()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            V v = this.get(k);
            stringBuilder.append(k).append("=").append(v);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void removeOldestEntry() {
        if (!this.isEmpty()) {
            K k = this.orderedKeys.get(0);
            this.orderedKeys.remove(k);
            this.valuesByKeys.remove(k);
        }
    }
}

