/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.date.DateCalculations;
import de.duehl.basics.datetime.date.Weekday;
import de.duehl.basics.regex.RegexHelper;
import de.duehl.basics.text.xml.own.OwnXmlHelper;
import de.duehl.basics.text.xml.own.XmlStorable;
import java.util.Date;
import java.util.List;

public class ImmutualDate
implements Comparable<ImmutualDate>,
XmlStorable {
    public static final String XML_IMMUTUAL_DATE_TAG = "immutual-date";
    public static final List<String> GERMAN_MONTH_NAMES = CollectionsHelper.buildListFrom("Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember");
    public static final String GERMAN_MONTH_NAMES_REGEX = RegexHelper.buildOrRegexFromList(GERMAN_MONTH_NAMES);
    public static final String YEAR_REGEX = "\\d{4}";
    public static final String DATE_REGEX = "\\d{1,2}\\.\\d{1,2}\\.\\d{4}";
    public static final String COMPLICATED_DATE_REGEX = "(\\d{2}\\.\\d{2}\\.) ?(?:/|und) ?\\d{2}\\.\\d{2}\\.(\\d{4})";
    public static final String DATE_WITH_GERMAN_MONTH_NAMES_WITHOUT_DAY_REGEX = GERMAN_MONTH_NAMES_REGEX + " \\d{4}";
    public static final String DATE_WITH_GERMAN_MONTH_NAMES_REGEX = "\\d{1,2}\\. " + DATE_WITH_GERMAN_MONTH_NAMES_WITHOUT_DAY_REGEX;
    public static final String ANY_FULL_DATE_REGEX = "(?:(\\d{2}\\.\\d{2}\\.) ?(?:/|und) ?\\d{2}\\.\\d{2}\\.(\\d{4})|\\d{1,2}\\.\\d{1,2}\\.\\d{4}|" + DATE_WITH_GERMAN_MONTH_NAMES_REGEX + ")";
    public static final String ANY_DATE_REGEX = "(?:(\\d{2}\\.\\d{2}\\.) ?(?:/|und) ?\\d{2}\\.\\d{2}\\.(\\d{4})|\\d{1,2}\\.\\d{1,2}\\.\\d{4}|" + DATE_WITH_GERMAN_MONTH_NAMES_REGEX + "|" + DATE_WITH_GERMAN_MONTH_NAMES_WITHOUT_DAY_REGEX + "|\\d{4})";
    private final int day;
    private final int month;
    private final int year;

    public ImmutualDate(int n, int n2, int n3) {
        this.day = n;
        this.month = n2;
        this.year = n3;
    }

    public ImmutualDate(String string) {
        this(DateCalculations.parseDate(string));
    }

    public ImmutualDate() {
        this(DateCalculations.parseDate(new Date().toString()));
    }

    private ImmutualDate(ImmutualDate immutualDate) {
        this.day = immutualDate.day;
        this.month = immutualDate.month;
        this.year = immutualDate.year;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isValid() {
        if (this.year < 1000 || this.year > 9999) {
            return false;
        }
        if (this.month < 1 || this.month > 12) {
            return false;
        }
        return this.day >= 1 && this.day <= DateCalculations.monthDays(this.month, this.year);
    }

    public boolean isValidWithYearZero() {
        if (this.year < 0 || this.year > 9999) {
            return false;
        }
        if (this.month < 1 || this.month > 12) {
            return false;
        }
        return this.day >= 1 && this.day <= DateCalculations.monthDays(this.month, this.year);
    }

    public boolean isLeapYear() {
        return ImmutualDate.isLeapYear(this.year);
    }

    private static boolean isLeapYear(int n) {
        return DateCalculations.isLeapYear(n);
    }

    public int difference(ImmutualDate immutualDate) {
        return this.calculateDayDifference(immutualDate);
    }

    int calculateDayDifference(ImmutualDate immutualDate) {
        int n;
        int n2 = this.getDay();
        int n3 = immutualDate.getDay();
        int n4 = this.getMonth();
        int n5 = this.getYear();
        int n6 = immutualDate.getYear();
        int n7 = 0;
        n7 = n2 - n3;
        n2 = n3;
        for (n = immutualDate.getMonth(); n4 > n; ++n) {
            n7 += DateCalculations.monthDays(n, n6);
        }
        while (n4 < n) {
            n7 -= DateCalculations.monthDays(n4, n5);
            ++n4;
        }
        while (n5 > n6) {
            n7 = ImmutualDate.isLeapYear(n6) && n4 < 3 || ImmutualDate.isLeapYear(n6 + 1) && n4 >= 3 ? (n7 += 366) : (n7 += 365);
            ++n6;
        }
        while (n5 < n6) {
            n7 = ImmutualDate.isLeapYear(n5) && n4 < 3 || ImmutualDate.isLeapYear(n5 + 1) && n4 >= 3 ? (n7 -= 366) : (n7 -= 365);
            ++n5;
        }
        return -n7;
    }

    public ImmutualDate addDays(int n) {
        return ImmutualDate.normalise(this.day + n, this.month, this.year);
    }

    public ImmutualDate addMonths(int n) {
        boolean bl = false;
        int n2 = n;
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        int n3 = this.day;
        int n4 = this.month;
        int n5 = this.year;
        for (int i = 0; i < n2; ++i) {
            int n6 = DateCalculations.monthDays(n4, n5);
            if (bl) {
                n3 -= n6;
                if (--n4 != 0) continue;
                n4 = 12;
                --n5;
                continue;
            }
            n3 += n6;
            if (++n4 != 13) continue;
            n4 = 1;
            ++n5;
        }
        return ImmutualDate.normalise(n3, this.month, this.year);
    }

    public ImmutualDate addYears(int n) {
        return ImmutualDate.normalise(this.day, this.month, this.year + n);
    }

    public ImmutualDate normalise() {
        return ImmutualDate.normalise(this);
    }

    public static ImmutualDate normalise(ImmutualDate immutualDate) {
        int n = immutualDate.getDay();
        int n2 = immutualDate.getMonth();
        int n3 = immutualDate.getYear();
        return ImmutualDate.normalise(n, n2, n3);
    }

    public static ImmutualDate normalise(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        while (n5 < 1) {
            n5 += 12;
            --n6;
        }
        while (n5 > 12) {
            n5 -= 12;
            ++n6;
        }
        while (n4 < 1) {
            if (--n5 == 0) {
                n5 = 12;
                --n6;
            }
            n4 += DateCalculations.monthDays(n5, n6);
        }
        while (n4 > DateCalculations.monthDays(n5, n6)) {
            n4 -= DateCalculations.monthDays(n5, n6);
            if (++n5 != 13) continue;
            n5 = 1;
            ++n6;
        }
        return new ImmutualDate(n4, n5, n6);
    }

    public Weekday dayOfTheWeek() {
        return DateCalculations.dayOfTheWeek(this.day, this.month, this.year);
    }

    public boolean isWorkDay() {
        return !this.isWeekend() && !this.isHoliday();
    }

    public boolean isWeekend() {
        return ImmutualDate.isWeekend(this.dayOfTheWeek());
    }

    public static boolean isWeekend(Weekday weekday) {
        return weekday == Weekday.SATURDAY || weekday == Weekday.SUNDAY;
    }

    public boolean isHoliday() {
        if (this.day == 1 && this.month == 1 || this.day == 1 && this.month == 5 || this.day == 15 && this.month == 8 || this.day == 3 && this.month == 10 || this.day == 1 && this.month == 11 || this.day == 24 && this.month == 12 || this.day == 25 && this.month == 12 || this.day == 26 && this.month == 12 || this.day == 31 && this.month == 12) {
            return true;
        }
        ImmutualDate immutualDate = DateCalculations.calculateEasterSunday(this.year);
        ImmutualDate immutualDate2 = immutualDate.addDays(1);
        ImmutualDate immutualDate3 = immutualDate.addDays(-2);
        ImmutualDate immutualDate4 = immutualDate.addDays(39);
        ImmutualDate immutualDate5 = immutualDate.addDays(50);
        ImmutualDate immutualDate6 = immutualDate.addDays(60);
        return this.equals(immutualDate) || this.equals(immutualDate2) || this.equals(immutualDate3) || this.equals(immutualDate4) || this.equals(immutualDate5) || this.equals(immutualDate6);
    }

    public boolean before(ImmutualDate immutualDate) {
        if (this.year < immutualDate.year) {
            return true;
        }
        if (this.year > immutualDate.year) {
            return false;
        }
        if (this.month < immutualDate.month) {
            return true;
        }
        if (this.month > immutualDate.month) {
            return false;
        }
        return this.day < immutualDate.day;
    }

    public boolean beforeOrEqual(ImmutualDate immutualDate) {
        if (this.year < immutualDate.year) {
            return true;
        }
        if (this.year > immutualDate.year) {
            return false;
        }
        if (this.month < immutualDate.month) {
            return true;
        }
        if (this.month > immutualDate.month) {
            return false;
        }
        return this.day <= immutualDate.day;
    }

    public boolean after(ImmutualDate immutualDate) {
        return immutualDate.before(this);
    }

    public boolean afterOrEqual(ImmutualDate immutualDate) {
        return immutualDate.beforeOrEqual(this);
    }

    public boolean between(ImmutualDate immutualDate, ImmutualDate immutualDate2) {
        if (!immutualDate.beforeOrEqual(immutualDate2)) {
            throw new IllegalArgumentException("Der \u00dcbergebene Datumsbereich von " + immutualDate + " bis " + immutualDate2 + " ist kein g\u00fcltiger Bereich.");
        }
        return this.afterOrEqual(immutualDate) && this.beforeOrEqual(immutualDate2);
    }

    int calculateDayDistanceTo(ImmutualDate immutualDate) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.before(immutualDate)) {
            n6 = this.getYear();
            n5 = this.getMonth();
            n4 = this.getDay();
            n3 = immutualDate.getYear();
            n2 = immutualDate.getMonth();
            n = immutualDate.getDay();
            bl = false;
        } else {
            n6 = immutualDate.getYear();
            n5 = immutualDate.getMonth();
            n4 = immutualDate.getDay();
            n3 = this.getYear();
            n2 = this.getMonth();
            n = this.getDay();
            bl = true;
        }
        int n7 = 0;
        n7 -= n4 - 1;
        n4 = 1;
        n7 += n - 1;
        n = 1;
        while (n5 > 1) {
            n7 -= DateCalculations.monthDays(--n5, n6);
        }
        while (n2 > 1) {
            n7 += DateCalculations.monthDays(--n2, n3);
        }
        while (n6 < n3) {
            n7 = ImmutualDate.isLeapYear(n6) ? (n7 += 366) : (n7 += 365);
            ++n6;
        }
        if (bl) {
            n7 *= -1;
        }
        return n7;
    }

    public String toString() {
        return String.format("%02d.%02d.%04d", this.day, this.month, this.year);
    }

    public String toStringInternational() {
        return String.format("%04d/%02d/%02d", this.year, this.month, this.day);
    }

    public String asYyyyMmDd() {
        return String.format("%04d%02d%02d", this.year, this.month, this.day);
    }

    public String asYyyyMinusMmMinusDd() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public String asDdMmYyyy() {
        return String.format("%02d%02d%04d", this.day, this.month, this.year);
    }

    public String getMonthAsFirstThreeLettersOfEnglishName() {
        switch (this.month) {
            case 1: {
                return "JAN";
            }
            case 2: {
                return "FEB";
            }
            case 3: {
                return "MAR";
            }
            case 4: {
                return "APR";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUN";
            }
            case 7: {
                return "JUL";
            }
            case 8: {
                return "AUG";
            }
            case 9: {
                return "SEP";
            }
            case 10: {
                return "OCT";
            }
            case 11: {
                return "NOV";
            }
            case 12: {
                return "DEC";
            }
        }
        throw new RuntimeException("Monat " + this.month + " im falschen Bereich!");
    }

    public String toSasFormat() {
        return String.format("%d%s%d", this.day, this.getMonthAsFirstThreeLettersOfEnglishName(), this.year);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.day;
        n = 31 * n + this.month;
        n = 31 * n + this.year;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutualDate immutualDate = (ImmutualDate)object;
        if (this.day != immutualDate.day) {
            return false;
        }
        if (this.month != immutualDate.month) {
            return false;
        }
        return this.year == immutualDate.year;
    }

    @Override
    public int compareTo(ImmutualDate immutualDate) {
        return -this.calculateDayDistanceTo(immutualDate);
    }

    public ImmutualDate generateNextWorkDay() {
        ImmutualDate immutualDate = this.addDays(1);
        while (!immutualDate.isWorkDay()) {
            immutualDate = immutualDate.addDays(1);
        }
        return immutualDate;
    }

    @Override
    public String toXml() {
        return "<immutual-date>" + this.toString() + "</immutual-date>";
    }

    public static ImmutualDate createFromXml(String string) {
        String string2 = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlLine(XML_IMMUTUAL_DATE_TAG, string);
        return new ImmutualDate(string2);
    }

    public ImmutualDate getWeekdayBefore(Weekday weekday) {
        Weekday weekday2 = this.dayOfTheWeek();
        int n = weekday2.getDayCode();
        int n2 = weekday.getDayCode();
        int n3 = n2 < n ? n - n2 : 7 + n - n2;
        int n4 = -n3;
        return this.addDays(n4);
    }

    public boolean isToday() {
        return this.equals(new ImmutualDate());
    }

    public String getMonthAsGermanWord() {
        if (this.month < 1 || this.month > 12) {
            throw new RuntimeException("Monat " + this.month + " im falschen Bereich!");
        }
        return GERMAN_MONTH_NAMES.get(this.month - 1);
    }
}

