/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.split;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.FineFileWriter;
import java.util.List;

public class SplittedTextFileJoiner {
    private List<String> filenamesOfSplitFiles;
    private final String joinedFilename;
    private final Charset charset;
    private final boolean hasTitles;
    private boolean verbose;

    public SplittedTextFileJoiner(List<String> list, String string, Charset charset, boolean bl) {
        this.filenamesOfSplitFiles = list;
        this.joinedFilename = string;
        this.charset = charset;
        this.hasTitles = bl;
        this.verbose = true;
    }

    public void beQuiet() {
        this.verbose = false;
    }

    public void work() {
        boolean bl = false;
        FineFileWriter fineFileWriter = new FineFileWriter(this.joinedFilename, this.charset);
        for (String string : this.filenamesOfSplitFiles) {
            int n;
            List<String> list = FileHelper.readFileToList(string, this.charset);
            if (list.isEmpty()) {
                throw new RuntimeException("Die aufgeteilte Datei " + string + " ist leer.");
            }
            if (!bl && this.hasTitles) {
                fineFileWriter.writeln(list.get(0));
                bl = true;
            }
            for (int i = n = this.hasTitles ? 1 : 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                fineFileWriter.writeln(string2);
            }
            this.say("Datei " + string + " gelesen.");
        }
        fineFileWriter.close();
        this.say("Ergebnisdatei " + this.joinedFilename + " erzeugt.");
    }

    private void say(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

