/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

public class TextPosition
implements Comparable<TextPosition> {
    private final int begin;
    private final int end;

    public TextPosition(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("'end' darf nicht kleiner sein als 'begin' (begin=" + n + ", end = " + n2 + ")");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("'end' darf nicht negativ sein (end = " + n2 + ")");
        }
        if (n < 0) {
            throw new IllegalArgumentException("'begin' darf nicht negativ sein (begin = " + n + ")");
        }
        this.begin = n;
        this.end = n2;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public String getTextPartAtPostion(String string) {
        if (this.begin >= string.length()) {
            return "";
        }
        if (this.end >= string.length()) {
            return string.substring(this.begin);
        }
        return string.substring(this.begin, this.end);
    }

    @Override
    public int compareTo(TextPosition textPosition) {
        if (textPosition == this) {
            return 0;
        }
        if (this.begin != textPosition.begin) {
            return this.begin - textPosition.begin;
        }
        return this.end - textPosition.end;
    }

    public boolean overlapp(TextPosition textPosition) {
        if (this.end <= textPosition.begin) {
            return false;
        }
        return textPosition.end > this.begin;
    }

    public TextPosition meltWith(TextPosition textPosition) {
        if (!this.overlapp(textPosition)) {
            throw new IllegalArgumentException("Die beiden positionen \u00fcberlappen sich nicht! this = " + this + ", that = " + textPosition);
        }
        return new TextPosition(Math.min(this.begin, textPosition.begin), Math.max(this.end, textPosition.end));
    }

    public String toString() {
        return "TextPosition [begin=" + this.begin + ", end=" + this.end + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.begin;
        n = 31 * n + this.end;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TextPosition textPosition = (TextPosition)object;
        if (this.begin != textPosition.begin) {
            return false;
        }
        return this.end == textPosition.end;
    }
}

