/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.extract.tools;

import de.duehl.basics.collections.CollectionsHelper;
import java.util.ArrayList;
import java.util.List;

public class UnwantedWordsRemover {
    private static final List<String> DIGITS = CollectionsHelper.buildListFrom("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    private final List<String> words;
    private final List<String> cleanedWords;

    public UnwantedWordsRemover(List<String> list) {
        this.words = list;
        this.cleanedWords = new ArrayList<String>();
        this.removeUnwantedWords();
    }

    private List<String> removeUnwantedWords() {
        for (String string : this.words) {
            if (!this.wordIsOk(string)) continue;
            this.cleanedWords.add(string);
        }
        return this.cleanedWords;
    }

    private boolean wordIsOk(String string) {
        return !this.wordIsNotOk(string);
    }

    private boolean wordIsNotOk(String string) {
        return this.wordIsIncomplete(string) || this.wordContainsNumber(string) || this.wordContainsAt(string);
    }

    private boolean wordIsIncomplete(String string) {
        return string.startsWith("-") || string.endsWith("-") || string.length() < 2;
    }

    private boolean wordContainsNumber(String string) {
        for (String string2 : DIGITS) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean wordContainsAt(String string) {
        return string.contains("@");
    }

    public List<String> getCleanedWords() {
        return this.cleanedWords;
    }
}

