/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.selections.FontSizeChangable;
import de.duehl.swing.ui.components.selections.tools.BackgroundColorChangingComboBoxEditor;
import de.duehl.swing.ui.dragndrop.EditorUiElementManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ComboBoxSelection
implements FontSizeChangable {
    static final int UNDIFINED_STANDARD_FONT_SIZE = -1;
    static final int LEFT_TITLE_DISTANCE = 5;
    private final List<String> values;
    private final JLabel titleLabel;
    private final JPanel mainPanel;
    private final JComboBox<String> comboBox;
    private final BackgroundColorChangingComboBoxEditor comboBoxEditor;
    private int standardFontSize;
    private int standardLabelFontSize;

    public ComboBoxSelection(String string, List<String> list) {
        if (!CollectionsHelper.isDisjunct(list)) {
            throw new IllegalArgumentException("Die \u00fcbergebenen Werte f\u00fcr die ComboBox sind nicht disjunkt:\n" + CollectionsHelper.listListNice(list));
        }
        this.values = list;
        this.titleLabel = new JLabel(string);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.comboBox = new JComboBox();
        for (String string2 : list) {
            this.comboBox.addItem(string2);
        }
        this.comboBoxEditor = new BackgroundColorChangingComboBoxEditor();
        this.comboBox.setEditor(this.comboBoxEditor);
        this.mainPanel = this.createMainPanel();
        this.standardFontSize = -1;
        this.standardLabelFontSize = -1;
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        jPanel.add(this.comboBox, "Center");
        return jPanel;
    }

    public String getSelectedItem() {
        String string = (String)this.comboBox.getSelectedItem();
        return string;
    }

    public void setSelectedItem(String string) {
        if (!this.values.contains(string)) {
            throw new IllegalArgumentException("Der \u00fcbergebene Text '" + string + "' wird in der ComboBox nicht angezeigt.");
        }
        this.comboBox.setSelectedItem(string);
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.values.size()) {
            throw new IllegalArgumentException("Der \u00fcbergebene Index '" + n + "' liegt nicht im erlaubten Bereich [0, " + this.values.size() + ").");
        }
        this.comboBox.setSelectedIndex(n);
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.mainPanel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.comboBox);
    }

    public void setPreferredSize(Dimension dimension) {
        this.comboBox.setPreferredSize(dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        this.comboBox.setMinimumSize(dimension);
    }

    public void addTextFieldFocuslistener(FocusListener focusListener) {
        this.comboBox.addFocusListener(focusListener);
    }

    public void setEditable(boolean bl) {
        this.comboBox.setEditable(bl);
    }

    public void setFocusable(boolean bl) {
        this.comboBox.setFocusable(bl);
    }

    public void requestFocus() {
        this.comboBox.requestFocus();
    }

    public boolean hasFocus() {
        return this.comboBox.hasFocus();
    }

    public void makeHorizontal() {
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.titleLabel, "West");
        this.mainPanel.add(this.comboBox, "Center");
    }

    public void setToolTipText(String string) {
        this.titleLabel.setToolTipText(string);
        this.mainPanel.setToolTipText(string);
        this.comboBox.setToolTipText(string);
    }

    public void addComboBoxActionListener(ActionListener actionListener) {
        this.comboBox.addActionListener(actionListener);
    }

    public void setBackgroundColor(Color color) {
        this.comboBoxEditor.setBackground(color);
    }

    @Override
    public void biggerText(int n) {
        GuiTools.biggerFont(this.comboBox, n);
    }

    @Override
    public void storeAsStandardFontSize() {
        Font font = this.comboBox.getFont();
        this.standardFontSize = font.getSize();
    }

    @Override
    public void setToStandardFontSize() {
        if (this.standardFontSize != -1) {
            this.setFontSize(this.standardFontSize);
        }
    }

    @Override
    public int getFontSize() {
        Font font = this.comboBox.getFont();
        return font.getSize();
    }

    @Override
    public void setFontSize(int n) {
        GuiTools.setFontSize(this.comboBox, n);
    }

    @Override
    public void biggerLabelText(int n) {
        GuiTools.biggerFont(this.titleLabel, n);
    }

    @Override
    public void storeAsStandardLabelFontSize() {
        Font font = this.titleLabel.getFont();
        this.standardLabelFontSize = font.getSize();
    }

    @Override
    public void setToStandardLabelFontSize() {
        if (this.standardLabelFontSize != -1) {
            this.setLabelFontSize(this.standardLabelFontSize);
        }
    }

    @Override
    public int getLabelFontSize() {
        Font font = this.titleLabel.getFont();
        return font.getSize();
    }

    @Override
    public void setLabelFontSize(int n) {
        GuiTools.setFontSize(this.titleLabel, n);
    }

    public void setMonospacedFont() {
        GuiTools.setMonospacedFont(this.comboBox);
    }

    public void setMonospacedFont(int n) {
        GuiTools.setMonospacedFont(this.comboBox, n);
    }

    public void switchLabelToBold() {
        GuiTools.boldFont(this.titleLabel);
    }

    public void switchTextToBold() {
        GuiTools.boldFont(this.comboBox);
    }

    public void setEnabled(boolean bl) {
        this.comboBox.setEnabled(bl);
    }

    public void setBorder(Border border) {
        this.mainPanel.setBorder(border);
    }

    public void ignorePageUpAndPageDown() {
        GuiTools.ignorePageUpAndPageDownInComponent(this.comboBox);
    }

    public void ignoreUpAndDown() {
        GuiTools.ignoreUpAndDownInComponent(this.comboBox);
    }

    public void addChangeListenerAndDragNDropCorrectorToComboBox(EditorUiElementManager editorUiElementManager) {
        this.throwExceptionIfNotEditable();
        JTextField jTextField = this.comboBoxEditor.getTextField();
        editorUiElementManager.addChangeListenerAndDragNDropCorrectorToTextField(jTextField);
    }

    public void reactOnDoubleClick(Runnable runnable) {
        this.throwExceptionIfNotEditable();
        JTextField jTextField = this.comboBoxEditor.getTextField();
        GuiTools.createDoubleClickAndDispatchMouseScrollEventMouseAdapter(jTextField, runnable);
    }

    public void setText(String string) {
        this.throwExceptionIfNotEditable();
        if (this.values.contains(string)) {
            this.comboBox.setSelectedItem(string);
        }
        JTextField jTextField = this.comboBoxEditor.getTextField();
        jTextField.setText(string);
    }

    private void throwExceptionIfNotEditable() {
        if (!this.comboBox.isEditable()) {
            throw new RuntimeException("Unzul\u00e4ssig, wenn nicht editierbar!");
        }
    }

    public void dispatchMouseScrollEvent() {
        GuiTools.dispatchMouseScrollEvent(this.titleLabel);
        GuiTools.dispatchMouseScrollEvent(this.comboBox);
        GuiTools.dispatchMouseScrollEvent(this.mainPanel);
        GuiTools.dispatchMouseScrollEvent(this.comboBoxEditor.getTextField());
    }

    public String getTrimmedText() {
        String string = this.getText();
        string = string.trim();
        return string;
    }

    public String getText() {
        String string;
        if (this.comboBox.isEditable()) {
            JTextField jTextField = this.comboBoxEditor.getTextField();
            string = jTextField.getText();
        } else {
            string = this.getSelectedItem();
        }
        return string;
    }

    public void setRedCaretColor() {
        if (this.comboBox.isEditable()) {
            JTextField jTextField = this.comboBoxEditor.getTextField();
            jTextField.setCaretColor(Color.RED);
        }
    }

    public void setForegroundColor(Color color) {
        JTextField jTextField = this.comboBoxEditor.getTextField();
        jTextField.setForeground(color);
    }

    public void setComboBoxCentered() {
        this.comboBox.setAlignmentX(0.0f);
        this.comboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.comboBox.getRenderer())).setHorizontalAlignment(0);
    }
}

