/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.navigator.NavigatorPanel;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectionVerificationDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(850, 600);
    private static final int MAX_LENGTH = (int)(DIALOG_DIMENSION.getWidth() - 50.0) / 10;
    private static final int NUMBER_OF_THINGS_PER_COLUMN = (int)(DIALOG_DIMENSION.getHeight() - 140.0) / 27;
    private static final int MAX_LENGTH_FOR_FOUR_COLUMNS = MAX_LENGTH / 4;
    private static final int MAX_LENGTH_FOR_THREE_COLUMNS = MAX_LENGTH / 3;
    private static final int MAX_LENGTH_FOR_TWO_COLUMNS = MAX_LENGTH / 2;
    private boolean userPressedOk;
    private final List<String> thingsToSelect;
    private int numberOfColumns;
    private int numberOfThingsPerPage;
    private int numberOfPages;
    private int numberOfShownPage;
    private List<Component> pages;
    private List<JCheckBox> thingsWithSelection;
    private JPanel pagesPanel;
    private List<String> selectedThings;
    private String bareTitle;

    public SelectionVerificationDialog(List<String> list, String string) {
        this(list, new Point(250, 100), string);
    }

    public SelectionVerificationDialog(List<String> list, Point point, String string) {
        this(list, point, null, string);
    }

    public SelectionVerificationDialog(List<String> list, Point point, Image image, String string) {
        super(point, image, string, DIALOG_DIMENSION);
        this.thingsToSelect = list;
        this.bareTitle = string + " ";
        this.userPressedOk = false;
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.determineNumberOfColumns();
        this.numberOfThingsPerPage = NUMBER_OF_THINGS_PER_COLUMN * this.numberOfColumns;
        int n = this.thingsToSelect.size();
        this.numberOfPages = (int)Math.ceil((double)n / (double)this.numberOfThingsPerPage);
        this.createThingsWithSelection();
        this.createPages();
        this.createCardPanel();
    }

    private void determineNumberOfColumns() {
        int n = this.determineMaximumLengthOfThings();
        this.numberOfColumns = n <= MAX_LENGTH_FOR_FOUR_COLUMNS ? 4 : (n <= MAX_LENGTH_FOR_THREE_COLUMNS ? 3 : (n <= MAX_LENGTH_FOR_TWO_COLUMNS ? 2 : 1));
    }

    private int determineMaximumLengthOfThings() {
        int n = 0;
        for (String string : this.thingsToSelect) {
            int n2 = string.length();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private void createThingsWithSelection() {
        this.thingsWithSelection = new ArrayList<JCheckBox>();
        for (String string : this.thingsToSelect) {
            JCheckBox jCheckBox = this.createCheckBox(string);
            this.thingsWithSelection.add(jCheckBox);
        }
    }

    private JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setSelected(true);
        return jCheckBox;
    }

    private void createPages() {
        Component component;
        List<JCheckBox> list = CollectionsHelper.copyList(this.thingsWithSelection);
        this.pages = new ArrayList<Component>();
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        while (!list.isEmpty()) {
            component = list.remove(0);
            arrayList.add((JCheckBox)component);
            if (arrayList.size() < this.numberOfThingsPerPage) continue;
            Component component2 = this.createPage(arrayList);
            this.pages.add(component2);
            arrayList = new ArrayList();
        }
        if (!arrayList.isEmpty()) {
            component = this.createPage(arrayList);
            this.pages.add(component);
        }
    }

    private Component createPage(List<JCheckBox> list) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createPageButtonPart(list), "South");
        jPanel.add(this.createPagePart(list), "Center");
        return jPanel;
    }

    private Component createPageButtonPart(List<JCheckBox> list) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSelectPageBoxesButton(list), "West");
        jPanel.add(this.createDeselectPageBoxesButton(list), "East");
        return jPanel;
    }

    private Component createSelectPageBoxesButton(List<JCheckBox> list) {
        String string = this.doWeHaveToShowNavigation() ? "<html>Auf dieser Seite alles <b>aus</b>w\u00e4hlen</html>" : "<html>Alles <b>aus</b>w\u00e4hlen</html>";
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionEvent -> this.selectAllBoxesOnPage(list));
        return jButton;
    }

    private void selectAllBoxesOnPage(List<JCheckBox> list) {
        for (JCheckBox jCheckBox : list) {
            jCheckBox.setSelected(true);
        }
    }

    private Component createDeselectPageBoxesButton(List<JCheckBox> list) {
        String string = this.doWeHaveToShowNavigation() ? "<html>Auf dieser Seite alles <b>ab</b>w\u00e4hlen</html>" : "<html>Alles <b>ab</b>w\u00e4hlen</html>";
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionEvent -> this.deselectAllBoxesOnPage(list));
        return jButton;
    }

    private void deselectAllBoxesOnPage(List<JCheckBox> list) {
        for (JCheckBox jCheckBox : list) {
            jCheckBox.setSelected(false);
        }
    }

    private Component createPagePart(List<JCheckBox> list) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, this.numberOfColumns));
        for (int i = 0; i < this.numberOfColumns; ++i) {
            List<JCheckBox> list2 = this.createBoxesForColumn(i, list);
            Component component = this.createColumn(list2);
            jPanel.add(component);
        }
        jPanel.setLayout(new GridLayout(1, this.numberOfColumns));
        return jPanel;
    }

    private List<JCheckBox> createBoxesForColumn(int n, List<JCheckBox> list) {
        int n2 = n * NUMBER_OF_THINGS_PER_COLUMN;
        int n3 = (n + 1) * NUMBER_OF_THINGS_PER_COLUMN;
        if (n2 >= list.size()) {
            return new ArrayList<JCheckBox>();
        }
        if (n3 > list.size()) {
            return list.subList(n2, list.size());
        }
        return list.subList(n2, n3);
    }

    private Component createColumn(List<JCheckBox> list) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        for (JCheckBox jCheckBox : list) {
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    private void createCardPanel() {
        this.pagesPanel = new JPanel(new CardLayout());
        GuiTools.createTitle(this.pagesPanel);
        for (int i = 0; i < this.numberOfPages; ++i) {
            Component component = this.pages.get(i);
            String string = this.buildPageName(i + 1);
            this.pagesPanel.add(component, string);
        }
    }

    private String buildPageName(int n) {
        return "PAGE " + n;
    }

    @Override
    protected void populateDialog() {
        this.add(this.pagesPanel, "Center");
        this.add(this.createLowerPart(), "South");
        this.addEscapeBehaviour();
        this.first();
    }

    private Component createLowerPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        if (this.doWeHaveToShowNavigation()) {
            jPanel.add(this.createNavigation(), "West");
            jPanel.add(this.createButtonPart(), "East");
        } else {
            jPanel.add(this.createOkAndCancelButtons(), "Center");
        }
        return jPanel;
    }

    private boolean doWeHaveToShowNavigation() {
        return this.numberOfPages > 1;
    }

    private Component createNavigation() {
        NavigatorPanel navigatorPanel = new NavigatorPanel(new Dimension(50, 50));
        navigatorPanel.fillNavigator();
        navigatorPanel.addFirstActionListener(actionEvent -> this.first());
        navigatorPanel.addPreviousActionListener(actionEvent -> this.previous());
        navigatorPanel.addNextActionListener(actionEvent -> this.next());
        navigatorPanel.addLastActionListener(actionEvent -> this.last());
        JPanel jPanel = navigatorPanel.center();
        GuiTools.createTitle(jPanel);
        return jPanel;
    }

    private void first() {
        this.switchToPage(1);
    }

    private void previous() {
        if (this.numberOfShownPage > 1) {
            this.switchToPage(this.numberOfShownPage - 1);
        }
    }

    private void next() {
        if (this.numberOfShownPage < this.numberOfPages) {
            this.switchToPage(this.numberOfShownPage + 1);
        }
    }

    private void last() {
        this.switchToPage(this.numberOfPages);
    }

    private void switchToPage(int n) {
        CardLayout cardLayout = (CardLayout)this.pagesPanel.getLayout();
        String string = this.buildPageName(n);
        cardLayout.show(this.pagesPanel, string);
        this.numberOfShownPage = n;
        this.setTitle(this.bareTitle + "Seite " + this.numberOfShownPage + " / " + this.numberOfPages);
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createGlobalSelectionButtons(), "West");
        jPanel.add(this.createOkAndCancelButtons(), "East");
        return jPanel;
    }

    private Component createGlobalSelectionButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createSelectAllBoxesButton(), "West");
        jPanel.add(this.createDeselectAllBoxesButton(), "East");
        return jPanel;
    }

    private Component createSelectAllBoxesButton() {
        JButton jButton = new JButton("<html>Auf allen Seiten<br>alles <b>aus</b>w\u00e4hlen</html>");
        jButton.addActionListener(actionEvent -> this.selectAllBoxesOnAllPages());
        return jButton;
    }

    private void selectAllBoxesOnAllPages() {
        for (JCheckBox jCheckBox : this.thingsWithSelection) {
            jCheckBox.setSelected(true);
        }
    }

    private Component createDeselectAllBoxesButton() {
        JButton jButton = new JButton("<html>Auf allen Seiten<br>alles <b>ab</b>w\u00e4hlen</html>");
        jButton.addActionListener(actionEvent -> this.deselectAllBoxesOnAllPages());
        return jButton;
    }

    private void deselectAllBoxesOnAllPages() {
        for (JCheckBox jCheckBox : this.thingsWithSelection) {
            jCheckBox.setSelected(false);
        }
    }

    private Component createOkAndCancelButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.createQuitButton(), "West");
        jPanel.add((Component)new JLabel("                "), "Center");
        jPanel.add(this.createOKButton(), "East");
        return jPanel;
    }

    private Component createOKButton() {
        JButton jButton = new JButton("OK");
        jButton.setMargin(new Insets(5, 25, 5, 25));
        GuiTools.boldFont(jButton);
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.userPressedOk = true;
        this.selectedThings = new ArrayList<String>();
        for (JCheckBox jCheckBox : this.thingsWithSelection) {
            if (!jCheckBox.isSelected()) continue;
            String string = jCheckBox.getText();
            this.selectedThings.add(string);
        }
        this.closeDialog();
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Abbruch");
        jButton.addActionListener(actionEvent -> this.cancel());
        return jButton;
    }

    private void cancel() {
        this.userPressedOk = false;
        this.closeDialog();
    }

    public boolean userPressedOk() {
        return this.userPressedOk;
    }

    public List<String> getSelectedThings() {
        return this.selectedThings;
    }
}

