/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.lists;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.PlusButton;
import de.duehl.swing.ui.dialogs.lists.EditableListDialogBase;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class EditableListDialog<Element extends LogicalEditableListElement>
extends EditableListDialogBase<Element> {
    private final String elementsTitle;

    public EditableListDialog(Dimension dimension, Point point, Image image, String string, String string2, LogicalEditableList<Element> logicalEditableList) {
        super(dimension, point, image, string, logicalEditableList);
        this.setMinimumSize(dimension);
        this.elementsTitle = string2;
    }

    @Override
    protected final Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createTitleAndButtonForNewElementPart(), "North");
        jPanel.add((Component)this.getElementsPanel(), "Center");
        return jPanel;
    }

    private Component createTitleAndButtonForNewElementPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createTitleLabel(), "Center");
        jPanel.add(this.createNewElementPart(), "East");
        return jPanel;
    }

    private Component createTitleLabel() {
        JLabel jLabel = new JLabel(this.elementsTitle);
        GuiTools.biggerFont(jLabel, 10);
        GuiTools.boldFont(jLabel);
        return jLabel;
    }

    private Component createNewElementPart() {
        PlusButton plusButton = new PlusButton();
        plusButton.setFocusable(false);
        plusButton.addActionListener(actionEvent -> this.createNewUiElement());
        plusButton.setForceSquare(true);
        return plusButton;
    }

    private void createNewUiElement() {
        Element Element2 = this.createNewElement();
        EditableListElement<Element> editableListElement = this.createUiElement(Element2);
        editableListElement.editElement();
        if (Element2.areUserInputValuesFilled()) {
            if (this.logicalList.canWeAdd(Element2)) {
                this.logicalList.add(Element2);
                this.updateElementsPanel();
            } else {
                GuiTools.informUser(this.getDialog(), "Gleiche Daten eingegeben!", "Es wurde kein neues Listenobjekt erzeugt, da die Eingabe der Daten einem bereits vorhandenen Element in zu gro\u00dfem Ma\u00dfe gleicht.");
            }
        } else {
            GuiTools.informUser(this.getDialog(), "Zu wenige Daten eingegeben!", "Es wurde kein neues Listenobjekt erzeugt, da die Eingabe der Daten unvollst\u00e4ndig war.");
        }
    }

    protected abstract Element createNewElement();

    @Override
    protected Component createRealElementPart(Element Element2) {
        EditableListElement<Element> editableListElement = this.createUiElement(Element2);
        return editableListElement.createPanel();
    }
}

