/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.values;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.values.EnterTwoValuesDialog;
import java.awt.Image;
import java.awt.Point;

public class EnterRangeDialog
extends EnterTwoValuesDialog {
    public static final int NO_MIN_OR_MAX_VALUE = -1;

    public EnterRangeDialog(Point point, Image image, String string, int n, int n2) {
        this(null, point, image, string, n, n2);
    }

    public EnterRangeDialog(Colorizer colorizer, Point point, Image image, String string, int n, int n2) {
        super(colorizer, point, image, string, "Minimalwert", Integer.toString(n), "Maximalwert", Integer.toString(n2));
    }

    @Override
    protected void apply() {
        String string = this.getFirstValue();
        String string2 = this.getSecondValue();
        if (string.isEmpty()) {
            this.applyFailure("Der erste Wert darf nicht leer sein.");
        } else if (string2.isEmpty()) {
            this.applyFailure("Der zweite Wert darf nicht leer sein.");
        } else if (!NumberString.isDigitSequence(string)) {
            this.applyFailure("Der erste Wert darf nur aus Ziffern bestehen.");
        } else if (!NumberString.isDigitSequence(string2)) {
            this.applyFailure("Der zweite Wert darf nur aus Ziffern bestehen.");
        } else {
            int n;
            int n2 = Integer.parseInt(string);
            if (n2 <= (n = Integer.parseInt(string2))) {
                this.applyOk();
            } else {
                this.applyFailure("Der erste Wert muss kleiner gleich dem zweiten Wert sein.");
            }
        }
    }

    public int getMinValue() {
        if (this.isApplyOk()) {
            return Integer.parseInt(this.getFirstValue());
        }
        return -1;
    }

    public int getMaxValue() {
        if (this.isApplyOk()) {
            return Integer.parseInt(this.getSecondValue());
        }
        return -1;
    }
}

