/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.watch.StopWatchLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DisabledGlassPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Color FALLBACK_COLOR = new Color(184, 207, 229);
    private final StopWatchLabel stopWatchLabel;
    private Component connectedComponent;

    public DisabledGlassPane() {
        this.setOpaque(false);
        this.stopWatchLabel = new StopWatchLabel();
        SwingUtilities.invokeLater(() -> this.stopWatchLabel.stop());
        this.setOurBackground();
        this.setLayout(new GridBagLayout());
        this.disableMouseKeyboaurdAndFocusEvents();
    }

    private void disableMouseKeyboaurdAndFocusEvents() {
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(this.createConsumingKeyListener());
        this.setFocusTraversalKeysEnabled(false);
    }

    private KeyListener createConsumingKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        };
    }

    private void setOurBackground() {
        Color color = this.getBaseColor();
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        this.setBackground(color2);
    }

    private Color getBaseColor() {
        Color color = UIManager.getColor("inactiveCaptionBorder");
        if (null == color) {
            color = FALLBACK_COLOR;
        }
        return color;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Color color2 = new Color(color.getRGB());
        this.stopWatchLabel.setBackground(color2);
    }

    public void activate(String string) {
        if (string != null && !string.isEmpty()) {
            this.stopWatchLabel.stop();
            this.removeAll();
            this.stopWatchLabel.setStartText("<html><center>" + string + "<br/>");
            this.stopWatchLabel.setEndText("</center></html>");
            this.stopWatchLabel.start();
            this.stopWatchLabel.setOpaque(true);
            this.stopWatchLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.add((Component)this.stopWatchLabel, new GridBagConstraints());
            this.setOurBackground();
            this.stopWatchLabel.setForeground(this.getForeground());
            this.stopWatchLabel.setVisible(true);
        } else if (null != this.stopWatchLabel) {
            this.stopWatchLabel.setVisible(false);
        }
        this.setVisible(true);
        this.waiCursorOn();
        this.requestFocusInWindow();
    }

    private void waiCursorOn() {
        GuiTools.waitcursorOn(this);
        this.checkConnectedComponentSet();
        GuiTools.waitcursorOn(this.connectedComponent);
    }

    public void deactivate() {
        this.stopWatchLabel.stop();
        this.waitCursorOff();
        this.setVisible(false);
    }

    private void waitCursorOff() {
        GuiTools.waitcursorOff(this);
        this.checkConnectedComponentSet();
        GuiTools.waitcursorOff(this.connectedComponent);
    }

    private void checkConnectedComponentSet() {
        if (this.connectedComponent == null) {
            throw new RuntimeException("Es wurde vergessen, DisabledGlassPane#connectTo(Component) aufzurufen!");
        }
    }

    public void connectTo(Component component) {
        JRootPane jRootPane = SwingUtilities.getRootPane(component);
        jRootPane.setGlassPane(this);
        this.connectedComponent = component;
    }
}

