/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.search;

import de.duehl.basics.debug.DebugHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.elements.search.SearchReaktor;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;

public class EditorSearcher {
    private static final String NO_SEARCH_TEXT = "###_NO_SEARCH_WORD_ENTERED_###";
    private static final boolean DEBUG = true;
    private int lastSearchIndex = 0;
    private String searchText = "###_NO_SEARCH_WORD_ENTERED_###";
    private HighlightingEditor editor;

    public EditorSearcher() {
    }

    public EditorSearcher(HighlightingEditor highlightingEditor) {
        this.editor = highlightingEditor;
    }

    public void switchEditor(HighlightingEditor highlightingEditor) {
        if (!highlightingEditor.equals(this.editor)) {
            this.editor = highlightingEditor;
            this.lastSearchIndex = 0;
        }
    }

    public SearchReaktor createSearchReaktor() {
        return new SearchReaktor(){

            @Override
            public void search(String string) {
                EditorSearcher.this.searchInternal(string);
            }

            @Override
            public void searchAgain() {
                EditorSearcher.this.searchAgainInternal();
            }
        };
    }

    private void searchInternal(String string) {
        this.searchText = string;
        this.lastSearchIndex = this.editor.getCaretPosition();
        this.searchAgainInternal();
    }

    private void searchAgainInternal() {
        if (this.searchTextIsValid()) {
            this.searchAgainWithValidSearchText();
        }
    }

    private boolean searchTextIsValid() {
        return this.searchText != NO_SEARCH_TEXT && !this.searchText.isEmpty();
    }

    private void searchAgainWithValidSearchText() {
        String string = this.getTextWithInternalLineBreaks();
        this.adjustLastSearchIndexInCaseOfShortenedText(string);
        int n = string.indexOf(this.searchText, this.lastSearchIndex);
        if (n < 0) {
            this.say("Suche von vorn...");
            n = string.indexOf(this.searchText, 0);
        }
        if (n < 0) {
            this.searchWasNotSuccessfull();
        } else {
            this.searchAgainWithValidIndex(n);
        }
    }

    private String getTextWithInternalLineBreaks() {
        String string = this.editor.getText();
        string = Text.lineBreaksToBackslashN(string);
        return string;
    }

    private void adjustLastSearchIndexInCaseOfShortenedText(String string) {
        if (this.lastSearchIndex >= string.length()) {
            this.lastSearchIndex = 0;
        }
    }

    private void searchWasNotSuccessfull() {
        this.say("Suchbegriff '" + this.searchText + "' nicht im Text gefunden.");
    }

    private void searchAgainWithValidIndex(int n) {
        this.lastSearchIndex = n + this.searchText.length();
        this.say("Suchbegriff '" + this.searchText + "' an Position " + n + " bis " + this.lastSearchIndex + " im Text gefunden.");
        this.editor.select(n, this.lastSearchIndex);
    }

    private void say(String string) {
        String string2 = this.editor.getFilename();
        String string3 = "(" + (null == string2 ? "unknown" : string2) + ") - ";
        DebugHelper.sayWithClassAndMethodAndTime(string3 + string);
    }
}

