/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.state;

import de.duehl.basics.debug.DebugHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.highlightingeditor.io.WatchFileOnDiskChange;

public class EditorState {
    private static final boolean DEBUG = true;
    private String filename;
    private Charset charset;
    private String text;
    private WatchFileOnDiskChange watchFileOnDiskChange;
    private int caretPosition;

    public EditorState() {
        this.filename = "";
        this.charset = HighlightingEditor.DEFAULT_CHARSET;
        this.text = "";
        this.watchFileOnDiskChange = new WatchFileOnDiskChange();
        this.caretPosition = 0;
    }

    public EditorState(EditorState editorState) {
        this.filename = editorState.filename;
        this.charset = editorState.charset;
        this.text = editorState.text;
        this.watchFileOnDiskChange = new WatchFileOnDiskChange(editorState.watchFileOnDiskChange);
        this.caretPosition = editorState.caretPosition;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getText() {
        return this.text;
    }

    private void setText(String string) {
        this.text = string;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public void setTextAndCaretPosition(String string, int n) {
        this.text = string;
        this.caretPosition = n;
    }

    public String createNameForDisplay() {
        if (this.isFilenameEmpty()) {
            return "-----";
        }
        return this.getBarename();
    }

    public boolean isFilenameEmpty() {
        return this.filename.isEmpty();
    }

    public String getBarename() {
        return FileHelper.getBareName(this.filename);
    }

    public String determineStartDirectory() {
        if (this.filename.isEmpty()) {
            return "C:";
        }
        return FileHelper.getDirName(this.filename);
    }

    public void newFile() {
        this.watchFileOnDiskChange.notLoaded();
        this.filename = "";
        this.charset = HighlightingEditor.DEFAULT_CHARSET;
    }

    public String openFile(String string, Charset charset) {
        this.filename = string;
        this.charset = charset;
        this.say("openFile  vor eigentlichem Laden");
        String string2 = this.loadText();
        this.say("openFile  nach eigentlichem Laden");
        return string2;
    }

    private String loadText() {
        if (this.isFilenameEmpty()) {
            this.say("Dateiname ist leer.");
            return "";
        }
        this.say("Starte Laden von  " + this.filename);
        String string = FileHelper.readFileToString(this.filename, this.charset);
        this.say("Fertig mit Laden von  " + this.filename);
        this.watchFileOnDiskChange.loadedSuccessfully(this.filename);
        return string;
    }

    public void saveUnderFilename(String string) {
        this.setText(string);
        String string2 = EditorState.correctTextEndings(string);
        FileHelper.writeTextToFile(string2, this.filename, this.charset);
        this.watchFileOnDiskChange.savedSuccessfully(this.filename);
    }

    private static String correctTextEndings(String string) {
        String string2 = string;
        if (string2.endsWith("\r\n")) {
            string2 = Text.removeLastCharacters(string, 2);
        } else if (string2.endsWith("\n")) {
            string2 = Text.removeLastCharacters(string, 1);
        }
        return string2;
    }

    public void disableWatchFileOnDiskChange() {
        this.watchFileOnDiskChange.setEnabled(false);
    }

    public boolean doesFileNotExistAnymore() {
        return this.watchFileOnDiskChange.doesFileNotExistAnymore();
    }

    public void notLoaded() {
        this.watchFileOnDiskChange.notLoaded();
    }

    public boolean hasFileChangedOnDisk() {
        return this.watchFileOnDiskChange.hasFileChangedOnDisk();
    }

    public int getLineBreakCorrectedTextLength() {
        String string = Text.lineBreaksToBackslashN(this.text);
        return string.length();
    }

    private void say(String string) {
        String string2 = "(" + (null == this.filename ? "unknown" : this.filename) + ") - ";
        DebugHelper.sayWithClassAndMethodAndTime(string2 + string);
    }

    public String toString() {
        return "EditorState [filename=" + this.filename + ", charset=" + this.charset + ", text=" + this.text + ", caretPosition=" + this.caretPosition + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.caretPosition;
        n = 31 * n + (this.charset == null ? 0 : this.charset.hashCode());
        n = 31 * n + (this.filename == null ? 0 : this.filename.hashCode());
        n = 31 * n + (this.text == null ? 0 : this.text.hashCode());
        n = 31 * n + (this.watchFileOnDiskChange == null ? 0 : this.watchFileOnDiskChange.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EditorState editorState = (EditorState)object;
        if (this.caretPosition != editorState.caretPosition) {
            return false;
        }
        if (this.charset != editorState.charset) {
            return false;
        }
        if (this.filename == null ? editorState.filename != null : !this.filename.equals(editorState.filename)) {
            return false;
        }
        if (this.text == null ? editorState.text != null : !this.text.equals(editorState.text)) {
            return false;
        }
        return !(this.watchFileOnDiskChange == null ? editorState.watchFileOnDiskChange != null : !this.watchFileOnDiskChange.equals(editorState.watchFileOnDiskChange));
    }
}

