/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tables;

import de.duehl.swing.ui.colors.ColorTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DifferentBackgroundsTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public static final float FONT_SIZE = 15.0f;
    private final Color lighterForeground;
    private final Color lighterBackground;
    private final Color darkerForeground;
    private final Color darkerBackground;
    private boolean useSwitchedColorsForSelection;

    public DifferentBackgroundsTableRenderer(Color color, Color color2) {
        this.lighterForeground = ColorTool.calculateLighterColor(color);
        this.lighterBackground = ColorTool.calculateLighterColor(color2);
        this.darkerForeground = ColorTool.calculateDarkerColor(color);
        this.darkerBackground = ColorTool.calculateDarkerColor(color2);
        this.useSwitchedColorsForSelection = true;
    }

    public void doNotUseSwitchedColorsForSelection() {
        this.useSwitchedColorsForSelection = false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(15.0f));
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        boolean bl3 = n % 2 == 0;
        Color color2 = bl3 ? this.lighterForeground : this.darkerForeground;
        Color color3 = color = bl3 ? this.lighterBackground : this.darkerBackground;
        if (bl && this.useSwitchedColorsForSelection) {
            this.setForeground(color);
            this.setBackground(color2);
        } else {
            this.setForeground(color2);
            this.setBackground(color);
        }
        return jLabel;
    }
}

