/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.sort;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import java.util.List;

public class KanjiRelevanceWeightingCalculator {
    private static final int WEIGHTENING_GERMAN_MEANING_PART_EQUALS_SEARCH = 1;
    private static final int WEIGHTENING_ON_LESUNG_MEANING_EQUALS_SEARCH = 2;
    private static final int WEIGHTENING_KUN_LESUNG_MEANING_EQUALS_SEARCH = 3;
    private static final int WEIGHTENING_LOWERED_GERMAN_MEANING_PART_EQUALS_LOWERED_SEARCH = 11;
    private static final int WEIGHTENING_LOWERED_ON_LESUNG_EQUALS_LOWERED_SEARCH = 12;
    private static final int WEIGHTENING_LOWERED_KUN_LESUNG_EQUALS_LOWERED_SEARCH = 13;
    private static final int WEIGHTENING_GERMAN_MEANING_PART_STARTS_WITH_SEARCH = 21;
    private static final int WEIGHTENING_ON_LESUNG_STARTS_WITH_SEARCH = 22;
    private static final int WEIGHTENING_KUN_LESUNG_STARTS_WITH_SEARCH = 23;
    private static final int WEIGHTENING_LOWERED_GERMAN_MEANING_PART_STARTS_WITH_LOWERED_SEARCH = 31;
    private static final int WEIGHTENING_LOWERED_ON_LESUNG_STARTS_WITH_LOWERED_SEARCH = 32;
    private static final int WEIGHTENING_LOWERED_KUN_LESUNG_STARTS_WITH_LOWERED_SEARCH = 33;
    private static final int WEIGHTENING_GERMAN_MEANING_PART_ENDS_WITH_SEARCH = 41;
    private static final int WEIGHTENING_ON_LESUNG_ENDS_WITH_SEARCH = 42;
    private static final int WEIGHTENING_KUN_LESUNG_ENDS_WITH_SEARCH = 43;
    private static final int WEIGHTENING_LOWERED_GERMAN_MEANING_PART_ENDS_WITH_LOWERED_SEARCH = 51;
    private static final int WEIGHTENING_LOWERED_ON_LESUNG_ENDS_WITH_LOWERED_SEARCH = 52;
    private static final int WEIGHTENING_LOWERED_KUN_LESUNG_ENDS_WITH_LOWERED_SEARCH = 53;
    private static final int WEIGHTENING_GERMAN_MEANING_PART_CONTAINS_SEARCH_AS_SINGLE_WORD = 61;
    private static final int WEIGHTENING_ON_LESUNG_CONTAINS_SEARCH_AS_SINGLE_WORD = 62;
    private static final int WEIGHTENING_KUN_LESUNG_CONTAINS_SEARCH_AS_SINGLE_WORD = 63;
    private static final int WEIGHTENING_LOWERED_GERMAN_MEANING_PART_CONTAINS_LOWERED_SEARCH_AS_SINGLE_WORD = 71;
    private static final int WEIGHTENING_LOWERED_ON_LESUNG_CONTAINS_LOWERED_SEARCH_AS_SINGLE_WORD = 72;
    private static final int WEIGHTENING_LOWERED_KUN_LESUNG_CONTAINS_LOWERED_SEARCH_AS_SINGLE_WORD = 73;
    private static final int NO_SPECIAL_WEIGHTENING = 999;
    private final List<String> germanMeaningParts;
    private final List<String> loweredGermanMeaningParts;
    private List<String> onLesungen;
    private List<String> loweredOnLesungen;
    private List<String> kunLesungen;
    private List<String> loweredKunLesungen;
    private final String search;
    private String loweredCaseSearch;
    private int weighting;
    private boolean weighteningFound;

    public KanjiRelevanceWeightingCalculator(Kanji kanji, String string) {
        this.search = string;
        this.loweredCaseSearch = Text.toLowerCase(string);
        this.germanMeaningParts = Text.splitByKomma(kanji.getGermanMeaning());
        this.loweredGermanMeaningParts = Text.toLowerCase(this.germanMeaningParts);
        this.onLesungen = kanji.getOnLesungen();
        this.loweredOnLesungen = Text.toLowerCase(this.onLesungen);
        this.kunLesungen = kanji.getKunLesungen();
        this.loweredKunLesungen = Text.toLowerCase(this.kunLesungen);
    }

    public void calculate() {
        this.init();
        this.checkIfEqualsSearch();
        this.checkIfLoweredEqualsLoweredSearch();
        this.checkIfStartsWithSearch();
        this.checkIfLoweredStartsWithLoweredSearch();
        this.checkIfEndsWithSearch();
        this.checkIfLoweredEndsWithLoweredSearch();
        this.checkIfContainsSearchAsSingleWord();
        this.checkIfContainsLoweredSearchAsLoweredSingleWord();
    }

    private void init() {
        this.weighteningFound = false;
        this.weighting = 999;
    }

    private void checkIfEqualsSearch() {
        if (!this.weighteningFound) {
            this.checkIfGermanMeaningEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfOnLesungEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKunLesungEqualsSearch();
        }
    }

    private void checkIfGermanMeaningEqualsSearch() {
        this.checkIfListElementEqualsSearch(this.germanMeaningParts, 1);
    }

    private void checkIfOnLesungEqualsSearch() {
        this.checkIfListElementEqualsSearch(this.onLesungen, 2);
    }

    private void checkIfKunLesungEqualsSearch() {
        this.checkIfListElementEqualsSearch(this.kunLesungen, 3);
    }

    private void checkIfLoweredEqualsLoweredSearch() {
        if (!this.weighteningFound) {
            this.checkIfLoweredGermanMeaningEqualsLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredOnLesungEqualsLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredKunLesungEqualsLoweredSearch();
        }
    }

    private void checkIfLoweredGermanMeaningEqualsLoweredSearch() {
        this.checkIfListElementEqualsLoweredSearch(this.loweredGermanMeaningParts, 11);
    }

    private void checkIfLoweredOnLesungEqualsLoweredSearch() {
        this.checkIfListElementEqualsLoweredSearch(this.loweredOnLesungen, 12);
    }

    private void checkIfLoweredKunLesungEqualsLoweredSearch() {
        this.checkIfListElementEqualsLoweredSearch(this.loweredKunLesungen, 13);
    }

    private void checkIfStartsWithSearch() {
        if (!this.weighteningFound) {
            this.checkIfGermanMeaningStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfOnLesungStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKunLesungStartsWithSearch();
        }
    }

    private void checkIfGermanMeaningStartsWithSearch() {
        this.checkIfListElementStartsWithSearch(this.germanMeaningParts, 21);
    }

    private void checkIfOnLesungStartsWithSearch() {
        this.checkIfListElementStartsWithSearch(this.onLesungen, 22);
    }

    private void checkIfKunLesungStartsWithSearch() {
        this.checkIfListElementStartsWithSearch(this.kunLesungen, 23);
    }

    private void checkIfLoweredStartsWithLoweredSearch() {
        if (!this.weighteningFound) {
            this.checkIfLoweredGermanMeaningStartsWithLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredOnLesungStartsWithLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredKunLesungStartsWithLoweredSearch();
        }
    }

    private void checkIfLoweredGermanMeaningStartsWithLoweredSearch() {
        this.checkIfListElementStartsWithLoweredSearch(this.loweredGermanMeaningParts, 31);
    }

    private void checkIfLoweredOnLesungStartsWithLoweredSearch() {
        this.checkIfListElementStartsWithLoweredSearch(this.loweredOnLesungen, 32);
    }

    private void checkIfLoweredKunLesungStartsWithLoweredSearch() {
        this.checkIfListElementStartsWithLoweredSearch(this.loweredKunLesungen, 33);
    }

    private void checkIfEndsWithSearch() {
        if (!this.weighteningFound) {
            this.checkIfGermanMeaningEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfOnLesungEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKunLesungEndsWithSearch();
        }
    }

    private void checkIfGermanMeaningEndsWithSearch() {
        this.checkIfListElementEndsWithSearch(this.germanMeaningParts, 41);
    }

    private void checkIfOnLesungEndsWithSearch() {
        this.checkIfListElementEndsWithSearch(this.onLesungen, 42);
    }

    private void checkIfKunLesungEndsWithSearch() {
        this.checkIfListElementEndsWithSearch(this.kunLesungen, 43);
    }

    private void checkIfLoweredEndsWithLoweredSearch() {
        if (!this.weighteningFound) {
            this.checkIfLoweredGermanMeaningEndsWithLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredOnLesungEndsWithLoweredSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredKunLesungEndsWithLoweredSearch();
        }
    }

    private void checkIfLoweredGermanMeaningEndsWithLoweredSearch() {
        this.checkIfListElementEndsWithLoweredSearch(this.loweredGermanMeaningParts, 51);
    }

    private void checkIfLoweredOnLesungEndsWithLoweredSearch() {
        this.checkIfListElementEndsWithLoweredSearch(this.loweredOnLesungen, 52);
    }

    private void checkIfLoweredKunLesungEndsWithLoweredSearch() {
        this.checkIfListElementEndsWithLoweredSearch(this.loweredKunLesungen, 53);
    }

    private void checkIfContainsSearchAsSingleWord() {
        if (!this.weighteningFound) {
            this.checkIfGermanMeaningContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfOnLesungContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfKunLesungContainsSearchAsSingleWord();
        }
    }

    private void checkIfGermanMeaningContainsSearchAsSingleWord() {
        this.checkIfListElementContainsSearchAsSingleWord(this.loweredGermanMeaningParts, 61);
    }

    private void checkIfOnLesungContainsSearchAsSingleWord() {
        this.checkIfListElementContainsSearchAsSingleWord(this.onLesungen, 62);
    }

    private void checkIfKunLesungContainsSearchAsSingleWord() {
        this.checkIfListElementContainsSearchAsSingleWord(this.kunLesungen, 63);
    }

    private void checkIfContainsLoweredSearchAsLoweredSingleWord() {
        if (!this.weighteningFound) {
            this.checkIfLoweredGermanMeaningContainsSearchAsLoweredSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredOnLesungContainsSearchAsLoweredSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfLoweredKunLesungContainsSearchAsLoweredSingleWord();
        }
    }

    private void checkIfLoweredGermanMeaningContainsSearchAsLoweredSingleWord() {
        this.checkIfListElementContainsLoweredSearchAsSingleWord(this.loweredGermanMeaningParts, 71);
    }

    private void checkIfLoweredOnLesungContainsSearchAsLoweredSingleWord() {
        this.checkIfListElementContainsLoweredSearchAsSingleWord(this.loweredOnLesungen, 72);
    }

    private void checkIfLoweredKunLesungContainsSearchAsLoweredSingleWord() {
        this.checkIfListElementContainsLoweredSearchAsSingleWord(this.loweredKunLesungen, 73);
    }

    private void checkIfListElementEqualsSearch(List<String> list, int n) {
        this.checkIfListEquals(list, n, this.search);
    }

    private void checkIfListElementEqualsLoweredSearch(List<String> list, int n) {
        this.checkIfListEquals(list, n, this.loweredCaseSearch);
    }

    private void checkIfListEquals(List<String> list, int n, String string) {
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            this.weighteningFound = true;
            this.weighting = n;
            return;
        }
    }

    private void checkIfListElementStartsWithSearch(List<String> list, int n) {
        this.checkIfListStartsWith(list, n, this.search);
    }

    private void checkIfListElementStartsWithLoweredSearch(List<String> list, int n) {
        this.checkIfListStartsWith(list, n, this.loweredCaseSearch);
    }

    private void checkIfListStartsWith(List<String> list, int n, String string) {
        for (String string2 : list) {
            if (!string2.startsWith(string)) continue;
            this.weighteningFound = true;
            this.weighting = n;
            return;
        }
    }

    private void checkIfListElementEndsWithSearch(List<String> list, int n) {
        this.checkIfListEndsWith(list, n, this.search);
    }

    private void checkIfListElementEndsWithLoweredSearch(List<String> list, int n) {
        this.checkIfListEndsWith(list, n, this.loweredCaseSearch);
    }

    private void checkIfListEndsWith(List<String> list, int n, String string) {
        for (String string2 : list) {
            if (!string2.endsWith(string)) continue;
            this.weighteningFound = true;
            this.weighting = n;
            return;
        }
    }

    private void checkIfListElementContainsSearchAsSingleWord(List<String> list, int n) {
        this.checkIfListContainsAsSingleWord(list, n, this.search);
    }

    private void checkIfListElementContainsLoweredSearchAsSingleWord(List<String> list, int n) {
        this.checkIfListContainsAsSingleWord(list, n, this.loweredCaseSearch);
    }

    private void checkIfListContainsAsSingleWord(List<String> list, int n, String string) {
        for (String string2 : list) {
            if (!string2.contains(" " + string + " ")) continue;
            this.weighteningFound = true;
            this.weighting = n;
            return;
        }
    }

    public int getWeighting() {
        return this.weighting;
    }
}

