/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.test;

import de.duehl.math.stochastic.RandomSampleWithoutPutBack;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.HiraganaForTestSelectionMethod;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.HiraganaTestParameterChooser;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.HiraganaTester;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HiraganaTesterLogic {
    private static final boolean DEBUG = false;
    private final Options options;
    private final InternalKanaDataRequester requester;
    private final Point parentLocation;
    private final Image programImage;
    private boolean goAhead;
    private List<Hiragana> hiraganaList;
    private int numberOfHiraganaToTest;
    private boolean useOriginalHiraganaOrder;
    private List<Hiragana> hiraganaToTest;
    private HiraganaForTestSelectionMethod selectionMethod;
    private List<Hiragana> notTenTimesGoodTestedHiraganaList;

    public HiraganaTesterLogic(Options options, InternalKanaDataRequester internalKanaDataRequester, Point point, Image image) {
        this.options = options;
        this.requester = internalKanaDataRequester;
        this.parentLocation = point;
        this.programImage = image;
    }

    public void test() {
        this.init();
        if (this.goAhead) {
            this.askTestParameters();
        }
        if (this.goAhead) {
            this.determineHiraganaToTest();
        }
        if (this.goAhead) {
            this.startRealTest();
        }
    }

    private void init() {
        this.goAhead = true;
        this.determineNotTenTimesGoodTestedHiraganaList();
    }

    private void determineNotTenTimesGoodTestedHiraganaList() {
        this.notTenTimesGoodTestedHiraganaList = new ArrayList<Hiragana>();
        for (Hiragana hiragana : Hiragana.values()) {
            InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForHiragana(hiragana);
            if (internalAdditionalKanaData.getLastCorrectTestsCount() >= 10) continue;
            this.notTenTimesGoodTestedHiraganaList.add(hiragana);
        }
    }

    private void askTestParameters() {
        HiraganaTestParameterChooser hiraganaTestParameterChooser = new HiraganaTestParameterChooser(this.notTenTimesGoodTestedHiraganaList, this.parentLocation, this.programImage);
        hiraganaTestParameterChooser.setVisible(true);
        if (hiraganaTestParameterChooser.isApplied()) {
            this.hiraganaList = hiraganaTestParameterChooser.getHiraganaList();
            this.numberOfHiraganaToTest = hiraganaTestParameterChooser.getNumberOfHiraganaToTest();
            this.useOriginalHiraganaOrder = hiraganaTestParameterChooser.isUseOriginalHiraganaOrder();
            this.selectionMethod = hiraganaTestParameterChooser.getSelectionMethod();
            if (this.hiraganaList.isEmpty()) {
                String string = "Leer Menge an Hiragana ausgew\u00e4hlt";
                String string2 = "Sie haben eine leere Menge an abzufragenden Hiragana ausgew\u00e4hlt, daher ist nichts abzufragen.";
                GuiTools.informUser(string, string2);
                this.goAhead = false;
            }
        } else {
            this.goAhead = false;
        }
    }

    private void determineHiraganaToTest() {
        switch (this.selectionMethod) {
            case RANDOM_BY_NUMBER: {
                this.determineHiraganaToTestByRandomNumber();
                return;
            }
            case ALL: {
                this.useAllHiragana();
                return;
            }
            case LAST_N: {
                this.useLastNHiragana();
                return;
            }
            case NOT_TEN_TIMES_GOOD_TESTED: {
                this.useNotTenTimesGoodTestedHiraganaList();
                return;
            }
        }
        this.goAhead = false;
    }

    private void determineHiraganaToTestByRandomNumber() {
        List<Integer> list = this.createHiraganaPositionSample();
        this.fillHiraganaToTestWithHiraganaPositionSample(list);
    }

    private List<Integer> createHiraganaPositionSample() {
        int n = 1;
        int n2 = this.hiraganaList.size();
        int n3 = Math.min(this.hiraganaList.size(), this.numberOfHiraganaToTest);
        RandomSampleWithoutPutBack randomSampleWithoutPutBack = new RandomSampleWithoutPutBack(n, n2, n3);
        randomSampleWithoutPutBack.drawSample();
        List<Integer> list = randomSampleWithoutPutBack.getSample();
        if (this.useOriginalHiraganaOrder) {
            Collections.sort(list);
        }
        return list;
    }

    private void fillHiraganaToTestWithHiraganaPositionSample(List<Integer> list) {
        this.hiraganaToTest = new ArrayList<Hiragana>();
        for (int n : list) {
            int n2 = n - 1;
            Hiragana hiragana = this.hiraganaList.get(n2);
            this.hiraganaToTest.add(hiragana);
        }
    }

    private void useAllHiragana() {
        this.hiraganaToTest = new ArrayList<Hiragana>();
        this.hiraganaToTest.addAll(this.hiraganaList);
        if (!this.useOriginalHiraganaOrder) {
            Collections.shuffle(this.hiraganaToTest);
        }
    }

    private void useLastNHiragana() {
        int n;
        this.hiraganaToTest = new ArrayList<Hiragana>();
        int n2 = this.hiraganaList.size();
        for (int i = n = Math.max(0, n2 - this.numberOfHiraganaToTest); i <= n2 - 1; ++i) {
            Hiragana hiragana = this.hiraganaList.get(i);
            this.hiraganaToTest.add(hiragana);
        }
        if (!this.useOriginalHiraganaOrder) {
            Collections.shuffle(this.hiraganaToTest);
        }
    }

    private void useNotTenTimesGoodTestedHiraganaList() {
        this.hiraganaToTest = new ArrayList<Hiragana>();
        this.hiraganaToTest.addAll(this.notTenTimesGoodTestedHiraganaList);
        if (!this.useOriginalHiraganaOrder) {
            Collections.shuffle(this.hiraganaToTest);
        }
    }

    private void startRealTest() {
        HiraganaTester hiraganaTester = new HiraganaTester(this.hiraganaToTest, this.options, this.requester, this.parentLocation, this.programImage);
        hiraganaTester.setVisible(true);
    }
}

