/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.statistics;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.success.VocabularyTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.statistics.data.VocableCounterPicker;
import de.duehl.vocabulary.japanese.statistics.data.VocableListPicker;
import de.duehl.vocabulary.japanese.statistics.data.VocableWithCounter;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.text.KanjiAndKanaTextCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VocabularyTrainerStatisticCreator {
    private final Options options;
    private final InternalDataRequester requester;
    private final List<Vocabulary> vocabularies;
    private List<String> categories;
    private List<String> subCategories;
    private Map<String, List<Vocabulary>> vocabulariesByCategory;
    private SwingHtmlBuilder html;
    private final List<Vocable> allVocables;
    private static final int NUMBER_OF_OFTEN_TESTED_VOCABLES = 20;

    public VocabularyTrainerStatisticCreator(VocabularyTrainerLogic vocabularyTrainerLogic) {
        this.options = vocabularyTrainerLogic.getOptions();
        this.requester = vocabularyTrainerLogic.getInternalDataRequester();
        this.vocabularies = vocabularyTrainerLogic.getVocabularies();
        this.allVocables = this.getAllVocablesOfAllVocabularies();
    }

    private List<Vocable> getAllVocablesOfAllVocabularies() {
        return this.getAllVocablesOfAllVocabularies(this.vocabularies);
    }

    private List<Vocable> getAllVocablesOfAllVocabularies(List<Vocabulary> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : list) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    public String createStatisticReport() {
        this.createStatisticsInternal();
        return this.html.toString();
    }

    private void createStatisticsInternal() {
        this.initHtml();
        this.determineCategories();
        this.determineSubCategories();
        this.separateVocabulariesByCategory();
        this.createStatisticForAllVocables();
        this.createStatisticForAllCategories();
        this.createStatisticForAllCategoriesAndSubCategories();
        this.createStatisticForSearchWords();
        this.createStatisticForPartsOfSpeach();
        this.createStatisticForMostTestedEtc();
        this.finalizeHtml();
    }

    private void initHtml() {
        this.html = new SwingHtmlBuilder().appendHtml5HeadWithOwnExtendedCssUtf8("Statstik", "h2, h3 {\n    margin-bottom:12;\n    margin-top:25;\n}".indent(4)).appendTopLinksToH2();
        this.html.appendP("&nbsp;");
        this.html.appendH1("Statistik");
    }

    private void determineCategories() {
        this.categories = VocabularyTools.determineCategories(this.vocabularies);
    }

    private void determineSubCategories() {
        this.subCategories = VocabularyTools.determineSubCategories(this.vocabularies);
    }

    private void separateVocabulariesByCategory() {
        this.vocabulariesByCategory = new HashMap<String, List<Vocabulary>>();
        for (Vocabulary vocabulary : this.vocabularies) {
            String string = vocabulary.getCategory();
            if (!this.vocabulariesByCategory.containsKey(string)) {
                this.vocabulariesByCategory.put(string, new ArrayList());
            }
            List<Vocabulary> list = this.vocabulariesByCategory.get(string);
            list.add(vocabulary);
        }
    }

    private void createStatisticForAllVocables() {
        this.html.appendH2("Alle Vokabeln");
        String string = NumberString.taupu(this.categories.size());
        String string2 = NumberString.taupu(this.subCategories.size());
        String string3 = NumberString.taupu(this.allVocables.size());
        String string4 = this.calculatePercent(this.allVocables);
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Kategorien");
        this.html.appendRightAlignedTd(string);
        this.html.appendClosingTr();
        this.html.appendLeftAlignedTh("Anzahl Unterkategorien");
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTd(string3);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen aller Vokabeln");
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
        this.html.appendClosingTable();
        this.html.appendH3("\u00dcbersicht \u00fcber die Kategorien");
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Kategorie");
        this.html.appendRightAlignedTh("Anzahl Vokabulare");
        this.html.appendRightAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendClosingTr();
        for (String string5 : this.categories) {
            this.createStatisticRowForCategory(string5);
        }
        this.html.appendClosingTable();
    }

    private void createStatisticRowForCategory(String string) {
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<Vocable> list2 = this.getAllVocablesOfAllVocabularies(list);
        String string2 = NumberString.taupu(list.size());
        String string3 = NumberString.taupu(list2.size());
        String string4 = this.calculatePercent(list2);
        this.html.appendOpeningTr();
        this.html.appendTd(string);
        this.html.appendRightAlignedTd(string2);
        this.html.appendRightAlignedTd(string3);
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
    }

    private String calculatePercent(List<Vocable> list) {
        VocabularyTestSuccesssCalculator vocabularyTestSuccesssCalculator = new VocabularyTestSuccesssCalculator(list, this.options, this.requester);
        vocabularyTestSuccesssCalculator.calculate();
        return vocabularyTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
    }

    private void createStatisticForAllCategories() {
        for (String string : this.categories) {
            this.createStatisticForCategory(string);
        }
    }

    private void createStatisticForCategory(String string) {
        this.html.appendH2("Kategorie " + string);
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<Vocable> list2 = this.getAllVocablesOfAllVocabularies(list);
        String string2 = NumberString.taupu(list.size());
        String string3 = NumberString.taupu(list2.size());
        String string4 = this.calculatePercent(list2);
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabulare");
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTd(string3);
        this.html.appendClosingTr();
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendRightAlignedTd(string4);
        this.html.appendClosingTr();
        this.html.appendClosingTable();
        this.html.appendH3("Vokabulare");
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Vokabular");
        this.html.appendRightAlignedTh("Anzahl Vokabeln");
        this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
        this.html.appendClosingTr();
        for (Vocabulary vocabulary : list) {
            this.createStatisticRowForVocabulary(vocabulary);
        }
        this.html.appendClosingTable();
    }

    private void createStatisticRowForVocabulary(Vocabulary vocabulary) {
        List<Vocable> list = vocabulary.getVocables();
        String string = NumberString.taupu(list.size());
        String string2 = this.calculatePercent(list);
        this.html.appendOpeningTr();
        this.html.appendTd(vocabulary.getDescription());
        this.html.appendRightAlignedTd(string);
        this.html.appendRightAlignedTd(string2);
        this.html.appendClosingTr();
    }

    private void createStatisticForAllCategoriesAndSubCategories() {
        for (String string : this.categories) {
            this.createStatisticForCategoryAndAllSubCategories(string);
        }
    }

    private void createStatisticForCategoryAndAllSubCategories(String string) {
        this.html.appendH2("Kategorie " + string + " mit Betrachtung der Unterkategorien");
        List<Vocabulary> list = this.vocabulariesByCategory.get(string);
        List<String> list2 = VocabularyTools.determineSubCategoriesOfCategory(list, string);
        for (String string2 : list2) {
            this.html.appendH3("Unterkategorie " + string2);
            List<Vocabulary> list3 = this.determineVocabulariesOfCategoryAndSubCategory(string, string2);
            List<Vocable> list4 = this.getAllVocablesOfAllVocabularies(list3);
            String string3 = NumberString.taupu(list.size());
            String string4 = NumberString.taupu(list4.size());
            String string5 = this.calculatePercent(list4);
            this.html.appendOpeningTableWithBorderWidth(2);
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Anzahl Vokabulare");
            this.html.appendRightAlignedTd(string3);
            this.html.appendClosingTr();
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Anzahl Vokabeln");
            this.html.appendRightAlignedTd(string4);
            this.html.appendClosingTr();
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
            this.html.appendRightAlignedTd(string5);
            this.html.appendClosingTr();
            this.html.appendClosingTable();
            this.html.appendH4("Vokabulare");
            this.html.appendOpeningTableWithBorderWidth(2);
            this.html.appendOpeningTr();
            this.html.appendLeftAlignedTh("Vokabular");
            this.html.appendRightAlignedTh("Anzahl Vokabeln");
            this.html.appendRightAlignedTh("Prozent Erfolg der letzten Abfragen der Vokabeln");
            this.html.appendClosingTr();
            for (Vocabulary vocabulary : list) {
                this.createStatisticRowForVocabulary(vocabulary);
            }
            this.html.appendClosingTable();
        }
    }

    private List<Vocabulary> determineVocabulariesOfCategoryAndSubCategory(String string, String string2) {
        ArrayList<Vocabulary> arrayList = new ArrayList<Vocabulary>();
        for (Vocabulary vocabulary : this.vocabularies) {
            String string3 = vocabulary.getCategory();
            String string4 = vocabulary.getSubCategory();
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            arrayList.add(vocabulary);
        }
        return arrayList;
    }

    private void createStatisticForSearchWords() {
        this.html.appendH2("Suchbegriffe");
        Map<String, Integer> map = this.createCountByWordMap(vocable -> vocable.getSearchWords());
        int n = this.countMissing(vocable -> vocable.getSearchWords());
        this.createCountByWordHtml("Suchbegriff", map, n);
    }

    private void createStatisticForPartsOfSpeach() {
        this.html.appendH2("Wortarten");
        Map<String, Integer> map = this.createCountByWordMap(vocable -> vocable.getPartsOfSpeech());
        int n = this.countMissing(vocable -> vocable.getPartsOfSpeech());
        this.createCountByWordHtml("Wortart", map, n);
    }

    private Map<String, Integer> createCountByWordMap(VocableListPicker vocableListPicker) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Vocable vocable : this.allVocables) {
            List<String> list = vocableListPicker.pickWordList(vocable);
            for (String string : list) {
                if (string.isBlank()) continue;
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, 0);
                }
                int n = (Integer)hashMap.get(string);
                hashMap.put(string, ++n);
            }
        }
        return hashMap;
    }

    private int countMissing(VocableListPicker vocableListPicker) {
        int n = 0;
        for (Vocable vocable : this.allVocables) {
            List<String> list = vocableListPicker.pickWordList(vocable);
            if (!list.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    private void createCountByWordHtml(String string, Map<String, Integer> map, int n) {
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh(string);
        this.html.appendRightAlignedTd("Anzahl");
        this.html.appendClosingTr();
        for (String string2 : CollectionsHelper.getSortedMapStringIndices(map)) {
            this.html.appendOpeningTr();
            this.html.appendTd(string2);
            this.html.appendRightAlignedTd(NumberString.taupu(map.get(string2)));
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
        this.html.appendP("Vokabeln ohne " + string + ": " + NumberString.taupu(n) + " (" + NumberString.percent(n, this.allVocables.size()) + "%)");
    }

    private void createStatisticForMostTestedEtc() {
        this.html.appendH2("H\u00e4ufig abgefragte Vokabeln");
        this.createCountTestSum();
        this.createStatisticForOftenUsedVocables(this.determineOftenJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyJapaneseToGermanTestedVocables(), "Am seltesten abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenCorrectJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten richtig abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyCorrectJapaneseToGermanTestedVocables(), "Am seltensten richtig abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenWrongJapaneseToGermanTestedVocables(), "Am h\u00e4ufigsten falsch abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyWrongJapaneseToGermanTestedVocables(), "Am seltensten falsch abgefragte Vokabeln Japanisch-Deutsch");
        this.createStatisticForOftenUsedVocables(this.determineOftenGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyGermanToJapaneseTestedVocables(), "Am seltesten abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineOftenCorrectGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten richtig abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyCorrectGermanToJapaneseTestedVocables(), "Am seltensten richtig abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineOftenWrongGermanToJapaneseTestedVocables(), "Am h\u00e4ufigsten falsch abgefragte Vokabeln Deutsch-Japanisch");
        this.createStatisticForOftenUsedVocables(this.determineRarelyWrongGermanToJapaneseTestedVocables(), "Am seltensten falsch abgefragte Vokabeln Deutsch-Japanisch");
    }

    private void createCountTestSum() {
        int n = 0;
        int n2 = 0;
        for (Vocable vocable : this.allVocables) {
            InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
            n += internalAdditionalVocableData.getJapaneseToGermanTestCount();
            n2 += internalAdditionalVocableData.getGermanToJapaneseTestCount();
        }
        this.html.appendH3("Wie oft wurden Vokabeln abgefragt");
        this.html.appendP("Es wurde " + NumberString.taupu(n) + " mal eine einzelne Vokabel von Japanisch nach Deutsch abgefragt.");
        this.html.appendP("Es wurde " + NumberString.taupu(n2) + " mal eine einzelne Vokabel von Deutsch nach Japanisch abgefragt.");
        this.html.appendP("Summe: Es wurde " + NumberString.taupu(n + n2) + " mal eine einzelne Vokabel abgefragt.");
    }

    private List<VocableWithCounter> determineOftenJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenJapaneseToGermanTested(vocable));
    }

    private int howOftenJapaneseToGermanTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenCorrectJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenCorrectJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyCorrectJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenCorrectJapaneseToGermanTested(vocable));
    }

    private int howOftenCorrectJapaneseToGermanTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenWrongJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenWrongJapaneseToGermanTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyWrongJapaneseToGermanTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenWrongJapaneseToGermanTested(vocable));
    }

    private int howOftenWrongJapaneseToGermanTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getJapaneseToGermanTestCount() - internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
    }

    private List<VocableWithCounter> determineOftenGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenGermanToJapaneseTested(vocable));
    }

    private int howOftenGermanToJapaneseTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenCorrectGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenCorrectGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyCorrectGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenCorrectGermanToJapaneseTested(vocable));
    }

    private int howOftenCorrectGermanToJapaneseTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenWrongGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesHighest(vocable -> this.howOftenWrongGermanToJapaneseTested(vocable));
    }

    private List<VocableWithCounter> determineRarelyWrongGermanToJapaneseTestedVocables() {
        return this.determineOftenTestedVocablesLowest(vocable -> this.howOftenWrongGermanToJapaneseTested(vocable));
    }

    private int howOftenWrongGermanToJapaneseTested(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        return internalAdditionalVocableData.getGermanToJapaneseTestCount() - internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
    }

    private List<VocableWithCounter> determineOftenTestedVocablesHighest(VocableCounterPicker vocableCounterPicker) {
        return this.determineOftenTestedVocables(vocableCounterPicker, true);
    }

    private List<VocableWithCounter> determineOftenTestedVocablesLowest(VocableCounterPicker vocableCounterPicker) {
        return this.determineOftenTestedVocables(vocableCounterPicker, false);
    }

    private List<VocableWithCounter> determineOftenTestedVocables(VocableCounterPicker vocableCounterPicker, final boolean bl) {
        ArrayList<VocableWithCounter> arrayList = new ArrayList<VocableWithCounter>();
        for (Vocable vocable : this.allVocables) {
            int n = vocableCounterPicker.pickCounter(vocable);
            VocableWithCounter vocableWithCounter = new VocableWithCounter(vocable, n);
            arrayList.add(vocableWithCounter);
        }
        Collections.sort(arrayList, new Comparator<VocableWithCounter>(){

            @Override
            public int compare(VocableWithCounter vocableWithCounter, VocableWithCounter vocableWithCounter2) {
                int n = vocableWithCounter.getCount();
                int n2 = vocableWithCounter2.getCount();
                if (bl) {
                    return n2 - n;
                }
                return n - n2;
            }
        });
        int n = Math.min(20, arrayList.size());
        arrayList = CollectionsHelper.sublist(arrayList, 0, n);
        return arrayList;
    }

    private void createStatisticForOftenUsedVocables(List<VocableWithCounter> list, String string) {
        this.html.appendH3(string);
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Vokabel");
        this.html.appendRightAlignedTd("Anzahl");
        this.html.appendClosingTr();
        for (VocableWithCounter vocableWithCounter : list) {
            Vocable vocable = vocableWithCounter.getVocable();
            int n = vocableWithCounter.getCount();
            String string2 = this.createVocableText(vocable);
            this.html.appendOpeningTr();
            this.html.appendTd(string2);
            this.html.appendRightAlignedTd(NumberString.taupu(n));
            this.html.appendClosingTr();
        }
        this.html.appendClosingTable();
    }

    private String createVocableText(Vocable vocable) {
        String string = vocable.getRomaji();
        String string2 = vocable.getTranslations().get(0);
        boolean bl = true;
        boolean bl2 = true;
        KanjiAndKanaTextCreator kanjiAndKanaTextCreator = new KanjiAndKanaTextCreator(vocable, bl, bl2);
        kanjiAndKanaTextCreator.create();
        String string3 = kanjiAndKanaTextCreator.getFirstTextPart();
        String string4 = kanjiAndKanaTextCreator.getTextPartInBrace();
        boolean bl3 = kanjiAndKanaTextCreator.isBraceInOwnLine();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        if (bl3) {
            stringBuilder.append("<br>");
        }
        if (!string4.isBlank()) {
            stringBuilder.append(" (");
            stringBuilder.append(string4);
            stringBuilder.append(")");
        }
        if (bl3) {
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append(" - ");
        }
        stringBuilder.append(string);
        if (bl3) {
            stringBuilder.append("<br>");
        } else {
            stringBuilder.append(" - ");
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void finalizeHtml() {
        this.html.appendFoot();
        this.html.insertContentWithTopLinkAnker();
    }
}

