/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.buttons.painted.GoButton;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.display.KanjiAndKanaDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.RomajiAndPronunciationDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.TranslationCommentAndVocabularyDescriptionDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class VocableViewer {
    private final Options options;
    private final JPanel panel;
    private final JTextPane kanjiAndKanaPane;
    private final JTextPane romajiAndPronunciationPane;
    private final JTextPane translationCommentAndVocabularyDescriptionPane;
    private final GoButton playMp3Button;
    private Vocable vocable;
    private boolean showAllTranslationsForUseInDetailsDialog;

    public VocableViewer(Options options) {
        this.options = options;
        this.panel = new JPanel();
        this.kanjiAndKanaPane = new JTextPane();
        this.romajiAndPronunciationPane = new JTextPane();
        this.translationCommentAndVocabularyDescriptionPane = new JTextPane();
        this.playMp3Button = new GoButton();
        this.showAllTranslationsForUseInDetailsDialog = false;
        this.initSelections();
        this.createPanel();
    }

    private void initSelections() {
        this.playMp3Button.addActionListener(actionEvent -> this.playMp3());
        this.playMp3Button.setForceSquare(true);
        this.playMp3Button.setPreferredSize(new Dimension(50, 50));
    }

    private void createPanel() {
        this.panel.setLayout(new VerticalLayout(0, 3));
        this.panel.add(this.createKanjiKanaAndMp3PlayButtonArea());
        this.panel.add(this.romajiAndPronunciationPane);
        this.panel.add(this.translationCommentAndVocabularyDescriptionPane);
    }

    private Component createKanjiKanaAndMp3PlayButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.kanjiAndKanaPane, "Center");
        jPanel.add((Component)this.playMp3Button, "East");
        return jPanel;
    }

    public void showAllTranslationsForUseInDetailsDialog() {
        this.showAllTranslationsForUseInDetailsDialog = true;
    }

    public void showVocable(Vocable vocable, InternalAdditionalVocableData internalAdditionalVocableData) {
        this.vocable = vocable;
        VocableColors vocableColors = new VocableColors(this.options);
        Color color = vocableColors.determineBackgroundColor(internalAdditionalVocableData, this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable(), this.options.getTranslationDirection());
        KanjiAndKanaDisplay kanjiAndKanaDisplay = new KanjiAndKanaDisplay(vocable, this.kanjiAndKanaPane, color, this.options);
        kanjiAndKanaDisplay.display();
        this.playMp3Button.setBackgroundColor(color);
        RomajiAndPronunciationDisplay romajiAndPronunciationDisplay = new RomajiAndPronunciationDisplay(vocable, this.romajiAndPronunciationPane, color, this.options);
        romajiAndPronunciationDisplay.display();
        TranslationCommentAndVocabularyDescriptionDisplay translationCommentAndVocabularyDescriptionDisplay = new TranslationCommentAndVocabularyDescriptionDisplay(vocable, this.translationCommentAndVocabularyDescriptionPane, color, this.options);
        if (!this.options.isShowAllTranslations() && !this.showAllTranslationsForUseInDetailsDialog) {
            translationCommentAndVocabularyDescriptionDisplay.setNumberOfShownTranslations(this.options.getNumberOfShownTranslations());
        }
        translationCommentAndVocabularyDescriptionDisplay.display();
        String string = vocable.getMp3();
        this.playMp3Button.setEnabled(!string.isBlank() && FileHelper.isFile(string));
        this.panel.repaint();
    }

    public void playMp3() {
        String string = this.vocable.getMp3();
        VocabularyTools.playMp3(string);
    }

    public Component getPanel() {
        return this.panel;
    }
}

