/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.bars;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.move.SwitchableVerticalMoveButtons;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.KanjiSetEditor;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components.KanjiDetailDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KanjiBar
implements VerticalMoveButtonsUser {
    private final Kanji kanji;
    private final Runnable buttonAction;
    private final KanjiSetEditor gui;
    private final InternalKanjiDataRequester kanjiRequester;
    private final Point parentLocation;
    private final Image programImage;
    private final JPanel panel;
    private final JPanel rightPanel;
    private final JLabel kanjiLabel;
    private final JCheckBox selectionCheckBox;
    private final JButton detailsButton;
    private final JButton multifunctionButton;
    private final SwitchableVerticalMoveButtons switchableMoveButtons;

    public KanjiBar(Kanji kanji, Runnable runnable, KanjiSetEditor kanjiSetEditor, InternalKanjiDataRequester internalKanjiDataRequester, Point point, Image image) {
        this.kanji = kanji;
        this.buttonAction = runnable;
        this.gui = kanjiSetEditor;
        this.kanjiRequester = internalKanjiDataRequester;
        this.parentLocation = point;
        this.programImage = image;
        this.panel = new JPanel();
        this.kanjiLabel = new JLabel();
        this.rightPanel = new JPanel();
        this.detailsButton = new JButton();
        this.multifunctionButton = new JButton();
        this.selectionCheckBox = new JCheckBox();
        this.switchableMoveButtons = new SwitchableVerticalMoveButtons(this);
        this.init();
    }

    private void init() {
        this.initKanjiLabel();
        this.initButtons();
        this.initRightPanel();
    }

    private void initKanjiLabel() {
        this.kanjiLabel.setText(this.createKanjiText());
        GuiTools.biggerFont(this.kanjiLabel, 20);
        this.kanjiLabel.setHorizontalAlignment(0);
    }

    private void initButtons() {
        this.initMultifunctionButton();
        this.initDetailsButton();
    }

    private void initMultifunctionButton() {
        this.multifunctionButton.addActionListener(actionEvent -> this.buttonAction.run());
    }

    private void initDetailsButton() {
        this.detailsButton.setText("?");
        this.detailsButton.addActionListener(actionEvent -> this.showKanjiDetails());
    }

    private void showKanjiDetails() {
        KanjiDetailDialog kanjiDetailDialog = new KanjiDetailDialog(this.kanji, this.kanjiRequester, this.parentLocation, this.programImage);
        kanjiDetailDialog.setVisible(true);
    }

    private void initRightPanel() {
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add((Component)this.multifunctionButton, "East");
    }

    public void useButtonAsAddKanjiToList() {
        this.multifunctionButton.setText("hinzuf\u00fcgen");
        this.rightPanel.add((Component)this.selectionCheckBox, "West");
    }

    public void useButtonAsDeletion() {
        this.multifunctionButton.setText("entfernen");
    }

    public void createGui() {
        this.setUpAndDownButtonColorsAndEnabled();
        this.fillPanel();
    }

    public void disable() {
        this.detailsButton.setEnabled(false);
        this.multifunctionButton.setEnabled(false);
        this.selectionCheckBox.setSelected(false);
        this.selectionCheckBox.setEnabled(false);
        this.kanjiLabel.setForeground(Color.LIGHT_GRAY);
    }

    public void enable() {
        this.detailsButton.setEnabled(true);
        this.multifunctionButton.setEnabled(true);
        this.selectionCheckBox.setEnabled(true);
        this.kanjiLabel.setForeground(Color.BLACK);
    }

    @Override
    public boolean canMoveButtonsUserMoveUp() {
        return this.gui.canBarMoveUp(this.kanji);
    }

    @Override
    public boolean canMoveButtonsUserMoveDown() {
        return this.gui.canBarMoveDown(this.kanji);
    }

    @Override
    public void moveMoveButtonsUserToFirst() {
        this.gui.moveBarToFirst(this.kanji);
    }

    @Override
    public void moveMoveButtonsUserUp() {
        this.gui.moveBarUp(this.kanji);
    }

    @Override
    public void moveMoveButtonsUserDown() {
        this.gui.moveBarDown(this.kanji);
    }

    @Override
    public void moveMoveButtonsUserToLast() {
        this.gui.moveBarToLast(this.kanji);
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        this.switchableMoveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        this.panel.add((Component)this.detailsButton, "West");
        this.panel.add((Component)this.kanjiLabel, "Center");
        this.panel.add(this.createButtonPart(), "East");
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.rightPanel, "West");
        jPanel.add((Component)this.switchableMoveButtons.getPanel(), "East");
        return jPanel;
    }

    private String createKanjiText() {
        return this.kanji.getCharacter();
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setSelected(boolean bl) {
        this.selectionCheckBox.setSelected(bl);
    }

    public boolean isSelected() {
        return this.selectionCheckBox.isSelected();
    }

    public void showMoveButtonsOnBars(boolean bl) {
        this.switchableMoveButtons.showMoveButtons(bl);
        this.panel.repaint();
    }
}

