/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ExtraMenuCreation
implements SingleMenuCreation {
    private static final boolean SHOW_SIZE_MENUE_ITEMS = false;
    private final VocabularyTrainerGui gui;

    public ExtraMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Extra");
        jMenu.setMnemonic('e');
        jMenu.add(this.createShowOptionsMenuItem());
        jMenu.add(this.createStatisticsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createToggleColorVocabularyDependingOnLastSuccessMenuItem());
        jMenu.add(this.createToggleShowSuccessPercentInVocabularyBarMenuItem());
        jMenu.add(this.createToggleHideStartOfVocabularyDescriptionMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowSplashLogMenuItem());
        return jMenu;
    }

    private JMenuItem createShowOptionsMenuItem() {
        return new MyMenuItem("Optionen").mnemonic('o').accelerator(116, 0).actionListener(actionEvent -> this.gui.showOptionDialog());
    }

    private JMenuItem createStatisticsMenuItem() {
        return new MyMenuItem("Statistik anzeigen").mnemonic('i').accelerator(119, 128).actionListener(actionEvent -> this.gui.showStatstics());
    }

    private JMenuItem createIncreaseFontSizeMenuItem() {
        return new MyMenuItem("gr\u00f6\u00dfere Schrift").mnemonic('g').accelerator(521, 128).actionListener(actionEvent -> this.gui.increaseFontSize());
    }

    private JMenuItem createStandardFontSizeMenuItem() {
        return new MyMenuItem("Zur\u00fcck zur Standard-Schriftgr\u00f6\u00dfe").mnemonic('s').accelerator(48, 128).actionListener(actionEvent -> this.gui.standardFontSize());
    }

    private JMenuItem createDecreaseFontSizeMenuItem() {
        return new MyMenuItem("kleinere Schrift").mnemonic('k').accelerator(45, 128).actionListener(actionEvent -> this.gui.decreaseFontSize());
    }

    private JMenuItem createIncreaseLabelFontSizeMenuItem() {
        return new MyMenuItem("gr\u00f6\u00dfere \u00dcberschriften").accelerator(521, 512).actionListener(actionEvent -> this.gui.increaseLabelFontSize());
    }

    private JMenuItem createStandardLabelFontSizeMenuItem() {
        return new MyMenuItem("Zur\u00fcck zur Standard-\u00dcberschriftgr\u00f6\u00dfe").accelerator(48, 512).actionListener(actionEvent -> this.gui.standardLabelFontSize());
    }

    private JMenuItem createDecreaseLabelFontSizeMenuItem() {
        return new MyMenuItem("kleinere \u00dcberschriften").accelerator(45, 512).actionListener(actionEvent -> this.gui.decreaseLabelFontSize());
    }

    private JMenuItem createToggleColorVocabularyDependingOnLastSuccessMenuItem() {
        return new MyMenuItem("Ver\u00e4ndert ob die Darstellung der angezeigten Vokabularien abh\u00e4ngig vom Erfolg bei den letzten zehn Abfragen eingef\u00e4rbt werden soll.").accelerator(112, 128).actionListener(actionEvent -> this.gui.toggleColorVocabularyDependingOnLastSuccess());
    }

    private JMenuItem createToggleShowSuccessPercentInVocabularyBarMenuItem() {
        return new MyMenuItem("Ver\u00e4ndert ob der Erfolg bei den letzten zehn Abfragen der Vokabeln eines Vokabulars als Prozentzahl mit angezeigt werden soll.").accelerator(113, 128).actionListener(actionEvent -> this.gui.toggleShowSuccessPercentInVocabularyBar());
    }

    private JMenuItem createToggleHideStartOfVocabularyDescriptionMenuItem() {
        return new MyMenuItem("Ver\u00e4ndert ob der Anfang der Beschreibung der Vokabularien (\"B1_K4_1_\" oder \"X_\") ausgeblendet werden soll.").accelerator(114, 128).actionListener(actionEvent -> this.gui.toggleHideStartOfVocabularyDescription());
    }

    private JMenuItem createShowSplashLogMenuItem() {
        return new MyMenuItem("Zeigt den Text an, der beim Starten des Vokabeltrainers angezeigt wurde...").actionListener(actionEvent -> this.gui.showSplashScreenText());
    }
}

