/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.navigator.list.ListNavigator;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.tools.VocableListShuffler;
import de.duehl.vocabulary.japanese.ui.components.VocableViewer;
import de.duehl.vocabulary.japanese.ui.components.button.OtherViewButtonPanel;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.detail.VocableWithInternaViewer;
import de.duehl.vocabulary.japanese.ui.dialog.detail.addtolist.VocableToOwnListAdderWithChangingVocableGui;
import de.duehl.vocabulary.japanese.ui.dialog.detail.findlists.ListsWithVocableFinderWithChangingVocableGui;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.VerbsAndAdjectivesFinderWithChangingVocableGui;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class CompleteVocabularyViewerDialog
extends NonModalFrameDialogBase
implements ViewButtonPressedReactor {
    private final List<Vocable> vocables;
    private final Options options;
    private final InternalDataRequester requester;
    private final OwnLists ownLists;
    private final MessageSetter messageSetter;
    private final ListNavigator<Vocable> navigator;
    private final VocableViewer vocableViewer;
    private final OtherViewButtonPanel otherViewPanel;
    private final JButton backgroundChangingButton;
    private final InternalKanjiDataRequester kanjiRequester;
    private final ListsWithVocableFinderWithChangingVocableGui listsWithVocableFinderGui;
    private final VocableToOwnListAdderWithChangingVocableGui vocableToOwnListAdderGui;
    private final VerbsAndAdjectivesFinderWithChangingVocableGui verbsAndAdjectivesFinderGui;

    public CompleteVocabularyViewerDialog(List<Vocable> list, String string, InternalDataRequester internalDataRequester, InternalKanjiDataRequester internalKanjiDataRequester, Options options, LongTimeProcessInformer longTimeProcessInformer, OwnLists ownLists, MessageSetter messageSetter, Point point, Image image) {
        super(point, image, CompleteVocabularyViewerDialog.createDialogTitle(options, internalDataRequester, list, string));
        this.addEscapeBehaviour();
        this.vocables = list;
        this.requester = internalDataRequester;
        this.kanjiRequester = internalKanjiDataRequester;
        this.options = options;
        this.ownLists = ownLists;
        this.messageSetter = messageSetter;
        this.vocableViewer = new VocableViewer(options);
        this.navigator = new ListNavigator();
        this.otherViewPanel = new OtherViewButtonPanel(list, this, string, internalDataRequester, options, internalKanjiDataRequester, longTimeProcessInformer, ownLists, messageSetter, point, image);
        this.otherViewPanel.disableEinzeldarstellungButton();
        this.backgroundChangingButton = new JButton();
        this.listsWithVocableFinderGui = new ListsWithVocableFinderWithChangingVocableGui(ownLists, this.getWindowAsComponent(), this.getLocation());
        this.vocableToOwnListAdderGui = new VocableToOwnListAdderWithChangingVocableGui(ownLists, this.getLocation(), this.getProgramImage());
        this.verbsAndAdjectivesFinderGui = new VerbsAndAdjectivesFinderWithChangingVocableGui(options, internalDataRequester, ownLists, internalKanjiDataRequester, messageSetter, this.getLocation(), this.getProgramImage(), this);
        this.init();
        this.fillDialog();
    }

    private static String createDialogTitle(Options options, InternalDataRequester internalDataRequester, List<Vocable> list, String string) {
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(options, internalDataRequester, list, string);
    }

    private void init() {
        this.initNavigator();
        this.initKeyBindings();
        this.initBackgroundChangingButton();
    }

    private void initNavigator() {
        this.navigator.setShowMethod(vocable -> this.showVocable((Vocable)vocable));
        this.navigator.setDataList(this.determineVocablesToUse(this.vocables, this.options));
    }

    private void showVocable(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData = this.requester.getInternalDataForVocable(vocable);
        this.vocableViewer.showVocable(vocable, internalAdditionalVocableData);
        this.listsWithVocableFinderGui.setVocable(vocable);
        this.vocableToOwnListAdderGui.setVocable(vocable);
        this.verbsAndAdjectivesFinderGui.setVocable(vocable);
        this.pack();
    }

    private List<Vocable> determineVocablesToUse(List<Vocable> list, Options options) {
        if (options.isUseTestOrderForViewingVocables()) {
            VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
            VocableListShuffler vocableListShuffler = new VocableListShuffler(options, list, vocablesShuffleType, this.requester);
            vocableListShuffler.shuffle();
            return vocableListShuffler.getVocables();
        }
        return list;
    }

    private void initKeyBindings() {
        this.setKeyBindingPageUp(() -> this.navigator.doClickOnPreviousButton());
        this.setKeyBindingPageDown(() -> this.navigator.doClickOnNextButton());
        this.setKeyBindingLeft(() -> this.navigator.doClickOnPreviousButton());
        this.setKeyBindingRight(() -> this.navigator.doClickOnNextButton());
        this.setKeyBindingCtrlLeft(() -> this.navigator.doClickOnPreviousButton());
        this.setKeyBindingCtrlRight(() -> this.navigator.doClickOnNextButton());
        this.setKeyBindingAltLeft(() -> this.navigator.doClickOnPreviousButton());
        this.setKeyBindingAltRight(() -> this.navigator.doClickOnNextButton());
        this.setKeyBindingF1(() -> this.navigator.doClickOnPreviousButton());
        this.setKeyBindingF2(() -> this.navigator.doClickOnNextButton());
    }

    private void initBackgroundChangingButton() {
        this.setBackgroundChangingButtonTitle();
        this.backgroundChangingButton.addActionListener(actionEvent -> this.toggleBackground());
    }

    private void setBackgroundChangingButtonTitle() {
        String string = "Hintergrund " + (this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable() ? "aus" : "ein") + "schalten";
        this.backgroundChangingButton.setText(string);
    }

    private void toggleBackground() {
        boolean bl = this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable();
        bl = !bl;
        this.options.setColorVocableDependingOnLastSuccessWhenViewingVocable(bl);
        this.setBackgroundChangingButtonTitle();
        Vocable vocable = this.navigator.getActualDataSet();
        this.showVocable(vocable);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        this.keybindingsForDetailDialog();
        this.keybindingsForPlaySound();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createCenteredNavigatorPanel(), "North");
        jPanel.add(this.createVocabularyPart(), "Center");
        return jPanel;
    }

    private Component createCenteredNavigatorPanel() {
        JPanel jPanel = GuiTools.center(this.navigator.getPanel());
        return jPanel;
    }

    private Component createVocabularyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.vocableViewer.getPanel(), "Center");
        jPanel.add(this.createHorizontalButtonsPart(), "South");
        return jPanel;
    }

    private Component createHorizontalButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (this.options.isShowDetailBottomButonsInTranslationEvaluationToo()) {
            this.listsWithVocableFinderGui.appendButtonToPanel(jPanel);
            this.vocableToOwnListAdderGui.appendButtonToPanel(jPanel);
            this.verbsAndAdjectivesFinderGui.appendButtonsToPanel(jPanel);
        }
        if (this.options.isShowDetailsButtonInEinzeldarstellung()) {
            jPanel.add(this.createDetailsButton());
        }
        return jPanel;
    }

    private Component createDetailsButton() {
        JButton jButton = new JButton("Details anzeigen");
        jButton.addActionListener(actionEvent -> this.showDetails());
        return jButton;
    }

    private void showDetails() {
        Vocable vocable = this.navigator.getActualDataSet();
        VocableWithInternaViewer vocableWithInternaViewer = new VocableWithInternaViewer(this.options, this.requester, vocable, this.ownLists, this.kanjiRequester, this.messageSetter, this.getLocation(), this.getProgramImage());
        vocableWithInternaViewer.setVisible(true);
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.backgroundChangingButton, "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.otherViewPanel.getPanel()), "Center");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private void keybindingsForDetailDialog() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 128);
        String string = "Strg-D";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.showDetails());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void keybindingsForPlaySound() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
        String string = "F9";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.vocableViewer.playMp3());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    @Override
    public void otherViewOpened() {
        this.closeDialog();
    }
}

