/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.pages.DatasetsOnPages;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.test.VocableListTesterLogic;
import de.duehl.vocabulary.japanese.logic.view.CompleteVocabularyViewerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocableBar;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.detail.VocableWithInternaDialog;
import de.duehl.vocabulary.japanese.ui.filter.VocableFilterInputs;
import de.duehl.vocabulary.japanese.ui.filter.VocableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComplexVocableSearchDialog
extends ModalDialogBase {
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final VocableFilterPanel vocableFilter;
    private final JLabel statisticLabel;
    private final DatasetsOnPages<Vocable> pages;
    private final OwnLists ownLists;
    private final InternalKanjiDataRequester kanjiRequester;
    private final MessageSetter messageSetter;
    private static VocableFilterInputs inputs;
    public static final String COMPLEX_SEARCH_NAME_START = "Erweiterte Suche";

    public ComplexVocableSearchDialog(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, OwnLists ownLists, InternalKanjiDataRequester internalKanjiDataRequester, MessageSetter messageSetter) {
        super(vocabularyTrainerGui.getLocation(), vocabularyTrainerGui.getProgramImage(), "Erweiterte Suche nach Vokabeln");
        this.addEscapeBehaviour();
        this.addClosingWindowListener(() -> this.storeSearchParametersAndCloseDialog());
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.ownLists = ownLists;
        this.kanjiRequester = internalKanjiDataRequester;
        this.messageSetter = messageSetter;
        this.vocableFilter = new VocableFilterPanel(ownLists, list -> this.reactOnFilteredVocables(list));
        this.statisticLabel = new JLabel();
        Options options = ownLists.getOptions();
        int n = options.getNumberOfDatasetsPerPageOfOwnListEditor();
        int n2 = options.getNumberOfColumnsOfOwnListEditor();
        this.pages = new DatasetsOnPages<Vocable>(vocabularyTrainerLogic.collectVocablesOfAllVocabularies(), vocable -> this.createDatasetUi((Vocable)vocable), n, n2);
        if (null == inputs) {
            inputs = new VocableFilterInputs();
        }
        this.init();
        this.fillDialog();
    }

    private Component createDatasetUi(Vocable vocable) {
        VocableBar vocableBar = new VocableBar(vocable, () -> this.showDetailDialog(vocable));
        vocableBar.useButtonAsShowDetails();
        vocableBar.createGui();
        return vocableBar.getPanel();
    }

    private void showDetailDialog(Vocable vocable) {
        VocableWithInternaDialog vocableWithInternaDialog = new VocableWithInternaDialog(this.logic.getOptions(), this.logic.getInternalDataRequester(), vocable, this.ownLists, this.kanjiRequester, this.messageSetter, this.getLocation(), this.getProgramImage());
        vocableWithInternaDialog.setVisible(true);
    }

    private void init() {
        this.initVocableFilter();
        this.initStatistic();
    }

    private void initVocableFilter() {
        this.vocableFilter.arrangeForComplexVocableSearchDialog();
        this.vocableFilter.loadInputs(inputs);
    }

    private void initStatistic() {
        this.updateStatistic(this.vocableFilter.createFilteredVocablesList());
    }

    private void reactOnFilteredVocables(List<Vocable> list) {
        this.updateStatistic(list);
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Keine Vokabeln gefunden", "Die Suchkriterien f\u00fchren zu einer leeren Liste von Vokabeln, daher wird diese nicht angezeigt.");
        } else {
            this.pages.setOtherDatasets(list);
        }
    }

    @Override
    protected void populateDialog() {
        this.add(this.createSearchAndStatisticPart(), "Center");
        this.add(this.createButtonPart(), "South");
    }

    private Component createSearchAndStatisticPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchAndFoundVocablesPart(), "Center");
        jPanel.add(this.createStatisticsPart(), "South");
        return jPanel;
    }

    private Component createSearchAndFoundVocablesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchPart(), "West");
        jPanel.add(this.createFoundVocablesPart(), "Center");
        return jPanel;
    }

    private Component createSearchPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Kriterien", jPanel);
        jPanel.add((Component)this.vocableFilter.getPanel(), "North");
        return jPanel;
    }

    private Component createFoundVocablesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Treffer", jPanel);
        jPanel.add(this.pages.getPanel(), "Center");
        return jPanel;
    }

    private Component createStatisticsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Statistik", jPanel);
        jPanel.add((Component)this.statisticLabel, "Center");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 5, 0));
        jPanel.add(this.createTestVocablesButton());
        jPanel.add(this.createEinzeldarsetllungButton());
        jPanel.add(this.createListendarstellungButton());
        jPanel.add(this.createVokabelblattdarstellungButton());
        jPanel.add(this.createSaveListButton());
        jPanel.add(this.createCloseDialogButton());
        return jPanel;
    }

    private Component createTestVocablesButton() {
        JButton jButton = new JButton("Vokabeln abfragen");
        jButton.addActionListener(actionEvent -> this.testVocables());
        return jButton;
    }

    private void testVocables() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        if (list.isEmpty()) {
            this.informNoVocablesMatchSearchCriteria();
        } else {
            this.storeSearchParametersAndCloseDialog();
            String string = "Vokabeln aus der erweiterten Suche";
            VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(this.logic, this.gui, list, string, this.messageSetter);
            vocableListTesterLogic.test();
            this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
            this.gui.setMessageLater("Getestet wurden: " + string);
        }
    }

    private Component createEinzeldarsetllungButton() {
        JButton jButton = new JButton("Einzeldarstellung");
        jButton.addActionListener(actionEvent -> this.showAsEinzeldarstellung());
        return jButton;
    }

    private void showAsEinzeldarstellung() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        if (list.isEmpty()) {
            this.informNoVocablesMatchSearchCriteria();
        } else {
            this.storeSearchParametersAndCloseDialog();
            CompleteVocabularyViewerLogic completeVocabularyViewerLogic = new CompleteVocabularyViewerLogic(this.logic.getOptions(), this.logic.getInternalDataRequester(), list, this.logic.getInternalKanjiDataRequester(), "Gefundene Vokabeln", this.gui, this.ownLists, this.messageSetter, this.getLocation(), this.getProgramImage());
            completeVocabularyViewerLogic.view();
            this.gui.setMessageLater("Die gefundenen Vokabeln wurden angezeigt.");
        }
    }

    private void informNoVocablesMatchSearchCriteria() {
        String string = "Es gibt keine Vokabeln, die auf die Suchkriterien passen.";
        GuiTools.informUser(this.getWindowAsComponent(), "Hinweis", string);
        this.gui.setMessageLater(string);
    }

    private Component createListendarstellungButton() {
        JButton jButton = new JButton("Listendarstellung");
        jButton.addActionListener(actionEvent -> this.showAsListendarstellung());
        return jButton;
    }

    private void showAsListendarstellung() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        if (list.isEmpty()) {
            this.informNoVocablesMatchSearchCriteria();
        } else {
            this.storeSearchParametersAndCloseDialog();
            VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.logic.getOptions(), this.logic.getInternalDataRequester(), list, "Vokabeln aus der erweiterten Suche", this.logic.getInternalKanjiDataRequester(), this.gui, this.ownLists, this.messageSetter, this.getLocation(), this.getProgramImage());
            vocabularyListerDialog.setVisible(true);
            this.gui.setMessageLater("Die Vokabeln aus der erweiterten Suche wurden als Liste angezeigt.");
        }
    }

    private Component createVokabelblattdarstellungButton() {
        JButton jButton = new JButton("Darstellung als Vokabelblatt");
        jButton.addActionListener(actionEvent -> this.showAsVokabelblattdarstellung());
        return jButton;
    }

    private void showAsVokabelblattdarstellung() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        if (list.isEmpty()) {
            this.informNoVocablesMatchSearchCriteria();
        } else {
            this.storeSearchParametersAndCloseDialog();
            this.gui.sheetWithVocables(list, "Vokabeln aus der erweiterten Suche");
            this.gui.setMessageLater("Die Vokabeln aus der erweiterten Suche wurden als Blatt angezeigt.");
        }
    }

    private Component createSaveListButton() {
        JButton jButton = new JButton("Gefundene Vokabeln als Liste speichern");
        jButton.addActionListener(actionEvent -> this.saveList());
        return jButton;
    }

    private Component createCloseDialogButton() {
        JButton jButton = new JButton("Schlie\u00dfen");
        jButton.addActionListener(actionEvent -> this.storeSearchParametersAndCloseDialog());
        return jButton;
    }

    private void saveList() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        if (list.isEmpty()) {
            this.informNoVocablesMatchSearchCriteria();
        } else {
            this.gui.saveAsList(list, COMPLEX_SEARCH_NAME_START);
        }
    }

    private void updateStatistic(List<Vocable> list) {
        this.statisticLabel.setText("Anzahl Vokabeln: " + NumberString.taupu(list.size()));
    }

    private void storeSearchParametersAndCloseDialog() {
        this.vocableFilter.storeInputs(inputs);
        this.closeDialog();
    }
}

