/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.detail.addtolist;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.dialog.ownlist.OwnListSelectionDialog;
import java.awt.Image;
import java.awt.Point;
import java.util.List;

class VocableToOwnListAdder {
    private final OwnLists ownLists;
    private final Point location;
    private final Image programImage;

    public VocableToOwnListAdder(OwnLists ownLists, Point point, Image image) {
        this.ownLists = ownLists;
        this.location = point;
        this.programImage = image;
    }

    public void addVocableToList(Vocable vocable) {
        String string = "Auswahl einer eigenen Liste";
        String string2 = "Bitte w\u00e4hlen Sie die eigene Liste aus, zu der die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " hinzugef\u00fcgt werden soll.";
        OwnListSelectionDialog ownListSelectionDialog = new OwnListSelectionDialog(string, string2, this.ownLists, this.location, this.programImage);
        ownListSelectionDialog.setVisible(true);
        if (ownListSelectionDialog.isApplied()) {
            OwnList ownList = ownListSelectionDialog.getOwnList();
            Options options = this.ownLists.getOptions();
            HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalOwnLists();
            historicalOwnListPersistanceDataList.addOwnListData(ownList.toOwnListPersistanceData());
            List<Vocable> list = ownList.getVocables();
            if (list.contains(vocable)) {
                GuiTools.informUser("Die Vokabel ist in der Liste schon enthalten", "Die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " ist in der Liste '" + ownList.getName() + "' schon enthalten.");
            } else {
                list.add(vocable);
                GuiTools.informUser("Die Vokabel wurde zur Liste hinzugef\u00fcgt", "Die Vokabel " + vocable.getKanjiKanaRomajiWithJapaneseBraces() + " wurde zur Liste '" + ownList.getName() + "' hinzugef\u00fcgt.");
                this.ownLists.storeOwnLists();
                this.ownLists.actualizeOwnListsPartInGui();
            }
        }
    }
}

