/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.detail.related;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.VerbSearchWords;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.detail.related.RelatedVocablesFinder;
import java.awt.Image;
import java.awt.Point;
import java.util.List;

class VerbsAndAdjectivesFinder {
    private final Options options;
    private final InternalDataRequester requester;
    private final OwnLists ownLists;
    private final InternalKanjiDataRequester kanjiRequester;
    private final MessageSetter messageSetter;
    private final Point location;
    private final Image programImage;
    private final LongTimeProcessInformer longTimeProcessInformer;

    public VerbsAndAdjectivesFinder(Options options, InternalDataRequester internalDataRequester, OwnLists ownLists, InternalKanjiDataRequester internalKanjiDataRequester, MessageSetter messageSetter, Point point, Image image, LongTimeProcessInformer longTimeProcessInformer) {
        this.options = options;
        this.requester = internalDataRequester;
        this.ownLists = ownLists;
        this.kanjiRequester = internalKanjiDataRequester;
        this.messageSetter = messageSetter;
        this.location = point;
        this.programImage = image;
        this.longTimeProcessInformer = longTimeProcessInformer;
    }

    public void findRelatedVerbs(Vocable vocable2) {
        RelatedVocablesFinder relatedVocablesFinder = new RelatedVocablesFinder(this.ownLists.getVocabularies(), vocable2, vocable -> vocable.isVerb());
        relatedVocablesFinder.find();
        List<Vocable> list = relatedVocablesFinder.getRelatedVocables();
        String string = "Verbformen zum Verb " + vocable2.getKanjiKanaRomajiWithJapaneseBraces();
        VerbSearchWords.sortVocablesByVerbForms(list);
        this.listVocables(list, string);
    }

    public void findRelatedAdjectives(Vocable vocable2) {
        RelatedVocablesFinder relatedVocablesFinder = new RelatedVocablesFinder(this.ownLists.getVocabularies(), vocable2, vocable -> vocable.isAdjective());
        relatedVocablesFinder.find();
        List<Vocable> list = relatedVocablesFinder.getRelatedVocables();
        String string = "Adjektivformen zum Adjektiv " + vocable2.getKanjiKanaRomajiWithJapaneseBraces();
        VerbSearchWords.sortVocablesByVerbForms(list);
        this.listVocables(list, string);
    }

    private void listVocables(List<Vocable> list, String string) {
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.options, this.requester, list, string, this.kanjiRequester, this.longTimeProcessInformer, this.ownLists, this.messageSetter, this.location, this.programImage);
        vocabularyListerDialog.setVisible(true);
    }
}

