/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.tables.ButtonColumn;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components.HiraganaDetailDialog;
import de.duehl.vocabulary.japanese.ui.dialog.table.hiragana.HiraganaTableColumnModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.hiragana.HiraganaTableModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.hiragana.HiraganaTableRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class HiraganaTableDialog
extends NonModalFrameDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private static final Color TABLE_FOREGROUND = new Color(0, 0, 255);
    private static final Color TABLE_BACKGROUND = new Color(240, 240, 255);
    private static final float DEFAULT_FONT_SIZE = 15.0f;
    private final List<Hiragana> hiraganaList;
    private final InternalKanaDataRequester kanaRequester;
    private final JTable table;
    private final HiraganaTableModel tableModel;
    private final HiraganaTableRenderer tableRenderer;
    private JScrollPane scrollPane;
    private final JButton increaseFontSizeButton;
    private final JButton standardFontSizeButton;
    private final JButton decreaseFontSizeButton;

    public HiraganaTableDialog(Options options, InternalKanaDataRequester internalKanaDataRequester, Point point, Image image) {
        super(point, image, "Liste mit den Hiragana.", DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.hiraganaList = CollectionsHelper.arrayToList(Hiragana.values());
        this.kanaRequester = internalKanaDataRequester;
        this.table = new JTable();
        this.tableModel = new HiraganaTableModel(options, this.hiraganaList, internalKanaDataRequester);
        this.tableRenderer = new HiraganaTableRenderer(TABLE_FOREGROUND, TABLE_BACKGROUND);
        this.increaseFontSizeButton = new JButton();
        this.standardFontSizeButton = new JButton();
        this.decreaseFontSizeButton = new JButton();
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.initTable();
        this.initScrollPane();
    }

    private void initTable() {
        this.initTableModel();
        this.initTableColumnModel();
        this.initTableRenderer();
        this.setTableSelectionMode();
        this.setTableRowHight();
        this.switchReorderingOfTableColumnsOff();
        this.initTableButtonEditorAndRenderer();
        this.initTableSorter();
    }

    private void initTableModel() {
        this.table.setModel(this.tableModel);
    }

    private void initTableColumnModel() {
        this.table.setColumnModel(new HiraganaTableColumnModel());
    }

    private void initTableRenderer() {
        this.tableRenderer.setFontSize(15.0f);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
    }

    private void setTableSelectionMode() {
        this.table.setSelectionMode(0);
    }

    private void setTableRowHight() {
        this.tableRenderer.initRowHeightOfTable(this.table);
    }

    private void switchReorderingOfTableColumnsOff() {
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void initTableButtonEditorAndRenderer() {
        new ButtonColumn(this.table, n -> this.reactOnShowHiraganaDetailsButtonClick(n), 9);
    }

    private void reactOnShowHiraganaDetailsButtonClick(int n) {
        Hiragana hiragana = this.hiraganaList.get(n);
        HiraganaDetailDialog hiraganaDetailDialog = new HiraganaDetailDialog(hiragana, this.kanaRequester, this.getParentLocation(), this.getProgramImage());
        hiraganaDetailDialog.setVisible(true);
    }

    private void initTableSorter() {
        TableRowSorter<HiraganaTableModel> tableRowSorter = new TableRowSorter<HiraganaTableModel>(this.tableModel);
        this.table.setRowSorter(tableRowSorter);
    }

    private void initScrollPane() {
        this.scrollPane = GuiTools.createScrollPane(this.table);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(this.scrollPane);
    }

    private void initElements() {
        this.initIncreaseFontSizeButton();
        this.initStandardFontSizeButton();
        this.initDecreaseFontSizeButton();
    }

    private void initIncreaseFontSizeButton() {
        this.increaseFontSizeButton.setText("+");
        this.increaseFontSizeButton.addActionListener(actionEvent -> this.increaseFontSize());
    }

    private void increaseFontSize() {
        this.tableRenderer.increaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initStandardFontSizeButton() {
        String string = "default size (" + NumberString.twoDecimalPlaces(15.0) + ")";
        this.standardFontSizeButton.setText(string);
        this.standardFontSizeButton.addActionListener(actionEvent -> this.standardFontSize());
    }

    private void standardFontSize() {
        this.tableRenderer.setFontSize(15.0f);
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initDecreaseFontSizeButton() {
        this.decreaseFontSizeButton.setText("-");
        this.decreaseFontSizeButton.addActionListener(actionEvent -> this.decreaseFontSize());
    }

    private void decreaseFontSize() {
        this.tableRenderer.decreaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFontSizeAndColorButtonsPart(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createFontSizeAndColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createFontSizeButtonsPart());
        jPanel.add(this.createColorButtonsPart());
        return jPanel;
    }

    private Component createFontSizeButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.decreaseFontSizeButton);
        jPanel.add(this.standardFontSizeButton);
        jPanel.add(this.increaseFontSizeButton);
        return jPanel;
    }

    private Component createColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createSwitchForegroundColorButton());
        jPanel.add(this.createSwitchBackgroundColorButton());
        return jPanel;
    }

    private Component createSwitchForegroundColorButton() {
        JButton jButton = new JButton("toggle Vordergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorForegroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorForegroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorForegroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createSwitchBackgroundColorButton() {
        JButton jButton = new JButton("toggle Hintergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorBackgroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorBackgroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorBackgroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }
}

