package de.duehl.basics.autodetect.ent;

/**
 * Diese Klasse ist die abstrakte Basis einer Klasse, welche einen Text (ent) bearbeitet.
 *
 * Es werden Kommentare zur Auffindung des Begriffs gesammelt.
 *
 * @version 1.01     2022-05-06
 * @author Christian Dühl
 */

public abstract class SimpleEntWorker extends EntWorker {

    /**
     * Konstruktor.
     *
     * @param ent
     *            Ursprünglich der rohe Text, dieser wird/wurde bei der Analyse aber verändert und
     *            Teile durch die Entitäten wie <<street>> oder <<street:2>> ersetzt.
     */
    public SimpleEntWorker(String ent) {
        super(ent);
    }

    /** Führt die Arbeit durch. */
    public abstract void work();

}
