package de.duehl.basics.io.textfile.dictionary.join;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;

/**
 * Diese Klasse vereinigt Wörterbücher zu einem einzigen, hierbei werden aber Wörterbucheinträge
 * mit den selben Hauptworten so belassen, es wird einfach zusammenkopiert.
 *
 * Will man eine bessere Art des Vereinigens, so muss man den DictionaryJoiner nutzen.
 *
 * @version 1.01     2024-05-16
 * @author Christian Dühl
 */

public class SimpleDictionaryJoiner {

    public static Dictionary join(Dictionary ...dictionaries) {
        Dictionary joinedDictionary = new Dictionary();

        for (Dictionary dictionary : dictionaries) {
            for (DictionaryEntry entry : dictionary) {
                DictionaryEntry copy = new DictionaryEntry(entry);
                joinedDictionary.addDictionaryEntry(copy);
            }
        }

        return joinedDictionary;
    }

}
