package de.duehl.basics.io.zip;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.zip.ZipOutputStream;

import de.duehl.basics.io.FileHelper;

/**
 * Diese Klasse kann Dateien in ein Zip-Archiv verpacken.
 *
 * @version 1.01     2021-05-27
 * @author Christian Dühl
 */

public class ZipFiles extends Zip {

    /** Der Ausgabestrom für das gebildete Zip-Archiv. */
    private ZipOutputStream assembling;

    /** Das Verzeichnis unterhalb dessen die gepackten Dateien liegen. */
    private String assemblingDirectory;

    /** Konstruktor. Hier taucht der letzte Verzeichnisname als erstes Verzeichnis im Archiv auf. */
    public ZipFiles() {
        this(true);
    }

    /**
     * Konstruktor.
     *
     * @param withStartDirectory
     *            Gibt an, ob der letzte Verzeichnisname als erstes Verzeichnis im Archiv
     *            auftauchen soll oder nicht.
     */
    public ZipFiles(boolean withStartDirectory) {
        super(withStartDirectory);
    }

    /**
     * Beginnt eine Sammlung von einzelnen Dateien in einem Verzeichnis oder dessen
     * Unterverzeichnissen.
     *
     * @param zipFilename
     *            Name der Zip-Datei.
     * @param directory
     *            Verzeichnis, unterhalb dessen die gepackten Dateien liegen.
     */
    public void startAssembling(String zipFilename, String directory) {
        assembling = createArchive(zipFilename);
        assemblingDirectory = FileHelper.normalizeToBackSlahes(directory);
    }

    /**
     * Fügt eine Datei zur Sammlung von einzelnen Dateien hinzu.
     *
     * @param filename
     *            Name der Datei.
     */
    public void addFileToAssembling(String filename) {
        packFile(assemblingDirectory, assembling, FileHelper.normalizeToBackSlahes(filename));
    }

    /** Beendet das Erstellen einer Sammlung von einzelnen Dateien und schreibt die Archivdatei. */
    public void assemblingDone() {
        closeArchive(assembling);
    }

}
