package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.datetime.date.ImmutualDate;

public class DateParseMethodUnixTest {

    @Test
    public void parse() {
        DateParseMethod method = new DateParseMethodUnix("Wed Jan 18 12:01:50 CET 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(18, date.getDay());
        assertEquals(1, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

}
