package de.duehl.basics.io.done;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.File;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.test.TestHelper;

import static org.junit.Assert.*;
import org.junit.Test;

public class DoneTest {

    private final String path;

    public DoneTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 7);
        path =  testHelper.getTestDataPath() + File.separator + "done" + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void createForSameDirctoryAndGetRightName() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        String actual = done.getDoneFilename();
        String expected = fileToCreateDoneFileFor + ".done";
        assertEquals(expected, actual);
    }

    @Test
    public void createForDifferentDirctoryAndGetRightName() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        String differentDirectory = "c:\\foo\\bar_done";
        Done done = new Done(fileToCreateDoneFileFor, differentDirectory);
        String actual = done.getDoneFilename();
        String expected = FileHelper.concatPathes(differentDirectory,
                FileHelper.getBareName(fileToCreateDoneFileFor) + ".done");
        assertEquals(expected, actual);
    }

    @Test
    public void createForSameDirctoryAndGetFileToCreateDoneFileFor() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        String actual = done.getFileToCreateDoneFileFor();
        String expected = fileToCreateDoneFileFor;
        assertEquals(expected, actual);
    }

    @Test
    public void createForDifferentDirctoryAndFileToCreateDoneFileFor() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        String differentDirectory = "c:\\foo\\bar_done";
        Done done = new Done(fileToCreateDoneFileFor, differentDirectory);
        String actual = done.getFileToCreateDoneFileFor();
        String expected = fileToCreateDoneFileFor;
        assertEquals(expected, actual);
    }

    @Test
    public void createForSameDirctoryAndDoneMarkerFileIsMissing() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        assertFalse(done.isDoneMarkerSet());
        assertTrue(done.isDoneMarkerMissing());
    }

    @Test
    public void createForDifferentDirctoryAndDoneMarkerFileIsMissing() {
        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        String differentDirectory = "c:\\foo\\bar_done";
        Done done = new Done(fileToCreateDoneFileFor, differentDirectory);
        assertFalse(done.isDoneMarkerSet());
        assertTrue(done.isDoneMarkerMissing());
    }

    @Test
    public void createForSameDirctoryCreateDoneFileAndDoneMarkerFileIsNotMissing() {
        String fileToCreateDoneFileFor = path + "baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        done.createDoneFile();
        assertTrue(done.isDoneMarkerSet());
        assertFalse(done.isDoneMarkerMissing());

        done.deleteDoneFile(); // aufräumen nach dem Test
    }

    @Test
    public void createForDifferentDirctoryCreateDoneFileAndDoneMarkerFileIsNotMissing() {
        String fileToCreateDoneFileFor = path + "baz.txt";
        String differentDirectory = path + "separateDoneDirectory";
        Done done = new Done(fileToCreateDoneFileFor, differentDirectory);
        done.createDoneFile();
        assertTrue(done.isDoneMarkerSet());
        assertFalse(done.isDoneMarkerMissing());

        done.deleteDoneFile(); // aufräumen nach dem Test
    }

}
