package de.duehl.basics.text;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.junit.Test;

public class DescandingStringLengthComparatorTest {

    @Test
    public void createObject() {
        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        assertNotNull(comparator);
    }

    @Test
    public void sortTwoThingsNotSorted() {
        List<String> list = new ArrayList<>();
        list.add("a");
        list.add("aa");

        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        Collections.sort(list, comparator);

        assertEquals(2, list.size());
        assertEquals("aa", list.get(0));
        assertEquals("a", list.get(1));
    }

    @Test
    public void sortTwoThingsAlreadySorted() {
        List<String> list = new ArrayList<>();
        list.add("aa");
        list.add("a");

        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        Collections.sort(list, comparator);

        assertEquals(2, list.size());
        assertEquals("aa", list.get(0));
        assertEquals("a", list.get(1));
    }

    @Test
    public void sortThreeThingsNotSorted() {
        List<String> list = new ArrayList<>();
        list.add("a");
        list.add("aa");
        list.add("aaa");

        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        Collections.sort(list, comparator);

        assertEquals(3, list.size());
        assertEquals("aaa", list.get(0));
        assertEquals("aa", list.get(1));
        assertEquals("a", list.get(2));
    }

    @Test
    public void sortThreeThingsNotSorted2() {
        List<String> list = new ArrayList<>();
        list.add("a");
        list.add("aaa");
        list.add("aa");

        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        Collections.sort(list, comparator);

        assertEquals(3, list.size());
        assertEquals("aaa", list.get(0));
        assertEquals("aa", list.get(1));
        assertEquals("a", list.get(2));
    }

    @Test
    public void sortThreeThingsAlreadySorted() {
        List<String> list = new ArrayList<>();
        list.add("aaa");
        list.add("aa");
        list.add("a");

        DescandingStringLengthComparator comparator = new DescandingStringLengthComparator();
        Collections.sort(list, comparator);

        assertEquals(3, list.size());
        assertEquals("aaa", list.get(0));
        assertEquals("aa", list.get(1));
        assertEquals("a", list.get(2));
    }

}
