package de.duehl.html.download.unused;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;

public class TemporarilyUnusedStuff {

    public void useSystemProxy() {
        System.setProperty("java.net.useSystemProxies", "true");
    }

    void foo() throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("http://targethost/homepage");
        CloseableHttpResponse response1 = httpclient.execute(httpGet);
        // The underlying HTTP connection is still held by the response object
        // to allow the response content to be streamed directly from the network socket.
        // In order to ensure correct deallocation of system resources
        // the user MUST call CloseableHttpResponse#close() from a finally clause.
        // Please note that if response content is not fully consumed the underlying
        // connection cannot be safely re-used and will be shut down and discarded
        // by the connection manager.
        try {
            System.out.println(response1.getStatusLine());
            HttpEntity entity1 = response1.getEntity();
            // do something useful with the response body
            // and ensure it is fully consumed
            EntityUtils.consume(entity1);
        }
        finally {
            response1.close();
        }
    }

    /*
     * HttpClient handles all types of redirects automatically, except those explicitly prohibited
     * by the HTTP specification as requiring user intervention. See Other (status code 303)
     * redirects on POST and PUT requests are converted to GET requests as required by the HTTP
     * specification. One can use a custom redirect strategy to relax restrictions on automatic
     * redirection of POST methods imposed by the HTTP specification.
     */
    CloseableHttpClient createHttpClientWithlaxRedirect() {
        LaxRedirectStrategy redirectStrategy = new LaxRedirectStrategy();
        CloseableHttpClient httpclient = HttpClients.custom()
                .setRedirectStrategy(redirectStrategy)
                .build();
        return httpclient;
    }

    /*
     * HttpClient often has to rewrite the request message in the process of its execution. Per
     * default HTTP/1.0 and HTTP/1.1 generally use relative request URIs. Likewise, original
     * request may get redirected from location to another multiple times. The final interpreted
     * absolute HTTP location can be built using the original request and the context. The utility
     * method URIUtils#resolve can be used to build the interpreted absolute URI used to generate
     * the final request. This method includes the last fragment identifier from the redirect
     * requests or the original request.
     */
    void absoluteURI() {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost:8080/");
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute(httpget, context);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            HttpHost target = context.getTargetHost();
            List<URI> redirectLocations = context.getRedirectLocations();
            URI location = URIUtils.resolve(httpget.getURI(), target, redirectLocations);
            System.out.println("Final HTTP location: " + location.toASCIIString());
            // Expected to be an absolute URI
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    CloseableHttpClient createHttpClientUsingProxy() {
        //HttpHost proxy = new HttpHost(InetAddress, port)
        HttpHost proxy = new HttpHost("someproxy", 8080);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        CloseableHttpClient httpClient = HttpClients.custom()
                .setRoutePlanner(routePlanner)
                .build();
        return httpClient;
    }


    void encodingthings() {
        /*

        // 1) Using EntityUtils and HttpEntity

        HttpResponse response = httpClient.execute(new HttpGet(URL));
        HttpEntity entity = response.getEntity();
        String responseString = EntityUtils.toString(entity, "UTF-8");
        System.out.println(responseString);

        // 2) Using BasicResponseHandler

        HttpResponse response = httpClient.execute(new HttpGet(URL));
        String responseString = new BasicResponseHandler().handleResponse(response);
        System.out.println(responseString);

        */
    }

    //@SuppressWarnings("resource")
    String getRawContents(HttpEntity entity)
            throws UnsupportedOperationException, IOException {
        InputStream is = entity.getContent();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        String line;
        while (null != (line = br.readLine())) {
            builder.append(line).append("\n");
        }
        String contents = builder.toString();
        return contents;
    }

}