package de.duehl.swing.ui.elements.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.datetime.time.watch.StopWatch;

/**
 * Diese Klasse stellt ein Label dar, das die auf ihm angezeigte Stoppuhr automatisch aktualisiert.
 *
 * @version 1.01     2021-03-17
 * @author Christian Dühl
 */

public class StopWatchLabel extends WatchBaseLabel {

    private static final long serialVersionUID = 1L;

    /** Stoppuhr, deren Zeit angezeigt wird. */
    private final StopWatch stopWatch;

    /** Konstruktor ohne Text vor und nach der Stoppuhr. */
    public StopWatchLabel() {
        this("", new StopWatch(), "");
    }

    /**
     * Konstruktor mit Text vor der Stoppuhr.
     *
     * @param startText
     *            Text vor der Stoppuhr.
     */
    public StopWatchLabel(String startText) {
        this(startText, new StopWatch(), "");
    }

    /**
     * Konstruktor mit Text vor und nach der Stoppuhr.
     *
     * @param startText
     *            Text vor der Stoppuhr.
     * @param endText
     *            Text nach der Stoppuhr.
     */
    public StopWatchLabel(String startText, String endText) {
        this(startText, new StopWatch(), endText);
    }

    /**
     * Konstruktor mit Text vor und nach der Stoppuhr sowie eigener Stoppuhr, die übergeben wird.
     *
     * @param startText
     *            Text vor der Stoppuhr.
     * @param stopWatch
     *            Stoppuhr, deren Zeit angezeigt wird.
     * @param endText
     *            Text nach der Stoppuhr.
     */
    public StopWatchLabel(String startText, StopWatch stopWatch, String endText) {
        super(startText, stopWatch, endText);
        this.stopWatch = stopWatch;
    }

    /** Startet die Stoppuhr. */
    public void start() {
        stopActualisationRunnable();

        stopWatch.start();

        createRunnableAndStartActualisationThread();
    }

    /** Hält die Stoppuhr beim ersten Aufruf von stop() an, weitere Aufrufe sind wirkungslos. */
    public void stop() {
        stopWatch.stop();
        stopActualisationRunnable();
        setWatchText(); // falls das Runnable dazu nicht mehr kam.
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "StopWatchLabel [" + createWatchLabelText() + "]";
    }

}
