package de.duehl.swing.ui.filter.method.combination;

import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.Method;

/**
 * Diese Klasse stellt ein Element einer Filtermethodenkombination dar.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public class CombinationElement<Data> {

    /** Typ dieses Elements. */
    private CombinationElementType type;

    /** Methode dieses Elements, so das Element den Typ METHOD hat. */
    private Method<Data> method;

    /**
     * Konstruktor für nicht-Methoden-Kombinationselemente.
     *
     * @param type
     *            Typ des Elements.
     * @throws FilterException
     *             Bei Fehlern wird diese Ausnahme geworfen.
     */
    public CombinationElement(CombinationElementType type) {
        this.type = type;
        this.method = null;

        if (type == CombinationElementType.METHOD) {
            throw new FilterException("Falscher Filtermethodenkombinationsaufruf 1");
        }
    }

    /**
     * Konstruktor für Methoden-Kombinationselemente.
     *
     * @param method
     *            Filtermethode
     * @throws FilterException
     *             Bei Fehlern wird diese Ausnahme geworfen.
     */
    public CombinationElement(Method<Data> method) {
        this.type = CombinationElementType.METHOD;
        this.method = method;

        if (null == method) {
            throw new FilterException("Falscher Filtermethodenkombinationsaufruf 2");
        }
    }

    /** Handelt es sich um eine öffnende Klammer? */
    public boolean isOpeningBrace() {
        return type == CombinationElementType.BRACE_OPEN;
    }

    /** Handelt es sich um eine schließende Klammer? */
    public boolean isClosingBrace() {
        return type == CombinationElementType.BRACE_CLOSE;
    }

    /** Handelt es sich um eine Negation? */
    public boolean isNegation() {
        return type == CombinationElementType.NOT;
    }

    /** Handelt es sich um eine Schnittbildung (und)? */
    public boolean isIntersection() {
        return type == CombinationElementType.INTERSECTION;
    }

    /** Handelt es sich um eine Vereinigung (oder)? */
    public boolean isUnion() {
        return type == CombinationElementType.UNION;
    }

    /** Handelt es sich um eine Filtermethode? */
    public boolean isMethod() {
        return type == CombinationElementType.METHOD;
    }

    /**
     * Getter für die Filtermethode.
     *
     * @return Filtermethode
     * @throws FilterException
     *             Bei Fehlern wird diese Ausnahme geworfen.
     */
    public Method<Data> getMethod() {
        if (type != CombinationElementType.METHOD) {
            throw new FilterException("Es wurde eine Methode eines "
                    + "Nicht-Methoden-Kombinationselements abgefragt.");
        }
        return method;
    }

    @Override
    public String toString() {
        return "CombinationElement [type=" + type + ", method=" + method + "]";
    }

}
