package de.duehl.swing.ui.update.informer;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse wird informiert, wenn ein Update das erste Mal nach dem Tageswechsel erfolgt und
 * tut nichts.
 *
 * Dafür muss am Tag zuvor bereits mindestens ein Update gelaufen sein.
 *
 * @version 1.01     2021-03-25
 * @author Christian Dühl
 */

public class NoUpdateAfterDayChangeInformer implements UpdateAfterDayChangeInformer {

    /**
     * Informiert darüber, dass ein Update das erste Mal nach dem Tageswechsel erfolgt. Dafür muss
     * am Tag zuvor bereits mindestens ein Update gelaufen sein.
     */
    @Override
    public void informAboutUpdateAfterDayChange() {
        // wir tun nichts
    }

}
