package de.duehl.swing.ui.error;

import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;

public class GuiExceptionHandlerTestWithCallableNoErrorDialog {

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();

        GuiExceptionHandlerRegistration registration = new GuiExceptionHandlerRegistration();
        registration.setAfterErrorHandlingCallable(createCallable());
        registration.registerToEdt();

        SwingUtilities.invokeLater(() ->
            {
                throw new IllegalArgumentException(new NullPointerException("darf nicht null sein!"));
            }
            );
    }

    private static AfterErrorHandlingCallable createCallable() {
        return new AfterErrorHandlingCallable() {

            @Override
            public void callMeAfterHandledUiError() {
                System.out.println("Ausgabe danach!");
            }

        };
    }

}
