package de.duehl.swing.ui.start;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.key.KeyDefinition;
import de.duehl.swing.ui.key.KeyboardShortCutDialog;

/**
 * Diese Klasse testet den Dialog zur Eingabe eines Keyboard-ShortCuts.
 *
 * @version 1.01     2020-08-20
 * @author Christian Dühl
 */

public class KeyboardShortCutDialogTest {

    private final JFrame frame;

    /** Konstruktor. */
    public KeyboardShortCutDialogTest() {
        frame = new JFrame("CharsetDialog Test");

        GuiTools.setNiceLayoutManager();

        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createOpenDialogButton(), BorderLayout.CENTER);

        frame.setPreferredSize(new Dimension(500, 300));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createOpenDialogButton() {
        JButton button = new JButton("Dialog zur Eingabe eines Keyboard-ShortCuts öffnen");
        button.addActionListener(e ->  createKeyboardShortCutDialog());
        return button;
    }

    private void createKeyboardShortCutDialog() {
        KeyboardShortCutDialog dialog = new KeyboardShortCutDialog(frame.getLocation(), null);
        dialog.setVisible(true);
        KeyDefinition keyboardShortCut = dialog.getSelectedKeyDefinition();
        System.out.println("Ausgewählt wurde: " + keyboardShortCut);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new KeyboardShortCutDialogTest();
    }

}

