package de.duehl.swing.ui.start;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.elements.box.BoxSelectionChangeObserver;
import de.duehl.swing.ui.elements.box.ObservableComboBox;

/**
 * Diese Klasse testet die ObservableComboBox-Elemente.
 *
 * @version 1.01     2017-11-17
 * @author Christian Dühl
 */

public class ObservableComboBoxTest {

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new ObservableComboBoxTest();
    }

    /** Konstruktor. */
    public ObservableComboBoxTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("ObservableComboBox Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(createStringComboBox());
        frame.add(createEditableStringComboBox());
        frame.add(createIntComboBox());
        frame.add(createEditableIntComboBox());

        frame.pack();
        frame.setVisible(true);
    }

    private Component createStringComboBox() {
        ObservableComboBox<String> box = new ObservableComboBox<>();
        box.addBoxSelectionChangeObserver(new BoxSelectionChangeObserver<String>() {
            @Override
            public void boxSelectionChanged(String selected) {
                System.out.println("String-ObservableComboBox, selected = " + selected);
            }
        });
        box.setValues(CollectionsHelper.buildListFrom("Apfel", "Birne", "Pflaume"));
        return box.getBox();
    }

    private Component createEditableStringComboBox() {
        ObservableComboBox<String> box = new ObservableComboBox<>();
        box.setEditable(true);
        box.addBoxSelectionChangeObserver(new BoxSelectionChangeObserver<String>() {
            @Override
            public void boxSelectionChanged(String selected) {
                System.out.println("Editable String-ObservableComboBox, selected = " + selected);
            }
        });
        box.setValues(CollectionsHelper.buildListFrom("Fortran", "C", "C++", "C#", "Perl", "Java"));
        return box.getBox();
    }

    private Component createIntComboBox() {
        ObservableComboBox<Integer> box = new ObservableComboBox<>();
        box.addBoxSelectionChangeObserver(new BoxSelectionChangeObserver<Integer>() {
            @Override
            public void boxSelectionChanged(Integer selected) {
                System.out.println("Integer-ObservableComboBox, selected = " + selected);
            }
        });
        box.setValues(CollectionsHelper.buildListFrom(0, 1, 2, 3, 4));
        return box.getBox();
    }

    private Component createEditableIntComboBox() {
        /*
         * Das macht keinen Sinn, wenn man was einträgt, das keine Zahl ist, knallt es...
         */
        ObservableComboBox<Integer> box = new ObservableComboBox<>();
        box.setEditable(true);
        box.addBoxSelectionChangeObserver(new BoxSelectionChangeObserver<Integer>() {
            @Override
            public void boxSelectionChanged(Integer selected) {
                System.out.println("Integer-ObservableComboBox, selected = " + selected);
            }
        });
        box.setValues(CollectionsHelper.buildListFrom(2, 4, 8, 16, 32, 64, 128, 256));
        return box.getBox();
    }

}

