package de.duehl.swing.ui.start;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.SquareButton;
import de.duehl.swing.ui.buttons.painted.DiceButton;
import de.duehl.swing.ui.buttons.painted.EditButton;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.GoBackButton;
import de.duehl.swing.ui.buttons.painted.GoButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.MinusButton;
import de.duehl.swing.ui.buttons.painted.MinusInABoxButton;
import de.duehl.swing.ui.buttons.painted.NextButton;
import de.duehl.swing.ui.buttons.painted.PaintedButton;
import de.duehl.swing.ui.buttons.painted.PlusButton;
import de.duehl.swing.ui.buttons.painted.PlusInABoxButton;
import de.duehl.swing.ui.buttons.painted.PreviousButton;
import de.duehl.swing.ui.buttons.painted.UpButton;
import de.duehl.swing.ui.buttons.painted.XButton;
import de.duehl.swing.ui.buttons.painted.DiceButton.RollValue;
import de.duehl.swing.ui.buttons.painted.DownButton;
import de.duehl.swing.ui.buttons.painted.XInABoxButton;
import de.duehl.swing.ui.buttons.TextButton;

/**
 * Diese Klasse testet einige selbstgezeichnete Buttons.
 *
 * @version 1.01     2022-07-28
 * @author Christian Dühl
 */

public class PaintedButtonTest {

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new PaintedButtonTest();
    }

    /** Konstruktor. */
    public PaintedButtonTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    /** Erstellt die grafische Oberfläche und zeigt sie an. */
    private void createAndShowGUI() {
        GuiTools.setNiceLayoutManager();

        JFrame frame = new JFrame(
                "First-, Previous-, Next- und Last-Button SizableTest");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0, 2));

        frame.add(createNavigationPanel());
        frame.add(createTextButtonPanel());
        frame.add(createColoredSquaresPanel());
        frame.add(createColoredRectanglesPanel());
        frame.add(createEditXAddCloseMinusGoSquaredPanel());
        frame.add(createEditXAddCloseMinusGoRectanglePanel());
        frame.add(createDiceButtonRectanglePanel());
        frame.add(createDiceButtonSquaredPanel());
        frame.add(createBoxedPlusMinusPanelRectangle());
        frame.add(createBoxedPlusMinusPanelSquare());
        frame.add(createHorizontalLeftRightUpDownSquare());
        frame.add(createVerticalLeftRightUpDownSquare());

        frame.setPreferredSize(new Dimension(400, 900));
        frame.pack();
        frame.setVisible(true);
    }

    /** Erstellt ein Panel mit Navigationselementen. */
    private Component createNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createFirstButton(true));
        panel.add(createPreviousButton(true));
        panel.add(createNextButton(true));
        panel.add(createLastButton(true));
        panel.add(createFirstButton(false));
        panel.add(createPreviousButton(false));
        panel.add(createNextButton(false));
        panel.add(createLastButton(false));

        return panel;
    }

    private JButton createFirstButton(boolean horizontal) {
        FirstButton button = new FirstButton();
        button.setHorizontal(horizontal);
        return button;
    }

    private JButton createPreviousButton(boolean horizontal) {
        PreviousButton button = new PreviousButton();
        button.setHorizontal(horizontal);
        return button;
    }

    private JButton createNextButton(boolean horizontal) {
        NextButton button = new NextButton();
        button.setHorizontal(horizontal);
        return button;
    }

    private JButton createLastButton(boolean horizontal) {
        LastButton button = new LastButton();
        button.setHorizontal(horizontal);
        return button;
    }

    /** Erstellt ein Panel mit farbigen Quadraten. */
    private Component createColoredSquaresPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createColoredSquareButton(true, Color.WHITE));
        panel.add(createColoredSquareButton(true, Color.LIGHT_GRAY));
        panel.add(createColoredSquareButton(true, Color.DARK_GRAY));
        panel.add(createColoredSquareButton(true, Color.BLACK));
        panel.add(createColoredSquareButton(true, Color.RED));
        panel.add(createColoredSquareButton(true, Color.GREEN));
        panel.add(createColoredSquareButton(true, Color.BLUE));
        panel.add(createColoredSquareButton(true, Color.ORANGE));

        return panel;
    }

    private Component createColoredSquareButton(boolean forceSquare, Color color) {
        SquareButton button = new SquareButton(color);
        button.setForceSquare(forceSquare);
        return button;
    }

    /** Erstellt ein Panel mit farbigen Rechtecken. */
    private Component createColoredRectanglesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createColoredSquareButton(false, Color.WHITE));
        panel.add(createColoredSquareButton(false, Color.LIGHT_GRAY));
        panel.add(createColoredSquareButton(false, Color.DARK_GRAY));
        panel.add(createColoredSquareButton(false, Color.BLACK));
        panel.add(createColoredSquareButton(false, Color.RED));
        panel.add(createColoredSquareButton(false, Color.GREEN));
        panel.add(createColoredSquareButton(false, Color.BLUE));
        panel.add(createColoredSquareButton(false, Color.ORANGE));

        return panel;
    }

    /** Erstellt einen Panel mit Edit-Stift, zwei Lösch-Buttons und einem Go-Button. */
    private Component createEditXAddCloseMinusGoSquaredPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(new EditButton());
        panel.add(new PlusButton());
        panel.add(new XButton());
        panel.add(new MinusButton());
        panel.add(new GoButton());

        return panel;
    }

    private Component createEditXAddCloseMinusGoRectanglePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createSquaredButton(new EditButton()));
        panel.add(createSquaredButton(new PlusButton()));
        panel.add(createSquaredButton(new XButton()));
        panel.add(createSquaredButton(new MinusButton()));
        panel.add(createSquaredButton(new GoButton()));

        return panel;
    }

    JButton createSquaredButton(PaintedButton button) {
        button.setForceSquare(true);
        return button;
    }

    JButton createSquaredHorizontalButton(PaintedButton button) {
        button.setForceSquare(true);
        button.setHorizontal(true);
        return button;
    }

    JButton createSquaredVerticalButton(PaintedButton button) {
        button.setForceSquare(true);
        button.setHorizontal(false);
        return button;
    }

    private Component createTextButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 2));

        panel.add(new TextButton("edit"));
        panel.add(new TextButton("add"));
        panel.add(new TextButton("delete"));
        panel.add(new TextButton("view"));

        return panel;
    }

    private Component createDiceButtonSquaredPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 3));

        panel.add(new DiceButton(RollValue.ONE));
        panel.add(new DiceButton(RollValue.TWO));
        panel.add(new DiceButton(RollValue.THREE));
        panel.add(new DiceButton(RollValue.FOUR));
        panel.add(new DiceButton(RollValue.FIVE));
        panel.add(new DiceButton(RollValue.SIX));

        return panel;
    }

    private Component createDiceButtonRectanglePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 3));

        panel.add(createDiceButtonNonSquare(RollValue.ONE));
        panel.add(createDiceButtonNonSquare(RollValue.TWO));
        panel.add(createDiceButtonNonSquare(RollValue.THREE));
        panel.add(createDiceButtonNonSquare(RollValue.FOUR));
        panel.add(createDiceButtonNonSquare(RollValue.FIVE));
        panel.add(createDiceButtonNonSquare(RollValue.SIX));

        return panel;
    }

    private Component createDiceButtonNonSquare(RollValue value) {
        DiceButton button = new DiceButton(value);
        button.setForceSquare(false);
        return button;
    }

    private Component createBoxedPlusMinusPanelRectangle() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(new PlusInABoxButton());
        panel.add(new PlusInABoxButton(Color.RED));
        panel.add(new XInABoxButton());
        panel.add(new MinusInABoxButton());

        return panel;
    }

    private Component createBoxedPlusMinusPanelSquare() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createSquaredButton(new PlusInABoxButton()));
        panel.add(createSquaredButton(new PlusInABoxButton(Color.RED)));
        panel.add(createSquaredButton(new XInABoxButton()));
        panel.add(createSquaredButton(new MinusInABoxButton()));

        return panel;
    }

    private Component createHorizontalLeftRightUpDownSquare() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createSquaredHorizontalButton(new GoButton()));
        panel.add(createSquaredHorizontalButton(new GoBackButton()));
        panel.add(createSquaredHorizontalButton(new UpButton()));
        panel.add(createSquaredHorizontalButton(new DownButton()));

        return panel;
    }

    private Component createVerticalLeftRightUpDownSquare() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 4));

        panel.add(createSquaredVerticalButton(new GoButton()));
        panel.add(createSquaredVerticalButton(new GoBackButton()));
        panel.add(createSquaredVerticalButton(new UpButton()));
        panel.add(createSquaredVerticalButton(new DownButton()));

        return panel;
    }

}
