package de.duehl.vocabulary.japanese.common.website.download;

import java.util.List;

import de.duehl.basics.text.Text;
import de.duehl.html.download.Downloader;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadStatus;

/**
 * Diese Klasse lädt den Inhalt von Dateien vom Webserver.
 *
 * @version 1.01     2024-11-11
 * @author Christian Dühl
 */

public class WebsiteFileContentDownloader {

    public static final String NO_DOWNLOAD_SUCCESS = "Kein Erfolg beim Download!";

    /**
     * Lädt den Inhalt einer Datei unter der angegebenen URL von der Webseite herunter.
     *
     * Hatte das Herunterladen keinen Erfolg, so wird NO_DOWNLOAD_SUCCESS zurückgegeben.
     */
    public static String downloadFileViaUrlFromServer(String url) {
        Downloader downloader = new Downloader(url)
                //.setLogger(logger)
                //.useProxy(PROXY_40)
                .disableRedirectHandling()
                //.multipleDownloadTries(10, 120)
                ;
        DownloadInfo info = downloader.download();
        /*
        System.out.println("Status: " + info.getStatus().getStatusCode() + " - "
                + info.getStatus().getDescription());
        System.out.println("Original-Status-Code: " + info.getOriginalHttpStatusCode());
        System.out.println("Originale Url : " + info.getUrl());
        System.out.println("Redirected Url: " + info.getReturnedUrl());
        System.out.println("Seitentext:\n" + info.getContent());
        */

        if (info.getStatus() == DownloadStatus.OK) {
            String content = info.getContent();
            return content;
        }
        else {
            return NO_DOWNLOAD_SUCCESS;
        }
    }

    /**
     * Lädt den Inhalt einer Datei unter der angegebenen URL von der Webseite herunter und gibt die
     * erste Zeile zurück.
     *
     * Hatte das Herunterladen keinen Erfolg, so wird NO_DOWNLOAD_SUCCESS zurückgegeben.
     */
    public static String downloadFileViaUrlFromServerAndGetContentOfFirstLine(String url) {
        String content = downloadFileViaUrlFromServer(url);
        if (content.equals(NO_DOWNLOAD_SUCCESS)) {
            return NO_DOWNLOAD_SUCCESS;
        }
        else {
            List<String> lines = Text.splitByLineBreaks(content);
            if (lines.isEmpty()) {
                return NO_DOWNLOAD_SUCCESS;
            }
            else {
                return lines.get(0).trim();
            }
        }
    }

}
