package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;

/**
 * Diese Klasse erzeugt das Datei-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-04-29
 * @author Christian Dühl
 */

public class FileMenuCreation implements SingleMenuCreation {

    /** Verbindung zur Logik des Editors. */
    private final VocabularyTrainerLogic logic;

    /**
     * Konstruktor.
     *
     * @param logic
     *            Verbindung zur Logik.
     */
    public FileMenuCreation(VocabularyTrainerLogic logic) {
        this.logic = logic;
    }

    /** Erzeugt das Datei-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Datei");
        menu.setMnemonic('d');

        //menu.addSeparator();

        menu.add(createExitMenuItem());

        return menu;
    }

    private JMenuItem createExitMenuItem() {
        return new MyMenuItem("Programm beenden")
                .mnemonic('b')
                .accelerator(KeyEvent.VK_F4, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> logic.quit());
    }

}
