package de.duehl.vocabulary.japanese.ui.dialog.detail;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Point;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;

/**
 * Diese Klasse zeigt eine Vokabel mit den zugehörigen benutzerabhängigen Daten in einem modalen
 * Dialog an.
 *
 * @version 1.01     2025-09-22
 * @author Christian Dühl
 */

public class VocableWithInternaDialog extends ModalDialogBase {

    /** Die Programmoptionen. */
    private final Options options;

    /** Das Objekt das zu einer Vokabel die internen, benutzerabhängigen Daten abrufen kann. */
    private final InternalDataRequester requester;

    /** Die anzuzeigende Vokabel. */
    private final Vocable vocable;

    /** Die Verwaltung der eigenen Vokabellisten. */
    private final OwnLists ownLists;

    /** Das Objekt das zu einer Vokabel die internen, benutzerabhängigen Daten abrufen kann. */
    private final InternalKanjiDataRequester kanjiRequester;

    /** Das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann. */
    private final MessageSetter messageSetter;

    /**
     * Konstruktor.
     *
     * @param options
     *            Die Programmoptionen.
     * @param requester
     *            Das Objekt das zu einer Vokabel die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param vocable
     *            Die anzuzeigende Vokabel.
     * @param ownLists
     *            Die Verwaltung der eigenen Vokabellisten.
     * @param kanjiRequester
     *            Das Objekt das zu einer Vokabel die internen, benutzerabhängigen Daten abrufen
     *            kann.
     * @param messageSetter
     *            Das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann.
     * @param parentLocation
     *            Die Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Das anzuzeigende ProgrammIcon.
     */
    public VocableWithInternaDialog(Options options, InternalDataRequester requester,
            Vocable vocable, OwnLists ownLists, InternalKanjiDataRequester kanjiRequester,
            MessageSetter messageSetter, Point parentLocation, Image programImage) {
        super(parentLocation, programImage,
                "Ansicht einer Vokabel mit den zugehörigen benutzerabhängigen Daten",
                VocableWithInternaPanel.DIALOG_DIMENSION);
        addEscapeBehaviour();

        this.options = options;
        this.requester = requester;
        this.vocable = vocable;
        this.ownLists = ownLists;
        this.kanjiRequester = kanjiRequester;
        this.messageSetter = messageSetter;

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        VocableWithInternaPanel internalPanel = new VocableWithInternaPanel(this, options,
                requester, vocable, ownLists, kanjiRequester, getWindowAsComponent(), messageSetter,
                getLocation(), getProgramImage(), (LongTimeProcessInformer) this);
        add(internalPanel.getPanel(), BorderLayout.CENTER);
    }

}
