/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.zip;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.data.ZipArchive;
import de.duehl.basics.logic.PrintErrorHandler;
import de.duehl.basics.system.starter.CmdStarter;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class ZipFilesWith7Zip {
    static final String DEFAULT_PATH_TO_7_ZIP = "\\\\Cluster1\\Projekte1\\HRTag\\HR_Strukt_HuP\\CD\\auslieferung\\bin\\7z\\7za.exe";
    private final String pathTo7Zip;
    private List<String> createdFilenames;
    private boolean cypher;
    private String password;
    private boolean create7zFile;
    private String command;

    public ZipFilesWith7Zip() {
        this(DEFAULT_PATH_TO_7_ZIP);
    }

    public ZipFilesWith7Zip(String string) {
        this.pathTo7Zip = string;
        this.createdFilenames = new ArrayList<String>();
        this.cypher = false;
        this.create7zFile = false;
        this.command = "";
    }

    public void cypher(String string) {
        if (string.contains(" ")) {
            throw new IllegalArgumentException("Das Passwort darf keine Leerzeichen beinhalten, weil sonst die Verwendung auf der Kommandozeile nicht wie gew\u00fcnscht funktioniert.");
        }
        this.cypher = true;
        this.password = string;
    }

    public void create7zFile() {
        this.create7zFile = true;
    }

    public void zip(ZipArchive zipArchive) {
        String string = zipArchive.getArchiveFilename();
        this.createCommandLine(zipArchive);
        CmdStarter cmdStarter = new CmdStarter(new PrintErrorHandler());
        String string2 = FileHelper.getDirName(string);
        String string3 = FileHelper.getBareName(string);
        String string4 = "zip_" + FileHelper.exchangeExtension(string3, ".txt");
        String string5 = "zip_" + FileHelper.exchangeExtension(string3, ".err");
        String string6 = FileHelper.concatPathes(string2, string4);
        String string7 = FileHelper.concatPathes(string2, string5);
        cmdStarter.runAndWait(this.command, string6, string7);
        this.createdFilenames.add(string6);
        this.createdFilenames.add(string7);
    }

    private void createCommandLine(ZipArchive zipArchive) {
        Object object;
        String string;
        String string2 = this.create7zFile ? "-t7z " : "-tzip ";
        if (this.cypher) {
            string = this.create7zFile ? "-mhe " : "";
            object = "-p" + this.password + " " + string;
        } else {
            object = "";
        }
        string = zipArchive.getArchiveFilename();
        this.command = this.pathTo7Zip + " a " + (String)object + string2 + string + " " + Text.joinWithBlank(zipArchive.getFilesToZip());
    }

    public List<String> getCreatedFilenames() {
        return this.createdFilenames;
    }

    public String getCommand() {
        return this.command;
    }
}

