/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.launcher;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.PrintErrorHandler;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.system.starter.CmdStarter;
import de.duehl.basics.text.Text;
import java.util.List;

public class JarStarter {
    private final String jarFilename;
    private String command;
    private boolean success;
    private List<String> parameters;

    public JarStarter(String string, String ... stringArray) {
        if (FileHelper.isBareFilename(string)) {
            String string2 = SystemTools.getCurrentWorkingDirectory();
            this.jarFilename = FileHelper.concatPathes(string2, string);
        } else {
            this.jarFilename = string;
        }
        this.parameters = CollectionsHelper.arrayToList(stringArray);
    }

    public void start() {
        String string = SystemTools.determineRunningJavaExecutable();
        if (string.isBlank()) {
            throw new RuntimeException("Die Java-Executable konnte nicht ermittelt werden.");
        }
        this.command = "\"" + string + "\" -jar " + this.jarFilename + this.createParameterPart();
        CmdStarter cmdStarter = new CmdStarter(new PrintErrorHandler());
        String string2 = cmdStarter.runAndForget(this.command);
        if (string2.isBlank()) {
            Text.say("Konnte nicht gestartet werden: " + this.command);
            this.success = false;
        } else {
            this.success = true;
        }
    }

    private String createParameterPart() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.parameters) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getCommand() {
        return this.command;
    }
}

