/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.data;

import de.duehl.html.download.data.DownloadStatus;

public class DownloadInfo {
    private DownloadStatus status;
    private int originalHttpStatusCode;
    private final String url;
    private String returnedUrl;
    private String content;
    private String redirectUrlToFollow;

    public DownloadInfo(String string) {
        this.url = string;
        this.status = DownloadStatus.NOT_LOADED;
        this.originalHttpStatusCode = -1;
        this.returnedUrl = "";
        this.redirectUrlToFollow = "";
        this.content = "";
    }

    public void storeResult(DownloadStatus downloadStatus, int n, String string, String string2, String string3) {
        this.status = downloadStatus;
        this.originalHttpStatusCode = n;
        this.returnedUrl = string;
        this.content = string2;
        this.redirectUrlToFollow = string3;
    }

    public void failed() {
        this.status = DownloadStatus.FAILURE;
    }

    public void pageNotFound() {
        this.status = DownloadStatus.PAGE_NOT_FOUND;
    }

    public void downloadCanceled() {
        this.status = DownloadStatus.DOWNLOAD_CANCELED;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public int getOriginalHttpStatusCode() {
        return this.originalHttpStatusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public String getReturnedUrl() {
        return this.returnedUrl;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isDownloadSuccessfull() {
        return this.status == DownloadStatus.OK;
    }

    public boolean isDownloadCanceled() {
        return this.status == DownloadStatus.DOWNLOAD_CANCELED;
    }

    public boolean isRedirect() {
        return this.originalHttpStatusCode == 301 || this.originalHttpStatusCode == 302 || this.originalHttpStatusCode == 303 || this.originalHttpStatusCode == 307 || this.originalHttpStatusCode == 200 && !this.redirectUrlToFollow.isEmpty();
    }

    public String getRedirectUrlToFollow() {
        return this.redirectUrlToFollow;
    }

    public String toString() {
        return "DownloadInfo [status=" + this.status + ", originalHttpStatusCode=" + this.originalHttpStatusCode + ", url=" + this.url + ", returnedUrl=" + this.returnedUrl + ", content=" + this.content + ", redirectUrlToFollow=" + this.redirectUrlToFollow + "]";
    }

    public String toStringWithoutContent() {
        return "DownloadInfo [status=" + this.status + ", originalHttpStatusCode=" + this.originalHttpStatusCode + ", url=" + this.url + ", returnedUrl=" + this.returnedUrl + ", redirectUrlToFollow=" + this.redirectUrlToFollow + "]";
    }
}

