/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.colors;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.colors.ElementColors;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class Colorizer {
    public static final String GENERAL = "GENERAL";
    public static final String RIGHT = "RIGHT";
    public static final String WRONG = "WRONG";
    public static final String WARN = "WARN";
    public static final String WARN_HIGH = "WARN_HIGH";
    public static final String GREY = "GREY";
    private Map<String, ElementColors> colors = new HashMap<String, ElementColors>();

    public Colorizer() {
        this.initColors();
    }

    protected void initColors() {
        Color color = new Color(0, 0, 150);
        Color color2 = new Color(230, 230, 255);
        ElementColors elementColors = new ElementColors(color, color2);
        this.addNewColortype(GENERAL, elementColors);
        color = new Color(0, 150, 0);
        color2 = new Color(230, 255, 230);
        elementColors = new ElementColors(color, color2);
        this.addNewColortype(RIGHT, elementColors);
        color = new Color(150, 0, 0);
        color2 = new Color(255, 230, 230);
        elementColors = new ElementColors(color, color2);
        this.addNewColortype(WRONG, elementColors);
        color = new Color(150, 150, 0);
        color2 = new Color(255, 255, 230);
        elementColors = new ElementColors(color, color2);
        this.addNewColortype(WARN, elementColors);
        color = new Color(200, 200, 0);
        color2 = new Color(255, 255, 230);
        elementColors = new ElementColors(color, color2);
        this.addNewColortype(WARN_HIGH, elementColors);
        color = new Color(150, 150, 150);
        color2 = new Color(255, 255, 255);
        elementColors = new ElementColors(color, color2);
        this.addNewColortype(GREY, elementColors);
    }

    public boolean addNewColortype(String string, ElementColors elementColors) {
        if (this.colors.containsKey(string)) {
            return false;
        }
        this.colors.put(string, elementColors);
        return true;
    }

    public boolean overwriteColortype(String string, ElementColors elementColors) {
        if (this.colors.containsKey(string)) {
            this.colors.put(string, elementColors);
            return true;
        }
        return false;
    }

    public void setColorsForType(String string, ElementColors elementColors) {
        this.colors.put(string, elementColors);
    }

    public Color getForegroundColor() {
        return this.colors.get(GENERAL).getForegroundColor();
    }

    public Color getBackgroundColor() {
        return this.colors.get(GENERAL).getBackgroundColor();
    }

    public Color getForegroundColor(String string) {
        ElementColors elementColors = this.colors.get(string);
        Color color = elementColors.getForegroundColor();
        return color;
    }

    public Color getBackgroundColor(String string) {
        ElementColors elementColors = this.colors.get(string);
        Color color = elementColors.getBackgroundColor();
        return color;
    }

    public void setColors(Component component) {
        this.setColorsOfComponentByType(GENERAL, component);
    }

    public void setColorsRight(Component component) {
        this.setColorsOfComponentByType(RIGHT, component);
    }

    public void setColorsWrong(Component component) {
        this.setColorsOfComponentByType(WRONG, component);
    }

    public void setColorsWarn(Component component) {
        this.setColorsOfComponentByType(WARN, component);
    }

    public void setColorsWarnHigh(Component component) {
        this.setColorsOfComponentByType(WARN_HIGH, component);
    }

    public void setColorsGrey(Component component) {
        this.setColorsOfComponentByType(GREY, component);
    }

    public void setColorsOfComponentByType(String string, Component component) {
        ElementColors elementColors = this.colors.get(string);
        Color color = elementColors.getForegroundColor();
        Color color2 = elementColors.getBackgroundColor();
        component.setForeground(color);
        component.setBackground(color2);
    }

    public void setInverseColorsOfComponentByType(String string, Component component) {
        ElementColors elementColors = this.colors.get(string);
        Color color = elementColors.getBackgroundColor();
        Color color2 = elementColors.getForegroundColor();
        component.setForeground(color);
        component.setBackground(color2);
    }

    public void setStandardBorder(JPanel jPanel, String string) {
        Color color = this.getForegroundColor();
        GuiTools.createTitle(string, jPanel, color);
    }

    public String getHTMLColor(Color color) {
        String string = "#" + ColorTool.javaColorToHexColor(color);
        return string;
    }

    public void setEditFieldColors(JTextComponent jTextComponent) {
        GuiTools.setEditFieldColors(jTextComponent);
    }

    public void setEditAreaColors(JTextArea jTextArea) {
        GuiTools.setEditAreaColors(jTextArea);
    }
}

